/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.frequency;

import java.util.List;
import org.talend.dataquality.common.inference.Analyzer;
import org.talend.dataquality.common.inference.ResizableList;
import org.talend.dataquality.statistics.frequency.AbstractFrequencyStatistics;

public abstract class AbstractFrequencyAnalyzer<T extends AbstractFrequencyStatistics>
implements Analyzer<T> {
    private static final long serialVersionUID = 5073865267265592024L;
    protected ResizableList<T> freqTableStatistics;

    protected abstract void initFreqTableList(int var1);

    public void init() {
        if (this.freqTableStatistics != null) {
            this.freqTableStatistics.clear();
        }
    }

    public boolean analyze(String ... record) {
        if (record == null) {
            return true;
        }
        if (this.freqTableStatistics == null || this.freqTableStatistics.isEmpty()) {
            this.initFreqTableList(record.length);
        }
        for (int i = 0; i < record.length; ++i) {
            AbstractFrequencyStatistics freqStats = (AbstractFrequencyStatistics)this.freqTableStatistics.get(i);
            this.analyzeField(record[i], freqStats);
        }
        return true;
    }

    protected void analyzeField(String field, T freqStats) {
        ((AbstractFrequencyStatistics)freqStats).add(field);
    }

    public void end() {
    }

    public List<T> getResult() {
        return this.freqTableStatistics;
    }

    public void close() {
    }
}

