/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.frequency.pattern;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.talend.dataquality.common.inference.ResizableList;
import org.talend.dataquality.semantic.recognizer.LFUCache;
import org.talend.dataquality.statistics.frequency.AbstractFrequencyAnalyzer;
import org.talend.dataquality.statistics.frequency.pattern.PatternFrequencyStatistics;
import org.talend.dataquality.statistics.frequency.recognition.AbstractPatternRecognizer;
import org.talend.dataquality.statistics.frequency.recognition.DateTimePatternRecognizer;
import org.talend.dataquality.statistics.frequency.recognition.EmptyPatternRecognizer;
import org.talend.dataquality.statistics.frequency.recognition.GenericCharPatternRecognizer;
import org.talend.dataquality.statistics.frequency.recognition.RecognitionResult;
import org.talend.dataquality.statistics.type.DataTypeEnum;

public class CompositePatternFrequencyAnalyzer
extends AbstractFrequencyAnalyzer<PatternFrequencyStatistics> {
    private static final long serialVersionUID = -4658709249927616622L;
    private List<AbstractPatternRecognizer> patternFreqRecognizers = new ArrayList<AbstractPatternRecognizer>();
    private final ResizableList<LFUCache> knownPatternCaches = new ResizableList(LFUCache.class);
    private DataTypeEnum[] types;

    public CompositePatternFrequencyAnalyzer() {
        this(new DataTypeEnum[0]);
    }

    public CompositePatternFrequencyAnalyzer(DataTypeEnum[] types) {
        this.patternFreqRecognizers.add(new EmptyPatternRecognizer());
        this.patternFreqRecognizers.add(new DateTimePatternRecognizer());
        this.patternFreqRecognizers.add(new GenericCharPatternRecognizer());
        this.types = types;
    }

    public CompositePatternFrequencyAnalyzer(List<AbstractPatternRecognizer> analyzerList) {
        this(analyzerList, new DataTypeEnum[0]);
    }

    public CompositePatternFrequencyAnalyzer(List<AbstractPatternRecognizer> analyzerList, DataTypeEnum[] types) {
        this.patternFreqRecognizers.addAll(analyzerList);
        this.types = types;
    }

    @Override
    public boolean analyze(String ... record) {
        if (record == null) {
            return true;
        }
        if (CollectionUtils.isEmpty((Collection)this.freqTableStatistics)) {
            this.initFreqTableList(record.length);
        }
        this.knownPatternCaches.resize(record.length);
        for (int i = 0; i < record.length; ++i) {
            LFUCache knownPatternCache = (LFUCache)this.knownPatternCaches.get(i);
            Map knownPatterns = (Map)knownPatternCache.get((Object)record[i]);
            PatternFrequencyStatistics freqStats = (PatternFrequencyStatistics)this.freqTableStatistics.get(i);
            if (MapUtils.isNotEmpty((Map)knownPatterns)) {
                knownPatterns.entrySet().forEach(knownPattern -> freqStats.add((Map.Entry<String, Locale>)knownPattern));
                continue;
            }
            if (this.types.length > 0) {
                this.analyzeField(record[i], freqStats, this.types[i], (LFUCache<String, Map<String, Locale>>)knownPatternCache);
                continue;
            }
            this.analyzeField(record[i], freqStats, null, (LFUCache<String, Map<String, Locale>>)knownPatternCache);
        }
        return true;
    }

    protected void analyzeField(String field, PatternFrequencyStatistics freqStats, DataTypeEnum type, LFUCache<String, Map<String, Locale>> knownPatternCache) {
        Map<String, Locale> patternSet = this.getValuePatternSet(field, type);
        for (Map.Entry<String, Locale> patternAndLocale : patternSet.entrySet()) {
            freqStats.add(patternAndLocale);
        }
        knownPatternCache.put((Object)field, patternSet);
    }

    @Override
    protected void analyzeField(String field, PatternFrequencyStatistics freqStats) {
        for (Map.Entry<String, Locale> patternAndLocale : this.getValuePatternSet(field).entrySet()) {
            freqStats.add(patternAndLocale);
        }
    }

    Map<String, Locale> getValuePatternSet(String originalValue) {
        return this.getValuePatternSet(originalValue, null);
    }

    private Map<String, Locale> getValuePatternSet(String originalValue, DataTypeEnum type) {
        Map<String, Locale> resultMap = new HashMap<String, Locale>();
        String patternString = originalValue;
        for (AbstractPatternRecognizer recognizer : this.patternFreqRecognizers) {
            RecognitionResult result = recognizer.recognize(patternString, type);
            resultMap = result.getPatternToLocale();
            if (result.isComplete()) break;
            if (resultMap.isEmpty()) continue;
            patternString = resultMap.keySet().iterator().next();
        }
        return resultMap;
    }

    @Override
    protected void initFreqTableList(int size) {
        ArrayList<PatternFrequencyStatistics> freqTableList = new ArrayList<PatternFrequencyStatistics>();
        for (int i = 0; i < size; ++i) {
            PatternFrequencyStatistics freqTable = new PatternFrequencyStatistics();
            freqTableList.add(freqTable);
        }
        this.freqTableStatistics = new ResizableList(freqTableList);
    }
}

