/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.frequency.recognition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.talend.dataquality.statistics.datetime.SystemDateTimePatternManager;
import org.talend.dataquality.statistics.frequency.recognition.AbstractPatternRecognizer;
import org.talend.dataquality.statistics.frequency.recognition.RecognitionResult;
import org.talend.dataquality.statistics.type.DataTypeEnum;
import org.talend.dataquality.statistics.type.SortedList;

public class DateTimePatternRecognizer
extends AbstractPatternRecognizer {
    private List<String> customDateTimePatterns = new ArrayList<String>();
    private final SortedList<Map<Pattern, String>> frequentDatePatterns = new SortedList();

    @Deprecated
    public void addCustomDateTimePattern(String pattern) {
        this.customDateTimePatterns.add(pattern);
    }

    @Deprecated
    public void addCustomDateTimePatterns(List<String> patterns) {
        this.customDateTimePatterns.addAll(patterns);
    }

    @Deprecated
    public List<String> getCustomDateTimePattern() {
        return this.customDateTimePatterns;
    }

    @Override
    public RecognitionResult recognize(String stringToRecognize) {
        return this.recognize(stringToRecognize, DataTypeEnum.DATE);
    }

    @Override
    public RecognitionResult recognize(String stringToRecognize, DataTypeEnum type) {
        RecognitionResult result = new RecognitionResult();
        if (type != null && !DataTypeEnum.DATE.equals((Object)type)) {
            result.setResult(Collections.singleton(stringToRecognize), false);
            return result;
        }
        if (stringToRecognize != null && stringToRecognize.length() > 6) {
            Map<String, Locale> datePatternAfterReplace = SystemDateTimePatternManager.getDatePatterns(stringToRecognize, this.frequentDatePatterns);
            result.setResult(MapUtils.isNotEmpty(datePatternAfterReplace) ? datePatternAfterReplace : Collections.singletonMap(stringToRecognize, null), MapUtils.isNotEmpty(datePatternAfterReplace));
        }
        return result;
    }

    @Override
    protected Set<String> getValuePattern(String originalValue) {
        RecognitionResult result = this.recognize(originalValue);
        return result.getPatternStringSet();
    }
}

