/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.numeric.histogram;

import java.util.List;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataquality.common.inference.ResizableList;
import org.talend.dataquality.statistics.numeric.NumericalStatisticsAnalyzer;
import org.talend.dataquality.statistics.numeric.histogram.HistogramColumnParameter;
import org.talend.dataquality.statistics.numeric.histogram.HistogramParameter;
import org.talend.dataquality.statistics.numeric.histogram.HistogramStatistics;
import org.talend.dataquality.statistics.type.DataTypeEnum;
import org.talend.dataquality.statistics.type.TypeInferenceUtils;

public class HistogramAnalyzer
extends NumericalStatisticsAnalyzer<HistogramStatistics> {
    private static final long serialVersionUID = -3756520692420812485L;
    private ResizableList<HistogramStatistics> stats = new ResizableList(HistogramStatistics.class);
    private HistogramParameter histogramParameter = null;

    public HistogramAnalyzer(DataTypeEnum[] types, HistogramParameter histogramParameter) {
        super(types);
        if (histogramParameter == null) {
            throw new IllegalArgumentException("Histogram analyzer's parameter should is null.");
        }
        this.setParameters(histogramParameter);
    }

    private void setParameters(HistogramParameter histogramParameter) {
        this.histogramParameter = histogramParameter;
    }

    public boolean analyze(String ... record) {
        DataTypeEnum[] types = this.getTypes();
        if (record.length != types.length) {
            throw new IllegalArgumentException("Each column of the record should be declared a DataType.Type corresponding! \n" + types.length + " type(s) declared in this histogram analyzer but " + record.length + " column(s) was found in this record. \nUsing method: setTypes(DataType.Type[] types) to set the types. ");
        }
        if (this.stats.resize(record.length)) {
            int colIdx = 0;
            for (HistogramStatistics stat : this.stats) {
                HistogramColumnParameter columnParameter = this.histogramParameter.getColumnParameter(colIdx);
                double max = this.histogramParameter.getDefaultMax();
                double min = this.histogramParameter.getDefaultMin();
                int numBins = this.histogramParameter.getDefaultNumBins();
                if (columnParameter != null) {
                    min = columnParameter.getMin();
                    max = columnParameter.getMax();
                    numBins = columnParameter.getNumBins();
                }
                stat.setParameters(max, min, numBins);
                ++colIdx;
            }
        }
        Integer[] integerArray = this.getStatColIdx();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int idx = integerArray[i];
            if (!TypeInferenceUtils.isValid(types[idx], record[idx])) continue;
            this.analyzerHistogram(idx, record);
        }
        return true;
    }

    private void analyzerHistogram(int index, String ... record) {
        HistogramStatistics histStats = (HistogramStatistics)this.stats.get(index);
        try {
            histStats.add(BigDecimalParser.toBigDecimal((String)record[index]).doubleValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void end() {
    }

    public List<HistogramStatistics> getResult() {
        return this.stats;
    }
}

