/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.numeric.histogram;

import java.util.HashMap;
import java.util.Map;
import org.talend.dataquality.statistics.numeric.histogram.HistogramColumnParameter;

public class HistogramParameter {
    private double defaultMin = Double.MIN_VALUE;
    private double defaultMax = Double.MAX_VALUE;
    private int defaultNumBins = 10;
    private Map<Integer, HistogramColumnParameter> columnParameters = new HashMap<Integer, HistogramColumnParameter>();

    public double getDefaultMin() {
        return this.defaultMin;
    }

    public double getDefaultMax() {
        return this.defaultMax;
    }

    public int getDefaultNumBins() {
        return this.defaultNumBins;
    }

    public void setDefaultParameters(double defaultMin, double defaultMax, int defaultNumBins) {
        if (defaultMax < defaultMin || defaultNumBins < 0) {
            throw new IllegalArgumentException("Max = " + defaultMax + ", Min = " + defaultMin + ", numBins =" + defaultNumBins + "\n Max must greater than Min and numBins must be a positive integers(>0)!");
        }
        this.defaultMin = defaultMin;
        this.defaultMax = defaultMax;
        this.defaultNumBins = defaultNumBins;
    }

    public void putColumnParameter(Integer columnIdx, HistogramColumnParameter columnParameter) {
        this.columnParameters.put(columnIdx, columnParameter);
    }

    public HistogramColumnParameter getColumnParameter(Integer columnIndex) {
        return this.columnParameters.get(columnIndex);
    }
}

