/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.numeric.histogram;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.LinkedHashMap;
import java.util.Map;
import org.talend.dataquality.statistics.exception.DQStatisticsRuntimeException;
import org.talend.dataquality.statistics.numeric.histogram.Range;

public class HistogramStatistics {
    private double min;
    private double max;
    private int numBins;
    private long countBelowMin;
    private long countAboveMax;
    private long[] result;
    private BigDecimal binSize;
    int scale;

    public HistogramStatistics() {
        this.result = new long[this.numBins];
        this.scale = 1000;
    }

    public void setParameters(double max, double min, int numBins) {
        if (max <= min) {
            throw new DQStatisticsRuntimeException("max must be greater than min");
        }
        if (numBins <= 0) {
            throw new DQStatisticsRuntimeException("invalid numBins value :" + numBins + " , numBins must be a none zero integer");
        }
        this.max = max;
        this.min = min;
        this.numBins = numBins;
        this.binSize = BigDecimal.valueOf(max - min).divide(BigDecimal.valueOf(numBins), 10, RoundingMode.UP);
        this.result = new long[numBins];
    }

    public void add(double d) {
        double bin = BigDecimal.valueOf(d - this.min).divide(this.binSize, 10, RoundingMode.UP).doubleValue();
        if (bin < 0.0) {
            ++this.countBelowMin;
        } else if (bin > (double)this.numBins) {
            ++this.countAboveMax;
        } else if (Double.compare(bin, this.numBins) == 0) {
            int n = (int)bin - 1;
            this.result[n] = this.result[n] + 1L;
        } else {
            int n = (int)bin;
            this.result[n] = this.result[n] + 1L;
        }
    }

    public Map<Range, Long> getHistogram() {
        LinkedHashMap<Range, Long> histogramMap = new LinkedHashMap<Range, Long>();
        double currentMin = this.min;
        for (int i = 0; i < this.numBins; ++i) {
            double currentMax = currentMin + this.binSize.doubleValue();
            if (i + 1 == this.numBins) {
                currentMax = this.max;
            }
            Range r = new Range(currentMin, currentMax);
            histogramMap.put(r, this.result[i]);
            currentMin += this.binSize.doubleValue();
        }
        return histogramMap;
    }

    public boolean isComplete() {
        return this.countBelowMin == 0L && this.countAboveMax == 0L;
    }

    public long getCountBelowMin() {
        return this.countBelowMin;
    }

    public long getCountAboveMax() {
        return this.countAboveMax;
    }
}

