/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.numeric.quantile;

import java.util.List;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataquality.common.inference.ResizableList;
import org.talend.dataquality.statistics.numeric.NumericalStatisticsAnalyzer;
import org.talend.dataquality.statistics.numeric.quantile.QuantileStatistics;
import org.talend.dataquality.statistics.type.DataTypeEnum;
import org.talend.dataquality.statistics.type.TypeInferenceUtils;

public class QuantileAnalyzer
extends NumericalStatisticsAnalyzer<QuantileStatistics> {
    private static final long serialVersionUID = 6841816568752139978L;
    private final ResizableList<QuantileStatistics> stats = new ResizableList(QuantileStatistics.class);

    public QuantileAnalyzer(DataTypeEnum[] types) {
        super(types);
    }

    @Override
    public void init() {
        super.init();
        this.stats.clear();
    }

    public boolean analyze(String ... record) {
        DataTypeEnum[] types = this.getTypes();
        if (record.length != types.length) {
            throw new IllegalArgumentException("Each column of the record should be declared a DataType.Type corresponding! \n" + types.length + " type(s) declared in this quantile analyzer but " + record.length + " column(s) was found in this record. \nUsing method: setTypes(DataType.Type[] types) to set the types.");
        }
        this.stats.resize(record.length);
        Integer[] integerArray = this.getStatColIdx();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int idx = integerArray[i];
            if (!TypeInferenceUtils.isValid(types[idx], record[idx])) continue;
            QuantileStatistics freqStats = (QuantileStatistics)this.stats.get(idx);
            try {
                freqStats.add(BigDecimalParser.toBigDecimal((String)record[idx]).doubleValue());
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return true;
    }

    public void end() {
        for (QuantileStatistics qs : this.stats) {
            qs.endAddValue();
        }
    }

    public List<QuantileStatistics> getResult() {
        return this.stats;
    }
}

