/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.numeric.summary;

import java.util.List;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataquality.common.inference.ResizableList;
import org.talend.dataquality.statistics.numeric.NumericalStatisticsAnalyzer;
import org.talend.dataquality.statistics.numeric.summary.SummaryStatistics;
import org.talend.dataquality.statistics.type.DataTypeEnum;
import org.talend.dataquality.statistics.type.TypeInferenceUtils;

public class SummaryAnalyzer
extends NumericalStatisticsAnalyzer<SummaryStatistics> {
    private static final long serialVersionUID = 8369753525474844077L;
    private final ResizableList<SummaryStatistics> summaryStats = new ResizableList(SummaryStatistics.class);

    public SummaryAnalyzer(DataTypeEnum[] types) {
        super(types);
    }

    @Override
    public void init() {
        super.init();
        this.summaryStats.clear();
    }

    public boolean analyze(String ... record) {
        DataTypeEnum[] types = this.getTypes();
        if (record.length != types.length) {
            throw new IllegalArgumentException("Each column of the record should be declared a DataType.Type corresponding! \n" + types.length + " type(s) declared in this summary analyzer but " + record.length + " column(s) was found in this record. \nUsing method: setTypes(DataType.Type[] types) to set the types.");
        }
        this.summaryStats.resize(record.length);
        Integer[] integerArray = this.getStatColIdx();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int idx = integerArray[i];
            if (!TypeInferenceUtils.isValid(types[idx], record[idx])) continue;
            SummaryStatistics stats = (SummaryStatistics)this.summaryStats.get(idx);
            try {
                stats.addData(BigDecimalParser.toBigDecimal((String)record[idx]).doubleValue());
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return true;
    }

    public void end() {
    }

    public List<SummaryStatistics> getResult() {
        return this.summaryStats;
    }
}

