/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.type;

import java.util.ArrayList;
import java.util.List;
import org.talend.dataquality.common.inference.Analyzer;
import org.talend.dataquality.common.inference.ResizableList;
import org.talend.dataquality.semantic.recognizer.LFUCache;
import org.talend.dataquality.statistics.datetime.SystemDateTimePatternManager;
import org.talend.dataquality.statistics.type.DataTypeEnum;
import org.talend.dataquality.statistics.type.DataTypeOccurences;
import org.talend.dataquality.statistics.type.SortedList;
import org.talend.dataquality.statistics.type.TypeInferenceUtils;

public class DataTypeAnalyzer
implements Analyzer<DataTypeOccurences> {
    private static final long serialVersionUID = 373694310453353502L;
    private final ResizableList<DataTypeOccurences> dataTypeResults = new ResizableList(DataTypeOccurences.class);
    private final ResizableList<SortedList> frequentDatePatterns = new ResizableList(SortedList.class);
    protected List<String> customDateTimePatterns = new ArrayList<String>();
    private final ResizableList<LFUCache> knownDataTypeCaches = new ResizableList(LFUCache.class);

    public DataTypeAnalyzer() {
    }

    @Deprecated
    public DataTypeAnalyzer(List<String> customDateTimePatterns) {
        this.customDateTimePatterns.addAll(customDateTimePatterns);
    }

    public void init() {
        this.dataTypeResults.clear();
        this.frequentDatePatterns.clear();
        this.knownDataTypeCaches.clear();
    }

    public boolean analyzeArray(String[] record) {
        return this.analyze(record);
    }

    public boolean analyze(String ... record) {
        if (record == null) {
            return true;
        }
        this.dataTypeResults.resize(record.length);
        this.frequentDatePatterns.resize(record.length);
        this.knownDataTypeCaches.resize(record.length);
        for (int i = 0; i < record.length; ++i) {
            String value;
            DataTypeOccurences dataType = (DataTypeOccurences)this.dataTypeResults.get(i);
            LFUCache knownDataTypeCache = (LFUCache)this.knownDataTypeCaches.get(i);
            DataTypeEnum knownDataType = (DataTypeEnum)((Object)knownDataTypeCache.get((Object)(value = record[i])));
            if (knownDataType != null) {
                dataType.increment(knownDataType);
                continue;
            }
            DataTypeEnum type = TypeInferenceUtils.getNativeDataType(value);
            if (DataTypeEnum.STRING.equals((Object)type) && SystemDateTimePatternManager.isDate(value, (SortedList)this.frequentDatePatterns.get(i))) {
                type = DataTypeEnum.DATE;
            }
            knownDataTypeCache.put((Object)value, (Object)type);
            dataType.increment(type);
        }
        return true;
    }

    public void end() {
    }

    public List<DataTypeOccurences> getResult() {
        return this.dataTypeResults;
    }

    public void close() throws Exception {
    }
}

