/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.type;

import java.math.BigInteger;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.talend.dataquality.statistics.datetime.CustomDateTimePatternManager;
import org.talend.dataquality.statistics.datetime.SystemDateTimePatternManager;
import org.talend.dataquality.statistics.type.DataTypeEnum;

public class TypeInferenceUtils {
    private static final Pattern patternInteger = Pattern.compile("^(\\+|-)?\\d+$");
    private static final Pattern patternDouble = Pattern.compile("^[-+]?([0-9]+([,\\.][0-9]+)?|([0-9]{1,3}(((,[0-9]{3})*(\\.[0-9]+)?|((\\.[0-9]{3})*|([ \u00a0\u2007\u202f][0-9]{3})*)(,[0-9]+)?))))([ ]?[eE][-+]?[0-9]+)?([ ]?%)?$");

    public static boolean isDouble(String value) {
        return !TypeInferenceUtils.isEmpty(value) && patternDouble.matcher(value).matches();
    }

    public static boolean isInteger(String value) {
        return !TypeInferenceUtils.isEmpty(value) && patternInteger.matcher(value).matches();
    }

    public static boolean isNumber(String value) {
        return TypeInferenceUtils.isDouble(value) || TypeInferenceUtils.isInteger(value);
    }

    public static BigInteger getBigInteger(String value) {
        BigInteger bint = null;
        try {
            bint = new BigInteger(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return bint;
    }

    public static boolean isBoolean(String value) {
        if (TypeInferenceUtils.isEmpty(value)) {
            return false;
        }
        return !(value.trim().length() != 4 && value.trim().length() != 5 || !"true".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value));
    }

    public static boolean isDate(String value) {
        return SystemDateTimePatternManager.isDate(value);
    }

    @Deprecated
    public static boolean isDate(String value, List<String> customDatePatterns) {
        return CustomDateTimePatternManager.isDate(value, customDatePatterns);
    }

    @Deprecated
    public static boolean isDate(String value, List<String> customDatePatterns, Locale locale) {
        return CustomDateTimePatternManager.isDate(value, customDatePatterns, locale);
    }

    public static boolean isTime(String value) {
        return SystemDateTimePatternManager.isTime(value);
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean isValid(DataTypeEnum type, String value) {
        switch (type) {
            case BOOLEAN: {
                return TypeInferenceUtils.isBoolean(value);
            }
            case INTEGER: {
                return TypeInferenceUtils.isInteger(value);
            }
            case DOUBLE: {
                return TypeInferenceUtils.isDouble(value);
            }
            case DATE: {
                return TypeInferenceUtils.isDate(value);
            }
            case STRING: {
                return true;
            }
        }
        return false;
    }

    public static DataTypeEnum getDataType(String value) {
        DataTypeEnum dataTypeEnum = TypeInferenceUtils.getNativeDataType(value);
        if (DataTypeEnum.STRING.equals((Object)dataTypeEnum)) {
            if (TypeInferenceUtils.isDate(value)) {
                dataTypeEnum = DataTypeEnum.DATE;
            } else if (TypeInferenceUtils.isTime(value)) {
                dataTypeEnum = DataTypeEnum.TIME;
            }
        }
        return dataTypeEnum;
    }

    @Deprecated
    public static DataTypeEnum getDataType(String value, List<String> customDateTimePatterns) {
        DataTypeEnum dataTypeEnum = TypeInferenceUtils.getNativeDataType(value);
        if (DataTypeEnum.STRING.equals((Object)dataTypeEnum)) {
            if (TypeInferenceUtils.isDate(value, customDateTimePatterns)) {
                dataTypeEnum = DataTypeEnum.DATE;
            } else if (TypeInferenceUtils.isTime(value)) {
                dataTypeEnum = DataTypeEnum.TIME;
            }
        }
        return dataTypeEnum;
    }

    public static DataTypeEnum getNativeDataType(String value) {
        if (TypeInferenceUtils.isEmpty(value)) {
            return DataTypeEnum.EMPTY;
        }
        if (TypeInferenceUtils.isBoolean(value)) {
            return DataTypeEnum.BOOLEAN;
        }
        if (TypeInferenceUtils.isInteger(value)) {
            return DataTypeEnum.INTEGER;
        }
        if (TypeInferenceUtils.isDouble(value)) {
            return DataTypeEnum.DOUBLE;
        }
        return DataTypeEnum.STRING;
    }
}

