/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.dynamodb.DynamoDBUtil;
import org.apache.hadoop.io.Writable;

public class DynamoDBItemWritable
implements Writable,
Serializable {
    public static final Type type = new TypeToken<Map<String, AttributeValue>>(){}.getType();
    static final String START_OF_TEXT = Character.toString('\u0002');
    static final String END_OF_TEXT = Character.toString('\u0003');
    private Map<String, AttributeValue> dynamoDBItem = new HashMap<String, AttributeValue>();

    public void readFields(DataInput in) throws IOException {
        this.readFieldsStream(in.readUTF());
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.writeStream());
    }

    public void readFieldsStream(String string) {
        Gson gson = DynamoDBUtil.getGson();
        String itemJson = this.fixMalformedJson(string);
        this.dynamoDBItem = (Map)gson.fromJson(itemJson, type);
    }

    public String writeStream() {
        Gson gson = DynamoDBUtil.getGson();
        return gson.toJson(this.dynamoDBItem, type);
    }

    public Map<String, AttributeValue> getItem() {
        return this.dynamoDBItem;
    }

    public void setItem(Map<String, AttributeValue> dynamoDBItem) {
        this.dynamoDBItem = dynamoDBItem;
    }

    public String toString() {
        return this.writeStream();
    }

    private String fixMalformedJson(String string) {
        if (!(string = string.trim()).startsWith("{")) {
            string = "{" + string + "}";
            string = string.replaceAll(START_OF_TEXT, ",");
            string = string.replaceAll(END_OF_TEXT, ":");
        }
        return string;
    }
}

