/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb;

import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.util.EC2MetadataUtils;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dynamodb.DynamoDBConstants;
import org.apache.hadoop.dynamodb.util.ClusterTopologyNodeCapacityProvider;
import org.apache.hadoop.dynamodb.util.RoundRobinYarnContainerAllocator;
import org.apache.hadoop.dynamodb.util.TaskCalculator;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public final class DynamoDBUtil {
    public static final String CHARACTER_ENCODING = "UTF-8";
    private static final Log log = LogFactory.getLog(DynamoDBUtil.class);
    private static final Gson gson;

    public static Double calculateAverageItemSize(TableDescription description) {
        if (description.getItemCount() != 0L) {
            return (double)description.getTableSizeBytes().longValue() / (double)description.getItemCount().longValue();
        }
        return 0.0;
    }

    public static String base64EncodeByteArray(byte[] bytes) {
        try {
            byte[] encodeBase64 = Base64.encodeBase64((byte[])bytes);
            return new String(encodeBase64, CHARACTER_ENCODING);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while encoding bytes: " + Arrays.toString(bytes));
        }
    }

    public static byte[] base64DecodeString(String base64String) {
        try {
            return Base64.decodeBase64((byte[])base64String.getBytes(CHARACTER_ENCODING));
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while decoding " + base64String);
        }
    }

    public static ByteBuffer base64StringToByteBuffer(String base64EncodedKey) {
        return ByteBuffer.wrap(DynamoDBUtil.base64DecodeString(base64EncodedKey));
    }

    public static List<ByteBuffer> base64StringToByteBuffer(String ... base64EncodedKeys) {
        ArrayList<ByteBuffer> byteBuffers = new ArrayList<ByteBuffer>(base64EncodedKeys.length);
        for (String base64EncodedKey : base64EncodedKeys) {
            byteBuffers.add(DynamoDBUtil.base64StringToByteBuffer(base64EncodedKey));
        }
        return byteBuffers;
    }

    public static Gson getGson() {
        return gson;
    }

    static int getItemSizeBytes(Map<String, AttributeValue> item) {
        try {
            int itemSize = 0;
            for (Map.Entry<String, AttributeValue> entry : item.entrySet()) {
                itemSize += entry.getKey().getBytes(CHARACTER_ENCODING).length;
                itemSize += DynamoDBUtil.getAttributeSizeBytes(entry.getValue());
            }
            return itemSize;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void verifyInterval(long intervalBeginTime, long intervalLength) {
        long interval = intervalBeginTime + intervalLength;
        long currentDateTime = new DateTime(DateTimeZone.UTC).getMillis();
        if (currentDateTime < interval) {
            try {
                Thread.sleep(interval - currentDateTime);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting ", e);
            }
        }
    }

    private static int getAttributeSizeBytes(AttributeValue att) throws UnsupportedEncodingException {
        int byteSize;
        block4: {
            block8: {
                block7: {
                    block6: {
                        block5: {
                            block3: {
                                byteSize = 0;
                                if (att.getN() == null) break block3;
                                byteSize += att.getN().getBytes(CHARACTER_ENCODING).length;
                                break block4;
                            }
                            if (att.getS() == null) break block5;
                            byteSize += att.getS().getBytes(CHARACTER_ENCODING).length;
                            break block4;
                        }
                        if (att.getB() == null) break block6;
                        byteSize += att.getB().array().length;
                        break block4;
                    }
                    if (att.getNS() == null) break block7;
                    for (String number : att.getNS()) {
                        byteSize += number.getBytes(CHARACTER_ENCODING).length;
                    }
                    break block4;
                }
                if (att.getSS() == null) break block8;
                for (String string : att.getSS()) {
                    byteSize += string.getBytes(CHARACTER_ENCODING).length;
                }
                break block4;
            }
            if (att.getBS() == null) break block4;
            for (ByteBuffer byteBuffer : att.getBS()) {
                byteSize += byteBuffer.array().length;
            }
        }
        return byteSize;
    }

    static long getBoundedBatchLimit(Configuration config, long batchSize) {
        long maxItemsPerBatch = config.getLong("dynamodb.max.batch.items", 25L);
        return Math.min(Math.max(batchSize, 1L), maxItemsPerBatch);
    }

    public static String getValueFromConf(Configuration conf, String confKey, String defaultValue) {
        if (conf == null) {
            return defaultValue;
        }
        return conf.get(confKey, defaultValue);
    }

    public static String getValueFromConf(Configuration conf, String confKey) {
        return DynamoDBUtil.getValueFromConf(conf, confKey, null);
    }

    public static String getDynamoDBEndpoint(Configuration conf, String region) {
        String endpoint = DynamoDBUtil.getValueFromConf(conf, "dynamodb.endpoint");
        if (Strings.isNullOrEmpty((String)endpoint)) {
            if (Strings.isNullOrEmpty((String)region)) {
                region = DynamoDBUtil.getValueFromConf(conf, "dynamodb.region");
            }
            if (Strings.isNullOrEmpty((String)region)) {
                region = DynamoDBUtil.getValueFromConf(conf, "dynamodb.regionid");
            }
            if (Strings.isNullOrEmpty((String)region)) {
                try {
                    region = EC2MetadataUtils.getEC2InstanceRegion();
                }
                catch (Exception e) {
                    log.warn((Object)String.format("Exception when attempting to get AWS region information. Will ignore and default to %s", DynamoDBConstants.DEFAULT_AWS_REGION), (Throwable)e);
                }
            }
            if (Strings.isNullOrEmpty((String)region)) {
                region = DynamoDBConstants.DEFAULT_AWS_REGION;
            }
            endpoint = RegionUtils.getRegion((String)region).getServiceEndpoint("dynamodb");
        }
        log.info((Object)("Using endpoint for DynamoDB: " + endpoint));
        return endpoint;
    }

    public static JobClient createJobClient(JobConf jobConf) {
        try {
            return new JobClient(jobConf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int calcMaxMapTasks(JobClient jobClient) throws IOException {
        JobConf conf = (JobConf)jobClient.getConf();
        ClusterTopologyNodeCapacityProvider nodeCapacityProvider = new ClusterTopologyNodeCapacityProvider(conf);
        RoundRobinYarnContainerAllocator yarnContainerAllocator = new RoundRobinYarnContainerAllocator();
        TaskCalculator taskCalculator = new TaskCalculator(jobClient, nodeCapacityProvider, yarnContainerAllocator);
        return taskCalculator.getMaxMapTasks();
    }

    private DynamoDBUtil() {
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(ByteBuffer.class, (Object)new ByteBufferSerializer());
        gsonBuilder.registerTypeAdapter(ByteBuffer.class, (Object)new ByteBufferDeserializer());
        gson = gsonBuilder.disableHtmlEscaping().create();
    }

    private static class ByteBufferDeserializer
    implements JsonDeserializer<ByteBuffer> {
        private ByteBufferDeserializer() {
        }

        public ByteBuffer deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            String base64String = jsonElement.getAsJsonPrimitive().getAsString();
            return DynamoDBUtil.base64StringToByteBuffer(base64String);
        }
    }

    private static class ByteBufferSerializer
    implements JsonSerializer<ByteBuffer> {
        private ByteBufferSerializer() {
        }

        public JsonElement serialize(ByteBuffer byteBuffer, Type type, JsonSerializationContext context) {
            String base64String = DynamoDBUtil.base64EncodeByteArray(byteBuffer.array());
            return new JsonPrimitive(base64String);
        }
    }
}

