/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb;

import java.util.Random;
import org.apache.hadoop.dynamodb.DynamoDBOperationType;
import org.apache.hadoop.dynamodb.IopsCalculator;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class IopsController {
    private final IopsCalculator iopsCalculator;
    private final Duration iopsUpdateDuration;
    private final DynamoDBOperationType operationType;
    private DateTime lastUpdateTime;
    private double targetIops;
    private double targetItemsPerSecond;

    public IopsController(IopsCalculator iopsCalculator, double averageItemSizeInBytes, DynamoDBOperationType operationType) {
        this.iopsCalculator = iopsCalculator;
        this.operationType = operationType;
        this.iopsUpdateDuration = this.getUpdateDuration();
        this.lastUpdateTime = this.getCurrentTime();
        this.targetIops = iopsCalculator.calculateTargetIops();
        if (averageItemSizeInBytes < 1.0) {
            averageItemSizeInBytes = 100.0;
        }
        double bytesPerIO = DynamoDBOperationType.READ == operationType ? 4096.0 : 1024.0;
        double itemsPerIO = bytesPerIO / averageItemSizeInBytes;
        this.targetItemsPerSecond = IopsController.calculateTargetItemsPerSecond(operationType, this.targetIops, itemsPerIO);
    }

    public static double calculateTargetItemsPerSecond(DynamoDBOperationType operationType, double targetIops, double itemsPerIO) {
        double result;
        if (DynamoDBOperationType.WRITE.equals((Object)operationType) && itemsPerIO > 1.0) {
            itemsPerIO = 1.0;
        }
        if ((result = targetIops * itemsPerIO) < 1.0) {
            result = 1.0;
        }
        return result;
    }

    public long getTargetItemsPerSecond() {
        return (long)this.targetItemsPerSecond;
    }

    public void update(long itemsPerSecond, double iopsConsumed) {
        DateTime currentTime = this.getCurrentTime();
        if (currentTime.isAfter((ReadableInstant)this.lastUpdateTime.plus((ReadableDuration)this.iopsUpdateDuration))) {
            this.lastUpdateTime = currentTime;
            this.targetIops = this.iopsCalculator.calculateTargetIops();
        }
        if (itemsPerSecond != 0L && iopsConsumed != 0.0) {
            double itemsPerIO = (double)itemsPerSecond / iopsConsumed;
            this.targetItemsPerSecond = IopsController.calculateTargetItemsPerSecond(this.operationType, this.targetIops, itemsPerIO);
        }
    }

    private Duration getUpdateDuration() {
        Random random = new Random(System.currentTimeMillis());
        long randomDuration = random.nextInt(300000);
        return Duration.standardMinutes((long)5L).plus(randomDuration);
    }

    private DateTime getCurrentTime() {
        return new DateTime(DateTimeZone.UTC);
    }
}

