/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.preader;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.dynamodb.preader.PageResults;

public class PageResultMultiplexer<V> {
    private static final Log log = LogFactory.getLog(PageResultMultiplexer.class);
    private final int batchSize;
    private final int capacity;
    private final BlockingQueue<PageResults<V>> pages;
    private final AtomicInteger pageCount = new AtomicInteger();
    private final Object removeItemLock = new Object();
    private long itemsReturned = 0L;
    private volatile boolean draining = false;
    private volatile Iterator<PageResults<V>> pageIterator;

    public PageResultMultiplexer(int batchSize, int capacity) {
        this.batchSize = batchSize;
        this.capacity = capacity;
        this.pages = new LinkedBlockingQueue<PageResults<V>>(capacity);
        this.pageIterator = this.pages.iterator();
    }

    public boolean addPageResults(PageResults<V> page) {
        boolean admitted = this.pages.offer(page);
        if (!admitted) {
            try {
                log.info((Object)"Blocking on page add, mux full.");
                this.pages.put(page);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error((Object)"Page add was interrupted");
                return false;
            }
        }
        this.pageCount.incrementAndGet();
        log.info((Object)("Added a page. Page count: " + this.pageCount.get()));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V next() throws IOException {
        if (this.itemsReturned % 10000L == 0L) {
            log.info((Object)("Pagemux stats: items=" + this.itemsReturned + ", pages=" + this.pageCount.get() + ", cap=" + this.capacity));
        }
        Object object = this.removeItemLock;
        synchronized (object) {
            this.waitForMuxCondition();
            while (!this.draining || this.pageCount.get() != 0) {
                PageResults<V> nextPage;
                try {
                    nextPage = this.pageIterator.next();
                }
                catch (NoSuchElementException e) {
                    this.pageIterator = this.pages.iterator();
                    continue;
                }
                if (nextPage.exception != null) {
                    throw new IOException(nextPage.exception);
                }
                V nextItem = nextPage.next();
                if (!nextPage.hasMore()) {
                    this.pageCount.decrementAndGet();
                    this.pageIterator.remove();
                }
                if (nextItem == null) continue;
                ++this.itemsReturned;
                return nextItem;
            }
        }
        return null;
    }

    public void setDraining(boolean draining) {
        this.draining = draining;
    }

    private void waitForMuxCondition() {
        while (this.pageCount.get() < this.batchSize && !this.draining) {
            try {
                log.info((Object)("Sleeping on consumption condition, pagecount = " + this.pageCount.get()));
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

