/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.preader;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.dynamodb.preader.TokenBucket;
import org.apache.hadoop.dynamodb.util.AbstractTimeSource;

public class RateController {
    static final double MIN_RCU_PER_REQ = 1.0;
    private static final double MAX_RCU_PER_REQ = 25.0;
    private static final Log log = LogFactory.getLog(RateController.class);
    private static final double ITEM_SIZE_SMOOTH_FACTOR = 0.7;
    private final double targetRate;
    private final TokenBucket bucket;
    private double avgItemSizeBytes;

    public RateController(AbstractTimeSource time, double targetRate, int windowSize, double avgItemSizeBytes) {
        this.targetRate = targetRate;
        this.avgItemSizeBytes = avgItemSizeBytes;
        double capacity = Math.max(targetRate * (double)windowSize, 1.0);
        this.bucket = new TokenBucket(targetRate, capacity, time);
        log.info((Object)("Rate controller initialized. target rate=" + targetRate + ", bucket capacity=" + capacity));
    }

    RequestLimit getNextRequestLimit() {
        double rcu = this.bucket.acquire(1.0, 25.0);
        if (rcu < 1.0) {
            return RequestLimit.ZERO;
        }
        double items = this.getBytesFromRcu(rcu) / this.avgItemSizeBytes;
        items = Math.max(1.0, Math.floor(items));
        return new RequestLimit((int)items, rcu);
    }

    void adjust(double permittedReadUnits, double consumedReadUnits, int items) {
        double oldAvg = this.avgItemSizeBytes;
        this.avgItemSizeBytes = this.avgItemSizeBytes * 0.7 + this.estimateAvgItemSize(consumedReadUnits, items) * 0.30000000000000004;
        log.debug((Object)("report: permitted=" + permittedReadUnits + ", consumed=" + consumedReadUnits + ", items=" + items + ", avg from= " + oldAvg + " to " + this.avgItemSizeBytes));
        double adjustment = permittedReadUnits - consumedReadUnits;
        if (Math.abs(adjustment) > 0.1) {
            double tokens = this.bucket.forceUpdate(adjustment);
            log.debug((Object)("Adjusting token bucket, adjustment= " + adjustment + ", permittedReadUnits=" + permittedReadUnits + ", consumedReadUnits=" + consumedReadUnits + ", avgItem=" + this.avgItemSizeBytes + ", tokens=" + tokens));
        }
    }

    double getTargetRate() {
        return this.targetRate;
    }

    double getAvgItemSize() {
        return this.avgItemSizeBytes;
    }

    private double estimateAvgItemSize(double consumedReadUnits, int items) {
        return this.getBytesFromRcu(consumedReadUnits) / (double)items;
    }

    private double getBytesFromRcu(double rcu) {
        return 8192.0 * rcu;
    }

    static class RequestLimit {
        static final RequestLimit ZERO = new RequestLimit(0, 0.0);
        public final int items;
        final double readCapacityUnits;

        RequestLimit(int items, double readCapacityUnits) {
            this.items = items;
            this.readCapacityUnits = readCapacityUnits;
        }
    }
}

