/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.preader;

import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.dynamodb.preader.AbstractReadManager;
import org.apache.hadoop.dynamodb.preader.AbstractRecordReadRequest;
import org.apache.hadoop.dynamodb.preader.RateController;
import org.apache.hadoop.mapred.Reporter;

public class ReadWorker
extends Thread {
    private static final int SLEEP_TIME_MS = 80;
    private static final int SLEEP_JITTER_MS = 40;
    private static final Log log = LogFactory.getLog(ReadWorker.class);
    private static final AtomicInteger workerId = new AtomicInteger();
    protected final AbstractReadManager readMgr;
    private final Reporter reporter;
    private final Random rnd = new Random();
    protected volatile boolean alive = true;

    public ReadWorker(AbstractReadManager mgr, Reporter reporter) {
        super("ReadWorker-" + workerId.incrementAndGet());
        this.readMgr = mgr;
        this.reporter = reporter;
    }

    @Override
    public void run() {
        while (this.alive) {
            try {
                this.runInternal();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            catch (Throwable e) {
                log.error((Object)"Unknown exception thrown!", e);
            }
        }
        log.info((Object)"Worker shutting down, no longer alive");
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    private void runInternal() throws Throwable {
        AbstractRecordReadRequest req;
        if (this.reporter != null) {
            this.reporter.progress();
        }
        if ((req = this.readMgr.dequeueReadRequest()) == null) {
            log.info((Object)"Worker found read request queue empty, sleeping.");
            Thread.sleep(this.getSleepTime());
            return;
        }
        RateController.RequestLimit lim = this.readMgr.rateController.getNextRequestLimit();
        if (lim == RateController.RequestLimit.ZERO) {
            log.info((Object)"No read token from rate controller. Putting the request back");
            this.readMgr.enqueueReadRequestToHead(req);
            Thread.sleep(this.getSleepTime());
            return;
        }
        req.read(lim);
    }

    private long getSleepTime() {
        int base = 40;
        int jitter = this.rnd.nextInt(80);
        return base + jitter;
    }
}

