/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.json;

import com.google.api.client.http.HttpParser;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonParser;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonHttpParser
implements HttpParser {
    private final String contentType;
    private final JsonFactory jsonFactory;

    public JsonHttpParser(JsonFactory jsonFactory) {
        this(jsonFactory, "application/json");
    }

    protected JsonHttpParser(JsonFactory jsonFactory, String contentType) {
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory);
        this.contentType = contentType;
    }

    @Override
    public final String getContentType() {
        return this.contentType;
    }

    @Override
    public <T> T parse(HttpResponse response, Class<T> dataClass) throws IOException {
        return JsonHttpParser.parserForResponse(this.jsonFactory, response).parseAndClose(dataClass, null);
    }

    public final JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonParser parserForResponse(JsonFactory jsonFactory, HttpResponse response) throws IOException {
        InputStream content = response.getContent();
        try {
            JsonParser parser = jsonFactory.createJsonParser(content);
            parser.nextToken();
            content = null;
            JsonParser jsonParser = parser;
            return jsonParser;
        }
        finally {
            if (content != null) {
                content.close();
            }
        }
    }

    public static Builder builder(JsonFactory jsonFactory) {
        return new Builder(jsonFactory);
    }

    public static class Builder {
        private String contentType = "application/json";
        private final JsonFactory jsonFactory;

        protected Builder(JsonFactory jsonFactory) {
            this.jsonFactory = jsonFactory;
        }

        public JsonHttpParser build() {
            return new JsonHttpParser(this.jsonFactory, this.contentType);
        }

        public final String getContentType() {
            return this.contentType;
        }

        public Builder setContentType(String contentType) {
            this.contentType = (String)Preconditions.checkNotNull((Object)contentType);
            return this;
        }

        public final JsonFactory getJsonFactory() {
            return this.jsonFactory;
        }
    }
}

