/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.protobuf;

import com.google.api.client.http.HttpParser;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.protobuf.ProtocolBuffers;
import com.google.common.base.Preconditions;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtoHttpParser
implements HttpParser {
    private final String contentType;

    public ProtoHttpParser() {
        this.contentType = "application/x-protobuf";
    }

    protected ProtoHttpParser(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public final String getContentType() {
        return this.contentType;
    }

    @Override
    public <T> T parse(HttpResponse response, Class<T> dataClass) throws IOException {
        return ProtocolBuffers.parseAndClose(response.getContent(), dataClass);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String contentType = "application/x-protobuf";

        protected Builder() {
        }

        public ProtoHttpParser build() {
            return new ProtoHttpParser(this.contentType);
        }

        public final String getContentType() {
            return this.contentType;
        }

        public Builder setContentType(String contentType) {
            this.contentType = (String)Preconditions.checkNotNull((Object)contentType);
            return this;
        }
    }
}

