/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.testing.http;

import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.util.StringUtils;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockLowLevelHttpResponse
extends LowLevelHttpResponse {
    private InputStream content;
    private String contentType;
    private int statusCode = 200;
    private String reasonPhrase;
    private List<String> headerNames = new ArrayList<String>();
    private List<String> headerValues = new ArrayList<String>();
    private String contentEncoding;
    private long contentLength;

    public void addHeader(String name, String value) {
        this.headerNames.add((String)Preconditions.checkNotNull((Object)name));
        this.headerValues.add((String)Preconditions.checkNotNull((Object)value));
    }

    public MockLowLevelHttpResponse setContent(String stringContent) {
        this.content = stringContent == null ? null : new ByteArrayInputStream(StringUtils.getBytesUtf8(stringContent));
        return this;
    }

    @Override
    public InputStream getContent() throws IOException {
        return this.content;
    }

    @Override
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public final String getContentType() {
        return this.contentType;
    }

    @Override
    public int getHeaderCount() {
        return this.headerNames.size();
    }

    @Override
    public String getHeaderName(int index) {
        return this.headerNames.get(index);
    }

    @Override
    public String getHeaderValue(int index) {
        return this.headerValues.get(index);
    }

    @Override
    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getStatusLine() {
        StringBuilder buf = new StringBuilder(this.statusCode);
        if (this.reasonPhrase != null) {
            buf.append(this.reasonPhrase);
        }
        return buf.toString();
    }

    public final List<String> getHeaderNames() {
        return this.headerNames;
    }

    public MockLowLevelHttpResponse setHeaderNames(List<String> headerNames) {
        this.headerNames = (List)Preconditions.checkNotNull(headerNames);
        return this;
    }

    public final List<String> getHeaderValues() {
        return this.headerValues;
    }

    public MockLowLevelHttpResponse setHeaderValues(List<String> headerValues) {
        this.headerValues = (List)Preconditions.checkNotNull(headerValues);
        return this;
    }

    public MockLowLevelHttpResponse setContent(InputStream content) {
        this.content = content;
        return this;
    }

    public MockLowLevelHttpResponse setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public MockLowLevelHttpResponse setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public MockLowLevelHttpResponse setContentLength(long contentLength) {
        this.contentLength = contentLength;
        Preconditions.checkArgument((contentLength >= 0L ? 1 : 0) != 0);
        return this;
    }

    public MockLowLevelHttpResponse setStatusCode(int statusCode) {
        this.statusCode = statusCode;
        Preconditions.checkArgument((statusCode >= 0 ? 1 : 0) != 0);
        return this;
    }

    public MockLowLevelHttpResponse setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
        return this;
    }
}

