/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.FieldInfo;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassInfo {
    private static final Map<Class<?>, ClassInfo> CACHE = new WeakHashMap();
    private final Class<?> clazz;
    private final IdentityHashMap<String, FieldInfo> nameToFieldInfoMap = new IdentityHashMap();
    final List<String> names;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassInfo of(Class<?> underlyingClass) {
        if (underlyingClass == null) {
            return null;
        }
        Map<Class<?>, ClassInfo> map = CACHE;
        synchronized (map) {
            ClassInfo classInfo = CACHE.get(underlyingClass);
            if (classInfo == null) {
                classInfo = new ClassInfo(underlyingClass);
                CACHE.put(underlyingClass, classInfo);
            }
            return classInfo;
        }
    }

    public Class<?> getUnderlyingClass() {
        return this.clazz;
    }

    public FieldInfo getFieldInfo(String name) {
        return this.nameToFieldInfoMap.get(name == null ? null : name.intern());
    }

    public Field getField(String name) {
        FieldInfo fieldInfo = this.getFieldInfo(name);
        return fieldInfo == null ? null : fieldInfo.getField();
    }

    public boolean isEnum() {
        return this.clazz.isEnum();
    }

    public Collection<String> getNames() {
        return this.names;
    }

    private ClassInfo(Class<?> srcClass) {
        this.clazz = srcClass;
        TreeSet<String> nameSet = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String s0, String s1) {
                return s0 == s1 ? 0 : (s0 == null ? -1 : (s1 == null ? 1 : s0.compareTo(s1)));
            }
        });
        Class<?> superClass = srcClass.getSuperclass();
        if (superClass != null) {
            ClassInfo superClassInfo = ClassInfo.of(superClass);
            this.nameToFieldInfoMap.putAll(superClassInfo.nameToFieldInfoMap);
            nameSet.addAll(superClassInfo.names);
        }
        for (Field field : srcClass.getDeclaredFields()) {
            FieldInfo fieldInfo = FieldInfo.of(field);
            if (fieldInfo == null) continue;
            String fieldName = fieldInfo.getName();
            FieldInfo conflictingFieldInfo = this.nameToFieldInfoMap.get(fieldName);
            Preconditions.checkArgument((conflictingFieldInfo == null ? 1 : 0) != 0, (String)"two fields have the same name <%s>: %s and %s", (Object[])new Object[]{fieldName, field, conflictingFieldInfo == null ? null : conflictingFieldInfo.getField()});
            this.nameToFieldInfoMap.put(fieldName, fieldInfo);
            nameSet.add(fieldName);
        }
        this.names = nameSet.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(nameSet));
    }
}

