/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.AmazonServiceException;
import com.cloudera.com.amazonaws.ClientConfiguration;
import com.cloudera.com.amazonaws.Protocol;
import com.cloudera.com.amazonaws.auth.AWSCredentialsProviderChain;
import com.cloudera.com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.cloudera.com.amazonaws.event.ProgressEvent;
import com.cloudera.com.amazonaws.event.ProgressListener;
import com.cloudera.com.amazonaws.services.s3.AmazonS3Client;
import com.cloudera.com.amazonaws.services.s3.model.CannedAccessControlList;
import com.cloudera.com.amazonaws.services.s3.model.CopyObjectRequest;
import com.cloudera.com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.cloudera.com.amazonaws.services.s3.model.ListObjectsRequest;
import com.cloudera.com.amazonaws.services.s3.model.ObjectListing;
import com.cloudera.com.amazonaws.services.s3.model.ObjectMetadata;
import com.cloudera.com.amazonaws.services.s3.model.PutObjectRequest;
import com.cloudera.com.amazonaws.services.s3.model.S3ObjectSummary;
import com.cloudera.com.amazonaws.services.s3.transfer.Copy;
import com.cloudera.com.amazonaws.services.s3.transfer.TransferManager;
import com.cloudera.com.amazonaws.services.s3.transfer.TransferManagerConfiguration;
import com.cloudera.com.amazonaws.services.s3.transfer.Upload;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.s3a.AnonymousAWSCredentialsProvider;
import org.apache.hadoop.fs.s3a.BasicAWSCredentialsProvider;
import org.apache.hadoop.fs.s3a.S3AFastOutputStream;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3AInputStream;
import org.apache.hadoop.fs.s3a.S3AOutputStream;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3AFileSystem
extends FileSystem {
    public static final int DEFAULT_BLOCKSIZE = 0x2000000;
    private URI uri;
    private Path workingDir;
    private AmazonS3Client s3;
    private String bucket;
    private int maxKeys;
    private long partSize;
    private TransferManager transfers;
    private ThreadPoolExecutor threadPoolExecutor;
    private long multiPartThreshold;
    public static final Logger LOG = LoggerFactory.getLogger(S3AFileSystem.class);
    private CannedAccessControlList cannedACL;
    private String serverSideEncryptionAlgorithm;
    private static final int MAX_ENTRIES_TO_DELETE = 1000;
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private static final String DEPRECATED_ACCESS_KEY = "fs.s3a.awsAccessKeyId";
    private static final String DEPRECATED_SECRET_KEY = "fs.s3a.awsSecretAccessKey";

    public static ThreadFactory getNamedThreadFactory(final String prefix) {
        SecurityManager s = System.getSecurityManager();
        final ThreadGroup threadGroup = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        return new ThreadFactory(){
            final AtomicInteger threadNumber = new AtomicInteger(1);
            private final int poolNum = S3AFileSystem.access$000().getAndIncrement();
            final ThreadGroup group = threadGroup;

            @Override
            public Thread newThread(Runnable r) {
                String name = prefix + "-pool" + this.poolNum + "-t" + this.threadNumber.getAndIncrement();
                return new Thread(this.group, r, name);
            }
        };
    }

    private static ThreadFactory newDaemonThreadFactory(String prefix) {
        final ThreadFactory namedFactory = S3AFileSystem.getNamedThreadFactory(prefix);
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = namedFactory.newThread(r);
                if (!t.isDaemon()) {
                    t.setDaemon(true);
                }
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            }
        };
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        String userInfo;
        String secretKey;
        super.initialize(name, conf);
        this.uri = URI.create(name.getScheme() + "://" + name.getAuthority());
        this.workingDir = new Path("/user", System.getProperty("user.name")).makeQualified(this.uri, this.getWorkingDirectory());
        String accessKey = conf.get("fs.s3a.access.key", null);
        if (accessKey == null) {
            accessKey = conf.get(DEPRECATED_ACCESS_KEY, null);
        }
        if ((secretKey = conf.get("fs.s3a.secret.key", null)) == null) {
            secretKey = conf.get(DEPRECATED_SECRET_KEY, null);
        }
        if ((userInfo = name.getUserInfo()) != null) {
            int index = userInfo.indexOf(58);
            if (index != -1) {
                accessKey = userInfo.substring(0, index);
                secretKey = userInfo.substring(index + 1);
            } else {
                accessKey = userInfo;
            }
        }
        AWSCredentialsProviderChain credentials = new AWSCredentialsProviderChain(new BasicAWSCredentialsProvider(accessKey, secretKey), new InstanceProfileCredentialsProvider(), new AnonymousAWSCredentialsProvider());
        this.bucket = name.getHost();
        ClientConfiguration awsConf = new ClientConfiguration();
        awsConf.setMaxConnections(conf.getInt("fs.s3a.connection.maximum", 15));
        boolean secureConnections = conf.getBoolean("fs.s3a.connection.ssl.enabled", true);
        awsConf.setProtocol(secureConnections ? Protocol.HTTPS : Protocol.HTTP);
        awsConf.setMaxErrorRetry(conf.getInt("fs.s3a.attempts.maximum", 20));
        awsConf.setConnectionTimeout(conf.getInt("fs.s3a.connection.establish.timeout", 50000));
        awsConf.setSocketTimeout(conf.getInt("fs.s3a.connection.timeout", 200000));
        String signerOverride = conf.getTrimmed("fs.s3a.signing-algorithm", "");
        if (!signerOverride.isEmpty()) {
            awsConf.setSignerOverride(signerOverride);
        }
        String proxyHost = conf.getTrimmed("fs.s3a.proxy.host", "");
        int proxyPort = conf.getInt("fs.s3a.proxy.port", -1);
        if (!proxyHost.isEmpty()) {
            awsConf.setProxyHost(proxyHost);
            if (proxyPort >= 0) {
                awsConf.setProxyPort(proxyPort);
            } else if (secureConnections) {
                LOG.warn("Proxy host set without port. Using HTTPS default 443");
                awsConf.setProxyPort(443);
            } else {
                LOG.warn("Proxy host set without port. Using HTTP default 80");
                awsConf.setProxyPort(80);
            }
            String proxyUsername = conf.getTrimmed("fs.s3a.proxy.username");
            String proxyPassword = conf.getTrimmed("fs.s3a.proxy.password");
            if (proxyUsername == null != (proxyPassword == null)) {
                String msg = "Proxy error: fs.s3a.proxy.username or fs.s3a.proxy.password set without the other.";
                LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
            awsConf.setProxyUsername(proxyUsername);
            awsConf.setProxyPassword(proxyPassword);
            awsConf.setProxyDomain(conf.getTrimmed("fs.s3a.proxy.domain"));
            awsConf.setProxyWorkstation(conf.getTrimmed("fs.s3a.proxy.workstation"));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using proxy server {}:{} as user {} with password {} on domain {} as workstation {}", new Object[]{awsConf.getProxyHost(), awsConf.getProxyPort(), String.valueOf(awsConf.getProxyUsername()), awsConf.getProxyPassword(), awsConf.getProxyDomain(), awsConf.getProxyWorkstation()});
            }
        } else if (proxyPort >= 0) {
            String msg = "Proxy error: fs.s3a.proxy.port set without fs.s3a.proxy.host";
            LOG.error(msg);
            throw new IllegalArgumentException(msg);
        }
        this.s3 = new AmazonS3Client(credentials, awsConf);
        String endPoint = conf.getTrimmed("fs.s3a.endpoint", "");
        if (!endPoint.isEmpty()) {
            try {
                this.s3.setEndpoint(endPoint);
            }
            catch (IllegalArgumentException e) {
                String msg = "Incorrect endpoint: " + e.getMessage();
                LOG.error(msg);
                throw new IllegalArgumentException(msg, e);
            }
        }
        this.maxKeys = conf.getInt("fs.s3a.paging.maximum", 5000);
        this.partSize = conf.getLong("fs.s3a.multipart.size", 0x6400000L);
        this.multiPartThreshold = conf.getLong("fs.s3a.multipart.threshold", Integer.MAX_VALUE);
        if (this.partSize < 0x500000L) {
            LOG.error("fs.s3a.multipart.size must be at least 5 MB");
            this.partSize = 0x500000L;
        }
        if (this.multiPartThreshold < 0x500000L) {
            LOG.error("fs.s3a.multipart.threshold must be at least 5 MB");
            this.multiPartThreshold = 0x500000L;
        }
        int maxThreads = conf.getInt("fs.s3a.threads.max", 256);
        int coreThreads = conf.getInt("fs.s3a.threads.core", 15);
        if (maxThreads == 0) {
            maxThreads = Runtime.getRuntime().availableProcessors() * 8;
        }
        if (coreThreads == 0) {
            coreThreads = Runtime.getRuntime().availableProcessors() * 8;
        }
        long keepAliveTime = conf.getLong("fs.s3a.threads.keepalivetime", 60L);
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(maxThreads * conf.getInt("fs.s3a.max.total.tasks", 1000));
        this.threadPoolExecutor = new ThreadPoolExecutor(coreThreads, maxThreads, keepAliveTime, TimeUnit.SECONDS, workQueue, S3AFileSystem.newDaemonThreadFactory("s3a-transfer-shared-"));
        this.threadPoolExecutor.allowCoreThreadTimeOut(true);
        TransferManagerConfiguration transferConfiguration = new TransferManagerConfiguration();
        transferConfiguration.setMinimumUploadPartSize(this.partSize);
        transferConfiguration.setMultipartUploadThreshold(this.multiPartThreshold);
        this.transfers = new TransferManager(this.s3, this.threadPoolExecutor);
        this.transfers.setConfiguration(transferConfiguration);
        String cannedACLName = conf.get("fs.s3a.acl.default", "");
        this.cannedACL = !cannedACLName.isEmpty() ? CannedAccessControlList.valueOf(cannedACLName) : null;
        if (!this.s3.doesBucketExist(this.bucket)) {
            throw new IOException("Bucket " + this.bucket + " does not exist");
        }
        boolean purgeExistingMultipart = conf.getBoolean("fs.s3a.multipart.purge", false);
        long purgeExistingMultipartAge = conf.getLong("fs.s3a.multipart.purge.age", 14400L);
        if (purgeExistingMultipart) {
            Date purgeBefore = new Date(new Date().getTime() - purgeExistingMultipartAge * 1000L);
            this.transfers.abortMultipartUploads(this.bucket, purgeBefore);
        }
        this.serverSideEncryptionAlgorithm = conf.get("fs.s3a.server-side-encryption-algorithm");
        this.setConf(conf);
    }

    public String getScheme() {
        return "s3a";
    }

    public URI getUri() {
        return this.uri;
    }

    public int getDefaultPort() {
        return -1;
    }

    @VisibleForTesting
    AmazonS3Client getAmazonS3Client() {
        return this.s3;
    }

    private String pathToKey(Path path) {
        if (!path.isAbsolute()) {
            path = new Path(this.workingDir, path);
        }
        if (path.toUri().getScheme() != null && path.toUri().getPath().isEmpty()) {
            return "";
        }
        return path.toUri().getPath().substring(1);
    }

    private Path keyToPath(String key) {
        return new Path("/" + key);
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        S3AFileStatus fileStatus;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Opening '{}' for reading.", (Object)f);
        }
        if ((fileStatus = this.getFileStatus(f)).isDirectory()) {
            throw new FileNotFoundException("Can't open " + f + " because it is a directory");
        }
        return new FSDataInputStream((InputStream)((Object)new S3AInputStream(this.bucket, this.pathToKey(f), fileStatus.getLen(), this.s3, this.statistics)));
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        String key = this.pathToKey(f);
        if (!overwrite && this.exists(f)) {
            throw new FileAlreadyExistsException(f + " already exists");
        }
        if (this.getConf().getBoolean("fs.s3a.fast.upload", false)) {
            return new FSDataOutputStream((OutputStream)new S3AFastOutputStream(this.s3, this, this.bucket, key, progress, this.statistics, this.cannedACL, this.serverSideEncryptionAlgorithm, this.partSize, this.multiPartThreshold, this.threadPoolExecutor), this.statistics);
        }
        return new FSDataOutputStream((OutputStream)new S3AOutputStream(this.getConf(), this.transfers, this, this.bucket, key, progress, this.cannedACL, this.statistics, this.serverSideEncryptionAlgorithm), null);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        S3AFileStatus dstStatus;
        S3AFileStatus srcStatus;
        String dstKey;
        String srcKey;
        block31: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Rename path {} to {}", (Object)src, (Object)dst);
            }
            srcKey = this.pathToKey(src);
            dstKey = this.pathToKey(dst);
            if (srcKey.isEmpty() || dstKey.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("rename: src or dst are empty");
                }
                return false;
            }
            try {
                srcStatus = this.getFileStatus(src);
            }
            catch (FileNotFoundException e) {
                LOG.error("rename: src not found {}", (Object)src);
                return false;
            }
            if (srcKey.equals(dstKey)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("rename: src and dst refer to the same file or directory");
                }
                return srcStatus.isFile();
            }
            dstStatus = null;
            try {
                dstStatus = this.getFileStatus(dst);
                if (srcStatus.isDirectory() && dstStatus.isFile()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("rename: src is a directory and dst is a file");
                    }
                    return false;
                }
                if (dstStatus.isDirectory() && !dstStatus.isEmptyDirectory()) {
                    return false;
                }
            }
            catch (FileNotFoundException e) {
                Path parent = dst.getParent();
                if (this.pathToKey(parent).isEmpty()) break block31;
                try {
                    S3AFileStatus dstParentStatus = this.getFileStatus(dst.getParent());
                    if (!dstParentStatus.isDirectory()) {
                        return false;
                    }
                }
                catch (FileNotFoundException e2) {
                    return false;
                }
            }
        }
        if (srcStatus.isFile()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("rename: renaming file " + src + " to " + dst);
            }
            if (dstStatus != null && dstStatus.isDirectory()) {
                String newDstKey = dstKey;
                if (!newDstKey.endsWith("/")) {
                    newDstKey = newDstKey + "/";
                }
                String filename = srcKey.substring(this.pathToKey(src.getParent()).length() + 1);
                newDstKey = newDstKey + filename;
                this.copyFile(srcKey, newDstKey);
            } else {
                this.copyFile(srcKey, dstKey);
            }
            this.delete(src, false);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("rename: renaming directory " + src + " to " + dst);
            }
            if (!dstKey.endsWith("/")) {
                dstKey = dstKey + "/";
            }
            if (!srcKey.endsWith("/")) {
                srcKey = srcKey + "/";
            }
            if (dstKey.startsWith(srcKey)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("cannot rename a directory to a subdirectory of self");
                }
                return false;
            }
            ArrayList<DeleteObjectsRequest.KeyVersion> keysToDelete = new ArrayList<DeleteObjectsRequest.KeyVersion>();
            if (dstStatus != null && dstStatus.isEmptyDirectory()) {
                keysToDelete.add(new DeleteObjectsRequest.KeyVersion(dstKey));
            }
            ListObjectsRequest request = new ListObjectsRequest();
            request.setBucketName(this.bucket);
            request.setPrefix(srcKey);
            request.setMaxKeys(this.maxKeys);
            ObjectListing objects = this.s3.listObjects(request);
            this.statistics.incrementReadOps(1);
            while (true) {
                for (S3ObjectSummary summary : objects.getObjectSummaries()) {
                    keysToDelete.add(new DeleteObjectsRequest.KeyVersion(summary.getKey()));
                    String newDstKey = dstKey + summary.getKey().substring(srcKey.length());
                    this.copyFile(summary.getKey(), newDstKey);
                    if (keysToDelete.size() != 1000) continue;
                    DeleteObjectsRequest deleteRequest = new DeleteObjectsRequest(this.bucket).withKeys(keysToDelete);
                    this.s3.deleteObjects(deleteRequest);
                    this.statistics.incrementWriteOps(1);
                    keysToDelete.clear();
                }
                if (!objects.isTruncated()) break;
                objects = this.s3.listNextBatchOfObjects(objects);
                this.statistics.incrementReadOps(1);
            }
            if (keysToDelete.size() > 0) {
                DeleteObjectsRequest deleteRequest = new DeleteObjectsRequest(this.bucket).withKeys(keysToDelete);
                this.s3.deleteObjects(deleteRequest);
                this.statistics.incrementWriteOps(1);
            }
        }
        if (src.getParent() != dst.getParent()) {
            this.deleteUnnecessaryFakeDirectories(dst.getParent());
            this.createFakeDirectoryIfNecessary(src.getParent());
        }
        return true;
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        S3AFileStatus status;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Delete path " + f + " - recursive " + recursive);
        }
        try {
            status = this.getFileStatus(f);
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Couldn't delete " + f + " - does not exist");
            }
            return false;
        }
        String key = this.pathToKey(f);
        if (status.isDirectory()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("delete: Path is a directory");
            }
            if (!recursive && !status.isEmptyDirectory()) {
                throw new IOException("Path is a folder: " + f + " and it is not an empty directory");
            }
            if (!key.endsWith("/")) {
                key = key + "/";
            }
            if (key.equals("/")) {
                LOG.info("s3a cannot delete the root directory");
                return false;
            }
            if (status.isEmptyDirectory()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Deleting fake empty directory");
                }
                this.s3.deleteObject(this.bucket, key);
                this.statistics.incrementWriteOps(1);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Getting objects for directory prefix " + key + " to delete");
                }
                ListObjectsRequest request = new ListObjectsRequest();
                request.setBucketName(this.bucket);
                request.setPrefix(key);
                request.setMaxKeys(this.maxKeys);
                ArrayList<DeleteObjectsRequest.KeyVersion> keys = new ArrayList<DeleteObjectsRequest.KeyVersion>();
                ObjectListing objects = this.s3.listObjects(request);
                this.statistics.incrementReadOps(1);
                while (true) {
                    for (S3ObjectSummary summary : objects.getObjectSummaries()) {
                        keys.add(new DeleteObjectsRequest.KeyVersion(summary.getKey()));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Got object to delete " + summary.getKey());
                        }
                        if (keys.size() != 1000) continue;
                        DeleteObjectsRequest deleteRequest = new DeleteObjectsRequest(this.bucket).withKeys(keys);
                        this.s3.deleteObjects(deleteRequest);
                        this.statistics.incrementWriteOps(1);
                        keys.clear();
                    }
                    if (!objects.isTruncated()) break;
                    objects = this.s3.listNextBatchOfObjects(objects);
                    this.statistics.incrementReadOps(1);
                }
                if (!keys.isEmpty()) {
                    DeleteObjectsRequest deleteRequest = new DeleteObjectsRequest(this.bucket).withKeys(keys);
                    this.s3.deleteObjects(deleteRequest);
                    this.statistics.incrementWriteOps(1);
                }
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("delete: Path is a file");
            }
            this.s3.deleteObject(this.bucket, key);
            this.statistics.incrementWriteOps(1);
        }
        this.createFakeDirectoryIfNecessary(f.getParent());
        return true;
    }

    private void createFakeDirectoryIfNecessary(Path f) throws IOException {
        String key = this.pathToKey(f);
        if (!key.isEmpty() && !this.exists(f)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating new fake directory at " + f);
            }
            this.createFakeDirectory(this.bucket, key);
        }
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        String key = this.pathToKey(f);
        if (LOG.isDebugEnabled()) {
            LOG.debug("List status for path: " + f);
        }
        ArrayList<S3AFileStatus> result = new ArrayList<S3AFileStatus>();
        S3AFileStatus fileStatus = this.getFileStatus(f);
        if (fileStatus.isDirectory()) {
            if (!key.isEmpty()) {
                key = key + "/";
            }
            ListObjectsRequest request = new ListObjectsRequest();
            request.setBucketName(this.bucket);
            request.setPrefix(key);
            request.setDelimiter("/");
            request.setMaxKeys(this.maxKeys);
            if (LOG.isDebugEnabled()) {
                LOG.debug("listStatus: doing listObjects for directory " + key);
            }
            ObjectListing objects = this.s3.listObjects(request);
            this.statistics.incrementReadOps(1);
            while (true) {
                Path keyPath;
                for (S3ObjectSummary summary : objects.getObjectSummaries()) {
                    keyPath = this.keyToPath(summary.getKey()).makeQualified(this.uri, this.workingDir);
                    if (keyPath.equals((Object)f) || summary.getKey().endsWith("_$folder$")) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Ignoring: " + keyPath);
                        continue;
                    }
                    if (this.objectRepresentsDirectory(summary.getKey(), summary.getSize())) {
                        result.add(new S3AFileStatus(true, true, keyPath));
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Adding: fd: " + keyPath);
                        continue;
                    }
                    result.add(new S3AFileStatus(summary.getSize(), S3AFileSystem.dateToLong(summary.getLastModified()), keyPath, this.getDefaultBlockSize(f.makeQualified(this.uri, this.workingDir))));
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Adding: fi: " + keyPath);
                }
                for (String prefix : objects.getCommonPrefixes()) {
                    keyPath = this.keyToPath(prefix).makeQualified(this.uri, this.workingDir);
                    if (keyPath.equals((Object)f)) continue;
                    result.add(new S3AFileStatus(true, false, keyPath));
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Adding: rd: " + keyPath);
                }
                if (objects.isTruncated()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("listStatus: list truncated - getting next batch");
                    }
                    objects = this.s3.listNextBatchOfObjects(objects);
                    this.statistics.incrementReadOps(1);
                    continue;
                }
                break;
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding: rd (not a dir): " + f);
            }
            result.add(fileStatus);
        }
        return result.toArray(new FileStatus[result.size()]);
    }

    public void setWorkingDirectory(Path new_dir) {
        this.workingDir = new_dir;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Making directory: " + f);
        }
        try {
            S3AFileStatus fileStatus = this.getFileStatus(f);
            if (fileStatus.isDirectory()) {
                return true;
            }
            throw new FileAlreadyExistsException("Path is a file: " + f);
        }
        catch (FileNotFoundException e) {
            Path fPart = f;
            do {
                try {
                    S3AFileStatus fileStatus = this.getFileStatus(fPart);
                    if (fileStatus.isFile()) {
                        throw new FileAlreadyExistsException(String.format("Can't make directory for path '%s' since it is a file.", fPart));
                    }
                }
                catch (FileNotFoundException fnfe) {
                    // empty catch block
                }
            } while ((fPart = fPart.getParent()) != null);
            String key = this.pathToKey(f);
            this.createFakeDirectory(this.bucket, key);
            return true;
        }
    }

    public S3AFileStatus getFileStatus(Path f) throws IOException {
        String key = this.pathToKey(f);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting path status for " + f + " (" + key + ")");
        }
        if (!key.isEmpty()) {
            try {
                ObjectMetadata meta = this.s3.getObjectMetadata(this.bucket, key);
                this.statistics.incrementReadOps(1);
                if (this.objectRepresentsDirectory(key, meta.getContentLength())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found exact file: fake directory");
                    }
                    return new S3AFileStatus(true, true, f.makeQualified(this.uri, this.workingDir));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found exact file: normal file");
                }
                return new S3AFileStatus(meta.getContentLength(), S3AFileSystem.dateToLong(meta.getLastModified()), f.makeQualified(this.uri, this.workingDir), this.getDefaultBlockSize(f.makeQualified(this.uri, this.workingDir)));
            }
            catch (AmazonServiceException e) {
                if (e.getStatusCode() != 404) {
                    this.printAmazonServiceException(e);
                    throw e;
                }
            }
            catch (AmazonClientException e) {
                this.printAmazonClientException(e);
                throw e;
            }
            if (!key.endsWith("/")) {
                try {
                    String newKey = key + "/";
                    ObjectMetadata meta = this.s3.getObjectMetadata(this.bucket, newKey);
                    this.statistics.incrementReadOps(1);
                    if (this.objectRepresentsDirectory(newKey, meta.getContentLength())) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Found file (with /): fake directory");
                        }
                        return new S3AFileStatus(true, true, f.makeQualified(this.uri, this.workingDir));
                    }
                    LOG.warn("Found file (with /): real file? should not happen: {}", (Object)key);
                    return new S3AFileStatus(meta.getContentLength(), S3AFileSystem.dateToLong(meta.getLastModified()), f.makeQualified(this.uri, this.workingDir), this.getDefaultBlockSize(f.makeQualified(this.uri, this.workingDir)));
                }
                catch (AmazonServiceException e) {
                    if (e.getStatusCode() != 404) {
                        this.printAmazonServiceException(e);
                        throw e;
                    }
                }
                catch (AmazonClientException e) {
                    this.printAmazonClientException(e);
                    throw e;
                }
            }
        }
        try {
            if (!key.isEmpty() && !key.endsWith("/")) {
                key = key + "/";
            }
            ListObjectsRequest request = new ListObjectsRequest();
            request.setBucketName(this.bucket);
            request.setPrefix(key);
            request.setDelimiter("/");
            request.setMaxKeys(1);
            ObjectListing objects = this.s3.listObjects(request);
            this.statistics.incrementReadOps(1);
            if (!objects.getCommonPrefixes().isEmpty() || objects.getObjectSummaries().size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found path as directory (with /): " + objects.getCommonPrefixes().size() + "/" + objects.getObjectSummaries().size());
                    for (S3ObjectSummary summary : objects.getObjectSummaries()) {
                        LOG.debug("Summary: " + summary.getKey() + " " + summary.getSize());
                    }
                    for (String prefix : objects.getCommonPrefixes()) {
                        LOG.debug("Prefix: " + prefix);
                    }
                }
                return new S3AFileStatus(true, false, f.makeQualified(this.uri, this.workingDir));
            }
            if (key.isEmpty()) {
                LOG.debug("Found root directory");
                return new S3AFileStatus(true, true, f.makeQualified(this.uri, this.workingDir));
            }
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() != 404) {
                this.printAmazonServiceException(e);
                throw e;
            }
        }
        catch (AmazonClientException e) {
            this.printAmazonClientException(e);
            throw e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Not Found: " + f);
        }
        throw new FileNotFoundException("No such file or directory: " + f);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        String key = this.pathToKey(dst);
        if (!overwrite && this.exists(dst)) {
            throw new IOException(dst + " already exists");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Copying local file from " + src + " to " + dst);
        }
        LocalFileSystem local = S3AFileSystem.getLocal((Configuration)this.getConf());
        File srcfile = local.pathToFile(src);
        ObjectMetadata om = new ObjectMetadata();
        if (StringUtils.isNotBlank((String)this.serverSideEncryptionAlgorithm)) {
            om.setSSEAlgorithm(this.serverSideEncryptionAlgorithm);
        }
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, key, srcfile);
        putObjectRequest.setCannedAcl(this.cannedACL);
        putObjectRequest.setMetadata(om);
        ProgressListener progressListener = new ProgressListener(){

            @Override
            public void progressChanged(ProgressEvent progressEvent) {
                switch (progressEvent.getEventType()) {
                    case TRANSFER_PART_COMPLETED_EVENT: {
                        S3AFileSystem.this.statistics.incrementWriteOps(1);
                    }
                }
            }
        };
        Upload up = this.transfers.upload(putObjectRequest);
        up.addProgressListener(progressListener);
        try {
            up.waitForUploadResult();
            this.statistics.incrementWriteOps(1);
        }
        catch (InterruptedException e) {
            throw new IOException("Got interrupted, cancelling");
        }
        this.finishedWrite(key);
        if (delSrc) {
            local.delete(src, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.transfers != null) {
                this.transfers.shutdownNow(true);
                this.transfers = null;
            }
        }
    }

    public String getCanonicalServiceName() {
        return null;
    }

    private void copyFile(String srcKey, String dstKey) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("copyFile " + srcKey + " -> " + dstKey);
        }
        ObjectMetadata srcom = this.s3.getObjectMetadata(this.bucket, srcKey);
        ObjectMetadata dstom = srcom.clone();
        if (StringUtils.isNotBlank((String)this.serverSideEncryptionAlgorithm)) {
            dstom.setSSEAlgorithm(this.serverSideEncryptionAlgorithm);
        }
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(this.bucket, srcKey, this.bucket, dstKey);
        copyObjectRequest.setCannedAccessControlList(this.cannedACL);
        copyObjectRequest.setNewObjectMetadata(dstom);
        ProgressListener progressListener = new ProgressListener(){

            @Override
            public void progressChanged(ProgressEvent progressEvent) {
                switch (progressEvent.getEventType()) {
                    case TRANSFER_PART_COMPLETED_EVENT: {
                        S3AFileSystem.this.statistics.incrementWriteOps(1);
                    }
                }
            }
        };
        Copy copy = this.transfers.copy(copyObjectRequest);
        copy.addProgressListener(progressListener);
        try {
            copy.waitForCopyResult();
            this.statistics.incrementWriteOps(1);
        }
        catch (InterruptedException e) {
            throw new IOException("Got interrupted, cancelling");
        }
    }

    private boolean objectRepresentsDirectory(String name, long size) {
        return !name.isEmpty() && name.charAt(name.length() - 1) == '/' && size == 0L;
    }

    private static long dateToLong(Date date) {
        if (date == null) {
            return 0L;
        }
        return date.getTime();
    }

    public void finishedWrite(String key) throws IOException {
        this.deleteUnnecessaryFakeDirectories(this.keyToPath(key).getParent());
    }

    private void deleteUnnecessaryFakeDirectories(Path f) throws IOException {
        while (true) {
            try {
                String key = this.pathToKey(f);
                if (key.isEmpty()) break;
                S3AFileStatus status = this.getFileStatus(f);
                if (status.isDirectory() && status.isEmptyDirectory()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Deleting fake directory " + key + "/");
                    }
                    this.s3.deleteObject(this.bucket, key + "/");
                    this.statistics.incrementWriteOps(1);
                }
            }
            catch (AmazonServiceException | FileNotFoundException exception) {
                // empty catch block
            }
            if (f.isRoot()) break;
            f = f.getParent();
        }
    }

    private void createFakeDirectory(String bucketName, String objectName) throws AmazonClientException, AmazonServiceException {
        if (!objectName.endsWith("/")) {
            this.createEmptyObject(bucketName, objectName + "/");
        } else {
            this.createEmptyObject(bucketName, objectName);
        }
    }

    private void createEmptyObject(String bucketName, String objectName) throws AmazonClientException, AmazonServiceException {
        InputStream im = new InputStream(){

            @Override
            public int read() throws IOException {
                return -1;
            }
        };
        ObjectMetadata om = new ObjectMetadata();
        om.setContentLength(0L);
        if (StringUtils.isNotBlank((String)this.serverSideEncryptionAlgorithm)) {
            om.setSSEAlgorithm(this.serverSideEncryptionAlgorithm);
        }
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, objectName, im, om);
        putObjectRequest.setCannedAcl(this.cannedACL);
        this.s3.putObject(putObjectRequest);
        this.statistics.incrementWriteOps(1);
    }

    @Deprecated
    public long getDefaultBlockSize() {
        return this.getConf().getLong("fs.s3a.block.size", 0x2000000L);
    }

    private void printAmazonServiceException(AmazonServiceException ase) {
        LOG.info("Caught an AmazonServiceException, which means your request made it to Amazon S3, but was rejected with an error response for some reason.");
        LOG.info("Error Message: " + ase.getMessage());
        LOG.info("HTTP Status Code: " + ase.getStatusCode());
        LOG.info("AWS Error Code: " + ase.getErrorCode());
        LOG.info("Error Type: " + (Object)((Object)ase.getErrorType()));
        LOG.info("Request ID: " + ase.getRequestId());
        LOG.info("Class Name: " + ase.getClass().getName());
    }

    private void printAmazonClientException(AmazonClientException ace) {
        LOG.info("Caught an AmazonClientException, which means the client encountered a serious internal problem while trying to communicate with S3, such as not being able to access the network.");
        LOG.info("Error Message: {}" + ace, (Throwable)ace);
    }

    static /* synthetic */ AtomicInteger access$000() {
        return poolNumber;
    }

    static {
        Configuration.addDeprecation((String)DEPRECATED_ACCESS_KEY, (String)"fs.s3a.access.key", (String)String.format("%s is deprecated, use %s instead.", DEPRECATED_ACCESS_KEY, "fs.s3a.access.key"));
        Configuration.addDeprecation((String)DEPRECATED_SECRET_KEY, (String)"fs.s3a.secret.key", (String)String.format("%s is deprecated, use %s instead.", DEPRECATED_SECRET_KEY, "fs.s3a.secret.key"));
    }
}

