/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public class DelegationTokenRenewer<T extends FileSystem>
extends Thread {
    private static final int RENEW_CYCLE = 82080000;
    private DelayQueue<RenewAction<T>> queue = new DelayQueue();

    public DelegationTokenRenewer(Class<T> clazz) {
        super(clazz.getSimpleName() + "-" + DelegationTokenRenewer.class.getSimpleName());
        this.setDaemon(true);
    }

    public void addRenewAction(T fs) {
        this.queue.add(new RenewAction((FileSystem)fs, null));
    }

    @Override
    public void run() {
        while (true) {
            RenewAction action = null;
            try {
                action = (RenewAction)this.queue.take();
                if (!action.renew()) continue;
                action.updateRenewalTime();
                this.queue.add(action);
                continue;
            }
            catch (InterruptedException ie) {
                return;
            }
            catch (Exception ie) {
                FileSystem.LOG.warn((Object)("Failed to renew token, action=" + action), (Throwable)ie);
                continue;
            }
            break;
        }
    }

    static class 1 {
    }

    private static class RenewAction<T extends FileSystem>
    implements Delayed {
        private long renewalTime;
        private final WeakReference<T> weakFs;

        private RenewAction(T fs) {
            this.weakFs = new WeakReference<T>(fs);
            this.updateRenewalTime();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long millisLeft = this.renewalTime - Time.now();
            return unit.convert(millisLeft, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed delayed) {
            RenewAction that = (RenewAction)delayed;
            return this.renewalTime < that.renewalTime ? -1 : (this.renewalTime == that.renewalTime ? 0 : 1);
        }

        public int hashCode() {
            return (int)this.renewalTime ^ (int)(this.renewalTime >>> 32);
        }

        public boolean equals(Object that) {
            if (that == null || !(that instanceof RenewAction)) {
                return false;
            }
            return this.compareTo((Delayed)that) == 0;
        }

        private void updateRenewalTime() {
            this.renewalTime = 82080000L + Time.now();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean renew() throws IOException, InterruptedException {
            boolean b;
            FileSystem fs = (FileSystem)this.weakFs.get();
            boolean bl = b = fs != null;
            if (b) {
                FileSystem fileSystem = fs;
                synchronized (fileSystem) {
                    try {
                        ((Renewable)((Object)fs)).getRenewToken().renew(fs.getConf());
                    }
                    catch (IOException ie) {
                        try {
                            Token<?>[] tokens = fs.addDelegationTokens(null, null);
                            if (tokens.length == 0) {
                                throw new IOException("addDelegationTokens returned no tokens");
                            }
                            ((Renewable)((Object)fs)).setDelegationToken(tokens[0]);
                        }
                        catch (IOException ie2) {
                            throw new IOException("Can't renew or get new delegation token ", ie);
                        }
                    }
                }
            }
            return b;
        }

        public String toString() {
            Renewable fs = (Renewable)this.weakFs.get();
            return fs == null ? "evaporated token renew" : "The token will be renewed in " + this.getDelay(TimeUnit.SECONDS) + " secs, renewToken=" + fs.getRenewToken();
        }

        /* synthetic */ RenewAction(FileSystem x0, 1 x1) {
            this(x0);
        }
    }

    public static interface Renewable {
        public Token<?> getRenewToken();

        public <T extends TokenIdentifier> void setDelegationToken(Token<T> var1);
    }
}

