/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.kfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.kfs.IFSImpl;
import org.apache.hadoop.fs.kfs.KFSImpl;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class KosmosFileSystem
extends FileSystem {
    private FileSystem localFs;
    private IFSImpl kfsImpl = null;
    private URI uri;
    private Path workingDir = new Path("/");

    public KosmosFileSystem() {
    }

    KosmosFileSystem(IFSImpl fsimpl) {
        this.kfsImpl = fsimpl;
    }

    @Override
    public String getScheme() {
        return "kfs";
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        try {
            if (this.kfsImpl == null) {
                this.kfsImpl = uri.getHost() == null ? new KFSImpl(conf.get("fs.kfs.metaServerHost", ""), conf.getInt("fs.kfs.metaServerPort", -1), this.statistics) : new KFSImpl(uri.getHost(), uri.getPort(), this.statistics);
            }
            this.localFs = FileSystem.getLocal(conf);
            this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
            this.workingDir = new Path("/user", System.getProperty("user.name")).makeQualified(this);
            this.setConf(conf);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Unable to initialize KFS");
            System.exit(-1);
        }
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    public void setWorkingDirectory(Path dir) {
        this.workingDir = this.makeAbsolute(dir);
    }

    private Path makeAbsolute(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(this.workingDir, path);
    }

    @Override
    public boolean mkdirs(Path path, FsPermission permission) throws IOException {
        Path absolute = this.makeAbsolute(path);
        String srep = absolute.toUri().getPath();
        int res = this.kfsImpl.mkdirs(srep);
        return res == 0;
    }

    @Override
    public boolean isDirectory(Path path) throws IOException {
        Path absolute = this.makeAbsolute(path);
        String srep = absolute.toUri().getPath();
        return this.kfsImpl.isDirectory(srep);
    }

    @Override
    public boolean isFile(Path path) throws IOException {
        Path absolute = this.makeAbsolute(path);
        String srep = absolute.toUri().getPath();
        return this.kfsImpl.isFile(srep);
    }

    @Override
    public FileStatus[] listStatus(Path path) throws IOException {
        Path absolute = this.makeAbsolute(path);
        String srep = absolute.toUri().getPath();
        if (!this.kfsImpl.exists(srep)) {
            throw new FileNotFoundException("File " + path + " does not exist.");
        }
        if (this.kfsImpl.isFile(srep)) {
            return new FileStatus[]{this.getFileStatus(path)};
        }
        return this.kfsImpl.readdirplus(absolute);
    }

    @Override
    public FileStatus getFileStatus(Path path) throws IOException {
        Path absolute = this.makeAbsolute(path);
        String srep = absolute.toUri().getPath();
        if (!this.kfsImpl.exists(srep)) {
            throw new FileNotFoundException("File " + path + " does not exist.");
        }
        if (this.kfsImpl.isDirectory(srep)) {
            return new FileStatus(0L, true, 1, 0L, this.kfsImpl.getModificationTime(srep), path.makeQualified(this));
        }
        return new FileStatus(this.kfsImpl.filesize(srep), false, this.kfsImpl.getReplication(srep), this.getDefaultBlockSize(), this.kfsImpl.getModificationTime(srep), path.makeQualified(this));
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        Path parent = f.getParent();
        if (parent != null && !this.mkdirs(parent)) {
            throw new IOException("Mkdirs failed to create " + parent);
        }
        Path absolute = this.makeAbsolute(f);
        String srep = absolute.toUri().getPath();
        return this.kfsImpl.append(srep, bufferSize, progress);
    }

    @Override
    public FSDataOutputStream create(Path file, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path parent;
        if (this.exists(file)) {
            if (overwrite) {
                this.delete(file, true);
            } else {
                throw new IOException("File already exists: " + file);
            }
        }
        if ((parent = file.getParent()) != null && !this.mkdirs(parent)) {
            throw new IOException("Mkdirs failed to create " + parent);
        }
        Path absolute = this.makeAbsolute(file);
        String srep = absolute.toUri().getPath();
        return this.kfsImpl.create(srep, replication, bufferSize, progress);
    }

    @Override
    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        if (!this.exists(path)) {
            throw new IOException("File does not exist: " + path);
        }
        Path absolute = this.makeAbsolute(path);
        String srep = absolute.toUri().getPath();
        return this.kfsImpl.open(srep, bufferSize);
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        Path absoluteD;
        String srepD;
        Path absoluteS = this.makeAbsolute(src);
        String srepS = absoluteS.toUri().getPath();
        return this.kfsImpl.rename(srepS, srepD = (absoluteD = this.makeAbsolute(dst)).toUri().getPath()) == 0;
    }

    @Override
    public boolean delete(Path path, boolean recursive) throws IOException {
        Path absolute = this.makeAbsolute(path);
        String srep = absolute.toUri().getPath();
        if (this.kfsImpl.isFile(srep)) {
            return this.kfsImpl.remove(srep) == 0;
        }
        FileStatus[] dirEntries = this.listStatus(absolute);
        if (!recursive && dirEntries.length != 0) {
            throw new IOException("Directory " + path.toString() + " is not empty.");
        }
        for (int i = 0; i < dirEntries.length; ++i) {
            this.delete(new Path(absolute, dirEntries[i].getPath()), recursive);
        }
        return this.kfsImpl.rmdir(srep) == 0;
    }

    @Override
    public short getDefaultReplication() {
        return 3;
    }

    @Override
    public boolean setReplication(Path path, short replication) throws IOException {
        Path absolute = this.makeAbsolute(path);
        String srep = absolute.toUri().getPath();
        short res = this.kfsImpl.setReplication(srep, replication);
        return res >= 0;
    }

    @Override
    public long getDefaultBlockSize() {
        return 0x4000000L;
    }

    @Deprecated
    public void lock(Path path, boolean shared) throws IOException {
    }

    @Deprecated
    public void release(Path path) throws IOException {
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (file == null) {
            return null;
        }
        String srep = this.makeAbsolute(file.getPath()).toUri().getPath();
        String[][] hints = this.kfsImpl.getDataLocation(srep, start, len);
        if (hints == null) {
            return null;
        }
        BlockLocation[] result = new BlockLocation[hints.length];
        long blockSize = this.getDefaultBlockSize();
        long length = len;
        long blockStart = start;
        for (int i = 0; i < result.length; ++i) {
            result[i] = new BlockLocation(null, hints[i], blockStart, length < blockSize ? length : blockSize);
            blockStart += blockSize;
            length -= blockSize;
        }
        return result;
    }

    @Override
    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        FileUtil.copy(this.localFs, src, this, dst, delSrc, this.getConf());
    }

    @Override
    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        FileUtil.copy(this, src, this.localFs, dst, delSrc, this.getConf());
    }

    @Override
    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        return tmpLocalFile;
    }

    @Override
    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        this.moveFromLocalFile(tmpLocalFile, fsOutputFile);
    }
}

