/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.Charsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class HostsFileReader {
    private Set<String> includes = new HashSet<String>();
    private Map<String, Integer> excludes = new HashMap<String, Integer>();
    private String includesFile;
    private String excludesFile;
    private static final Log LOG = LogFactory.getLog(HostsFileReader.class);

    public HostsFileReader(String inFile, String exFile) throws IOException {
        this.includesFile = inFile;
        this.excludesFile = exFile;
        this.refresh();
    }

    @InterfaceAudience.Private
    public HostsFileReader(String includesFile, InputStream inFileInputStream, String excludesFile, InputStream exFileInputStream) throws IOException {
        this.includesFile = includesFile;
        this.excludesFile = excludesFile;
        this.refresh(inFileInputStream, exFileInputStream);
    }

    public static void readFileToSet(String type, String filename, Set<String> set) throws IOException {
        File file = new File(filename);
        FileInputStream fis = new FileInputStream(file);
        HostsFileReader.readFileToSetWithFileInputStream(type, filename, fis, set);
    }

    @InterfaceAudience.Private
    public static void readFileToSetWithFileInputStream(String type, String filename, InputStream fileInputStream, Set<String> set) throws IOException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        HostsFileReader.readFileToMapWithFileInputStream(type, filename, fileInputStream, map);
        set.addAll(map.keySet());
    }

    public static void readFileToMap(String type, String filename, Map<String, Integer> map) throws IOException {
        File file = new File(filename);
        FileInputStream fis = new FileInputStream(file);
        HostsFileReader.readFileToMapWithFileInputStream(type, filename, fis, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readFileToMapWithFileInputStream(String type, String filename, InputStream fileInputStream, Map<String, Integer> map) throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(fileInputStream, Charsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                String[] nodes = line.split("[ \t\n\f\r]+");
                if (nodes == null) continue;
                for (int i = 0; i < nodes.length && !nodes[i].trim().startsWith("#"); ++i) {
                    if (nodes[i].isEmpty()) continue;
                    Integer timeout = null;
                    if (i < nodes.length - 1) {
                        timeout = HostsFileReader.tryParseInteger(nodes[i + 1]);
                    }
                    map.put(nodes[i], timeout);
                    if (timeout == null) continue;
                    ++i;
                }
            }
            HostsFileReader.showMap(type, map, filename);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            fileInputStream.close();
        }
    }

    public synchronized void refresh() throws IOException {
        LOG.info((Object)"Refreshing hosts (include/exclude) list");
        HashSet<String> newIncludes = new HashSet<String>();
        HashMap<String, Integer> newExcludes = new HashMap<String, Integer>();
        boolean switchIncludes = false;
        boolean switchExcludes = false;
        if (!this.includesFile.isEmpty()) {
            HostsFileReader.readFileToSet("included", this.includesFile, newIncludes);
            switchIncludes = true;
        }
        if (!this.excludesFile.isEmpty()) {
            HostsFileReader.readFileToMap("excluded", this.excludesFile, newExcludes);
            switchExcludes = true;
        }
        if (switchIncludes) {
            this.includes = newIncludes;
        }
        if (switchExcludes) {
            this.excludes = newExcludes;
        }
    }

    @InterfaceAudience.Private
    public synchronized void refresh(InputStream inFileInputStream, InputStream exFileInputStream) throws IOException {
        LOG.info((Object)"Refreshing hosts (include/exclude) list");
        HashSet<String> newIncludes = new HashSet<String>();
        HashMap<String, Integer> newExcludes = new HashMap<String, Integer>();
        boolean switchIncludes = false;
        boolean switchExcludes = false;
        if (inFileInputStream != null) {
            HostsFileReader.readFileToSetWithFileInputStream("included", this.includesFile, inFileInputStream, newIncludes);
            switchIncludes = true;
        }
        if (exFileInputStream != null) {
            HostsFileReader.readFileToMapWithFileInputStream("excluded", this.excludesFile, exFileInputStream, newExcludes);
            switchExcludes = true;
        }
        if (switchIncludes) {
            this.includes = newIncludes;
        }
        if (switchExcludes) {
            this.excludes = newExcludes;
        }
    }

    public synchronized Set<String> getHosts() {
        return this.includes;
    }

    public synchronized Set<String> getExcludedHosts() {
        return this.excludes.keySet();
    }

    public synchronized Map<String, Integer> getExcludedHostsWithTimeout() {
        return this.excludes;
    }

    public synchronized void setIncludesFile(String includesFile) {
        LOG.info((Object)("Setting the includes file to " + includesFile));
        this.includesFile = includesFile;
    }

    public synchronized void setExcludesFile(String excludesFile) {
        LOG.info((Object)("Setting the excludes file to " + excludesFile));
        this.excludesFile = excludesFile;
    }

    public synchronized void updateFileNames(String includesFile, String excludesFile) {
        this.setIncludesFile(includesFile);
        this.setExcludesFile(excludesFile);
    }

    private static Integer tryParseInteger(String str) {
        try {
            int num = Integer.parseInt(str);
            return num;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void showMap(String type, Map<String, Integer> excludes, String filename) {
        if (excludes.size() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> n : excludes.entrySet()) {
            if (n.getValue() != null) {
                sb.append(String.format("\n  %s : %d", n.getKey(), n.getValue()));
                continue;
            }
            sb.append(String.format("\n  %s", n.getKey()));
        }
        LOG.info((Object)("List of " + type + " hosts from " + filename + sb.toString()));
    }
}

