/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RetriableException;

public class RetryUtils {
    public static final Log LOG = LogFactory.getLog(RetryUtils.class);

    public static RetryPolicy getDefaultRetryPolicy(Configuration conf, String retryPolicyEnabledKey, boolean defaultRetryPolicyEnabled, String retryPolicySpecKey, String defaultRetryPolicySpec, Class<? extends Exception> remoteExceptionToRetry) {
        RetryPolicy multipleLinearRandomRetry = RetryUtils.getMultipleLinearRandomRetry(conf, retryPolicyEnabledKey, defaultRetryPolicyEnabled, retryPolicySpecKey, defaultRetryPolicySpec);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("multipleLinearRandomRetry = " + multipleLinearRandomRetry));
        }
        if (multipleLinearRandomRetry == null) {
            return RetryPolicies.TRY_ONCE_THEN_FAIL;
        }
        return new WrapperRetryPolicy((RetryPolicies.MultipleLinearRandomRetry)multipleLinearRandomRetry, remoteExceptionToRetry);
    }

    public static RetryPolicy getMultipleLinearRandomRetry(Configuration conf, String retryPolicyEnabledKey, boolean defaultRetryPolicyEnabled, String retryPolicySpecKey, String defaultRetryPolicySpec) {
        boolean enabled = conf.getBoolean(retryPolicyEnabledKey, defaultRetryPolicyEnabled);
        if (!enabled) {
            return null;
        }
        String policy = conf.get(retryPolicySpecKey, defaultRetryPolicySpec);
        RetryPolicies.MultipleLinearRandomRetry r = RetryPolicies.MultipleLinearRandomRetry.parseCommaSeparatedString(policy);
        return r != null ? r : RetryPolicies.MultipleLinearRandomRetry.parseCommaSeparatedString(defaultRetryPolicySpec);
    }

    private static final class WrapperRetryPolicy
    implements RetryPolicy {
        private RetryPolicies.MultipleLinearRandomRetry multipleLinearRandomRetry;
        private final Class<? extends Exception> remoteExceptionToRetry;

        private WrapperRetryPolicy(RetryPolicies.MultipleLinearRandomRetry multipleLinearRandomRetry, Class<? extends Exception> remoteExceptionToRetry) {
            this.multipleLinearRandomRetry = multipleLinearRandomRetry;
            this.remoteExceptionToRetry = remoteExceptionToRetry;
        }

        @Override
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean isMethodIdempotent) throws Exception {
            RetryPolicy p;
            Throwable cause;
            if (e instanceof ServiceException && (cause = e.getCause()) != null && cause instanceof Exception) {
                e = (Exception)cause;
            }
            if (e instanceof RetriableException || RetryPolicies.getWrappedRetriableException(e) != null) {
                p = this.multipleLinearRandomRetry;
            } else if (e instanceof RemoteException) {
                RemoteException re = (RemoteException)e;
                p = this.remoteExceptionToRetry != null && re.getClassName().equals(this.remoteExceptionToRetry.getName()) ? this.multipleLinearRandomRetry : RetryPolicies.TRY_ONCE_THEN_FAIL;
            } else {
                p = e instanceof IOException || e instanceof ServiceException ? this.multipleLinearRandomRetry : RetryPolicies.TRY_ONCE_THEN_FAIL;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RETRY " + retries + ") policy=" + p.getClass().getSimpleName() + ", exception=" + e));
            }
            return p.shouldRetry(e, retries, failovers, isMethodIdempotent);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof WrapperRetryPolicy && this.multipleLinearRandomRetry.equals(((WrapperRetryPolicy)obj).multipleLinearRandomRetry);
        }

        public int hashCode() {
            return this.multipleLinearRandomRetry.hashCode();
        }

        public String toString() {
            return "RetryPolicy[" + this.multipleLinearRandomRetry + ", " + RetryPolicies.TRY_ONCE_THEN_FAIL.getClass().getSimpleName() + "]";
        }
    }
}

