/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.ZKFailoverController;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.proto.HAZKInfoProtos;
import org.apache.hadoop.hdfs.tools.DFSHAAdmin;
import org.apache.hadoop.hdfs.tools.NNHAServiceTarget;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class DFSZKFailoverController
extends ZKFailoverController {
    private static final Log LOG = LogFactory.getLog(DFSZKFailoverController.class);
    private NNHAServiceTarget localTarget;
    private Configuration localNNConf;
    private AccessControlList adminAcl;

    protected HAServiceTarget dataToTarget(byte[] data) {
        HAZKInfoProtos.ActiveNodeInfo proto;
        try {
            proto = HAZKInfoProtos.ActiveNodeInfo.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Invalid data in ZK: " + StringUtils.byteToHexString((byte[])data));
        }
        NNHAServiceTarget ret = new NNHAServiceTarget(this.getConf(), proto.getNameserviceId(), proto.getNamenodeId());
        InetSocketAddress addressFromProtobuf = new InetSocketAddress(proto.getHostname(), proto.getPort());
        if (!addressFromProtobuf.equals(ret.getAddress())) {
            throw new RuntimeException("Mismatched address stored in ZK for " + (Object)((Object)ret) + ": Stored protobuf was " + proto + ", address from our own " + "configuration for this NameNode was " + ret.getAddress());
        }
        ret.setZkfcPort(proto.getZkfcPort());
        return ret;
    }

    protected byte[] targetToData(HAServiceTarget target) {
        InetSocketAddress addr = target.getAddress();
        return HAZKInfoProtos.ActiveNodeInfo.newBuilder().setHostname(addr.getHostName()).setPort(addr.getPort()).setZkfcPort(target.getZKFCAddress().getPort()).setNameserviceId(this.localTarget.getNameServiceId()).setNamenodeId(this.localTarget.getNameNodeId()).build().toByteArray();
    }

    protected InetSocketAddress getRpcAddressToBindTo() {
        int zkfcPort = DFSZKFailoverController.getZkfcPort(this.localNNConf);
        return new InetSocketAddress(this.localTarget.getAddress().getAddress(), zkfcPort);
    }

    protected PolicyProvider getPolicyProvider() {
        return new HDFSPolicyProvider();
    }

    static int getZkfcPort(Configuration conf) {
        return conf.getInt("dfs.ha.zkfc.port", 8019);
    }

    public void setConf(Configuration conf) {
        this.localNNConf = DFSHAAdmin.addSecurityConfiguration(conf);
        String nsId = DFSUtil.getNamenodeNameServiceId(conf);
        if (!HAUtil.isHAEnabled(this.localNNConf, nsId)) {
            throw new HadoopIllegalArgumentException("HA is not enabled for this namenode.");
        }
        String nnId = HAUtil.getNameNodeId(this.localNNConf, nsId);
        NameNode.initializeGenericKeys(this.localNNConf, nsId, nnId);
        DFSUtil.setGenericConf(this.localNNConf, nsId, nnId, ZKFC_CONF_KEYS);
        this.localTarget = new NNHAServiceTarget(this.localNNConf, nsId, nnId);
        this.adminAcl = new AccessControlList(conf.get("dfs.cluster.administrators", " "));
        super.setConf(this.localNNConf);
        LOG.info((Object)("Failover controller configured for NameNode " + nsId + "." + nnId));
    }

    protected void initRPC() throws IOException {
        super.initRPC();
        this.localTarget.setZkfcPort(this.rpcServer.getAddress().getPort());
    }

    public HAServiceTarget getLocalTarget() {
        Preconditions.checkState((this.localTarget != null ? 1 : 0) != 0, (Object)"setConf() should have already been called");
        return this.localTarget;
    }

    public void loginAsFCUser() throws IOException {
        InetSocketAddress socAddr = NameNode.getAddress(this.localNNConf);
        SecurityUtil.login((Configuration)this.getConf(), (String)"dfs.namenode.keytab.file", (String)"dfs.namenode.kerberos.principal", (String)socAddr.getHostName());
    }

    protected String getScopeInsideParentNode() {
        return this.localTarget.getNameServiceId();
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Tool)new DFSZKFailoverController(), (String[])args));
    }

    protected void checkRpcAdminAccess() throws IOException, AccessControlException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        UserGroupInformation zkfcUgi = UserGroupInformation.getLoginUser();
        if (this.adminAcl.isUserAllowed(ugi) || ugi.getShortUserName().equals(zkfcUgi.getShortUserName())) {
            LOG.info((Object)("Allowed RPC access from " + ugi + " at " + Server.getRemoteAddress()));
            return;
        }
        String msg = "Disallowed RPC access from " + ugi + " at " + Server.getRemoteAddress() + ". Not listed in " + "dfs.cluster.administrators";
        LOG.warn((Object)msg);
        throw new AccessControlException(msg);
    }
}

