/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsLoader;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsVisitor;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class OfflineEditsBinaryLoader
implements OfflineEditsLoader {
    private OfflineEditsVisitor visitor;
    private EditLogInputStream inputStream;
    private boolean fixTxIds;
    private long nextTxId;

    public OfflineEditsBinaryLoader(OfflineEditsVisitor visitor, EditLogInputStream inputStream) {
        this.visitor = visitor;
        this.inputStream = inputStream;
        this.fixTxIds = false;
        this.nextTxId = -1L;
    }

    @Override
    public void loadEdits() throws IOException {
        try {
            FSEditLogOp op;
            this.visitor.start(this.inputStream.getVersion());
            while ((op = this.inputStream.readOp()) != null) {
                if (this.fixTxIds) {
                    if (this.nextTxId <= 0L) {
                        this.nextTxId = op.getTransactionId();
                        if (this.nextTxId <= 0L) {
                            this.nextTxId = 1L;
                        }
                    }
                    op.setTransactionId(this.nextTxId);
                    ++this.nextTxId;
                }
                this.visitor.visitOp(op);
            }
            this.visitor.close(null);
        }
        catch (IOException e) {
            this.visitor.close(e);
            throw e;
        }
    }

    @Override
    public void setFixTxIds() {
        this.fixTxIds = true;
    }
}

