/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.util.GSet;
import org.apache.hadoop.util.LightWeightGSet;

class BlocksMap {
    private final int capacity;
    private GSet<Block, BlockInfo> blocks;

    BlocksMap(int capacity) {
        this.capacity = capacity;
        this.blocks = new LightWeightGSet<Block, BlockInfo>(capacity){

            public Iterator<BlockInfo> iterator() {
                LightWeightGSet.SetIterator iterator = new LightWeightGSet.SetIterator((LightWeightGSet)this);
                iterator.setTrackModification(false);
                return iterator;
            }
        };
    }

    void close() {
        this.clear();
        this.blocks = null;
    }

    void clear() {
        if (this.blocks != null) {
            this.blocks.clear();
        }
    }

    BlockCollection getBlockCollection(Block b) {
        BlockInfo info = (BlockInfo)this.blocks.get((Object)b);
        return info != null ? info.getBlockCollection() : null;
    }

    BlockInfo addBlockCollection(BlockInfo b, BlockCollection bc) {
        BlockInfo info = (BlockInfo)this.blocks.get((Object)b);
        if (info != b) {
            info = b;
            this.blocks.put((Object)info);
        }
        info.setBlockCollection(bc);
        return info;
    }

    void removeBlock(Block block) {
        BlockInfo blockInfo = (BlockInfo)this.blocks.remove((Object)block);
        if (blockInfo == null) {
            return;
        }
        blockInfo.setBlockCollection(null);
        for (int idx = blockInfo.numNodes() - 1; idx >= 0; --idx) {
            DatanodeDescriptor dn = blockInfo.getDatanode(idx);
            dn.removeBlock(blockInfo);
        }
    }

    BlockInfo getStoredBlock(Block b) {
        return (BlockInfo)this.blocks.get((Object)b);
    }

    Iterable<DatanodeStorageInfo> getStorages(Block b) {
        return this.getStorages((BlockInfo)this.blocks.get((Object)b));
    }

    Iterable<DatanodeStorageInfo> getStorages(Block b, final DatanodeStorage.State state) {
        return Iterables.filter(this.getStorages((BlockInfo)this.blocks.get((Object)b)), (Predicate)new Predicate<DatanodeStorageInfo>(){

            public boolean apply(DatanodeStorageInfo storage) {
                return storage.getState() == state;
            }
        });
    }

    Iterable<DatanodeStorageInfo> getStorages(final BlockInfo storedBlock) {
        return new Iterable<DatanodeStorageInfo>(){

            @Override
            public Iterator<DatanodeStorageInfo> iterator() {
                return new StorageIterator(storedBlock);
            }
        };
    }

    int numNodes(Block b) {
        BlockInfo info = (BlockInfo)this.blocks.get((Object)b);
        return info == null ? 0 : info.numNodes();
    }

    boolean removeNode(Block b, DatanodeDescriptor node) {
        BlockInfo info = (BlockInfo)this.blocks.get((Object)b);
        if (info == null) {
            return false;
        }
        boolean removed = node.removeBlock(info);
        if (info.getDatanode(0) == null && info.getBlockCollection() == null) {
            this.blocks.remove((Object)b);
        }
        return removed;
    }

    int size() {
        return this.blocks.size();
    }

    Iterable<BlockInfo> getBlocks() {
        return this.blocks;
    }

    int getCapacity() {
        return this.capacity;
    }

    BlockInfo replaceBlock(BlockInfo newBlock) {
        BlockInfo currentBlock = (BlockInfo)this.blocks.get((Object)newBlock);
        assert (currentBlock != null) : "the block if not in blocksMap";
        for (int i = currentBlock.numNodes() - 1; i >= 0; --i) {
            DatanodeDescriptor dn = currentBlock.getDatanode(i);
            DatanodeStorageInfo storage = currentBlock.findStorageInfo(dn);
            boolean removed = storage.removeBlock(currentBlock);
            Preconditions.checkState((boolean)removed, (Object)"currentBlock not found.");
            DatanodeStorageInfo.AddBlockResult result = storage.addBlock(newBlock);
            Preconditions.checkState((result == DatanodeStorageInfo.AddBlockResult.ADDED ? 1 : 0) != 0, (Object)"newBlock already exists.");
        }
        this.blocks.put((Object)newBlock);
        return newBlock;
    }

    private static class StorageIterator
    implements Iterator<DatanodeStorageInfo> {
        private final BlockInfo blockInfo;
        private int nextIdx = 0;

        StorageIterator(BlockInfo blkInfo) {
            this.blockInfo = blkInfo;
        }

        @Override
        public boolean hasNext() {
            return this.blockInfo != null && this.nextIdx < this.blockInfo.getCapacity() && this.blockInfo.getDatanode(this.nextIdx) != null;
        }

        @Override
        public DatanodeStorageInfo next() {
            return this.blockInfo.getStorageInfo(this.nextIdx++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Sorry. can't remove.");
        }
    }
}

