/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsBlocksMetadata;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaAlreadyExistsException;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBeingWritten;
import org.apache.hadoop.hdfs.server.datanode.ReplicaHandler;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipeline;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipelineInterface;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.ReplicaNotFoundException;
import org.apache.hadoop.hdfs.server.datanode.ReplicaUnderRecovery;
import org.apache.hadoop.hdfs.server.datanode.ReplicaWaitingToBeRecovered;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.UnexpectedReplicaStateException;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.LengthInputStream;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.ReplicaInputStreams;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.ReplicaOutputStreams;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.RoundRobinVolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.BlockPoolSlice;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetAsyncDiskService;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetCache;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeList;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskAsyncLazyPersistService;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskReplicaTracker;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.VolumeFailureInfo;
import org.apache.hadoop.hdfs.server.datanode.metrics.FSDatasetMBean;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
class FsDatasetImpl
implements FsDatasetSpi<FsVolumeImpl> {
    static final Log LOG = LogFactory.getLog(FsDatasetImpl.class);
    private static final boolean isNativeIOAvailable = NativeIO.isAvailable();
    final DataNode datanode;
    final DataStorage dataStorage;
    final FsVolumeList volumes;
    final Map<String, DatanodeStorage> storageMap;
    final FsDatasetAsyncDiskService asyncDiskService;
    final Daemon lazyWriter;
    final FsDatasetCache cacheManager;
    private final Configuration conf;
    private final int validVolsRequired;
    private volatile boolean fsRunning = true;
    final ReplicaMap volumeMap;
    final Map<String, Set<Long>> deletingBlock;
    final RamDiskReplicaTracker ramDiskReplicaTracker;
    final RamDiskAsyncLazyPersistService asyncLazyPersistService;
    private static final int MAX_BLOCK_EVICTIONS_PER_ITERATION = 3;
    private final Object statsLock = new Object();
    final LocalFileSystem localFS;
    private boolean blockPinningEnabled;
    private ObjectName mbeanName;

    @Override
    public List<FsVolumeImpl> getVolumes() {
        return this.volumes.getVolumes();
    }

    @Override
    public DatanodeStorage getStorage(String storageUuid) {
        return this.storageMap.get(storageUuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageReport[] getStorageReports(String bpid) throws IOException {
        ArrayList<StorageReport> reports;
        Object object = this.statsLock;
        synchronized (object) {
            List<FsVolumeImpl> curVolumes = this.getVolumes();
            reports = new ArrayList<StorageReport>(curVolumes.size());
            for (FsVolumeImpl volume : curVolumes) {
                try {
                    FsVolumeReference ref = volume.obtainReference();
                    Throwable throwable = null;
                    try {
                        StorageReport sr = new StorageReport(volume.toDatanodeStorage(), false, volume.getCapacity(), volume.getDfsUsed(), volume.getAvailable(), volume.getBlockPoolUsed(bpid));
                        reports.add(sr);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ref == null) continue;
                        if (throwable != null) {
                            try {
                                ref.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        ref.close();
                    }
                }
                catch (ClosedChannelException e) {}
            }
        }
        return reports.toArray(new StorageReport[reports.size()]);
    }

    @Override
    public synchronized FsVolumeImpl getVolume(ExtendedBlock b) {
        ReplicaInfo r = this.volumeMap.get(b.getBlockPoolId(), b.getLocalBlock());
        return r != null ? (FsVolumeImpl)r.getVolume() : null;
    }

    @Override
    public synchronized Block getStoredBlock(String bpid, long blkid) throws IOException {
        File blockfile = this.getFile(bpid, blkid, false);
        if (blockfile == null) {
            return null;
        }
        File metafile = FsDatasetUtil.findMetaFile(blockfile);
        long gs = FsDatasetUtil.parseGenerationStamp(blockfile, metafile);
        return new Block(blkid, blockfile.length(), gs);
    }

    ReplicaInfo fetchReplicaInfo(String bpid, long blockId) {
        ReplicaInfo r = this.volumeMap.get(bpid, blockId);
        if (r == null) {
            return null;
        }
        switch (r.getState()) {
            case FINALIZED: {
                return new FinalizedReplica((FinalizedReplica)r);
            }
            case RBW: {
                return new ReplicaBeingWritten((ReplicaBeingWritten)r);
            }
            case RWR: {
                return new ReplicaWaitingToBeRecovered((ReplicaWaitingToBeRecovered)r);
            }
            case RUR: {
                return new ReplicaUnderRecovery((ReplicaUnderRecovery)r);
            }
            case TEMPORARY: {
                return new ReplicaInPipeline((ReplicaInPipeline)r);
            }
        }
        return null;
    }

    @Override
    public LengthInputStream getMetaDataInputStream(ExtendedBlock b) throws IOException {
        File meta = FsDatasetUtil.getMetaFile(this.getBlockFile(b), b.getGenerationStamp());
        if (meta == null || !meta.exists()) {
            return null;
        }
        if (isNativeIOAvailable) {
            return new LengthInputStream(NativeIO.getShareDeleteFileInputStream((File)meta), meta.length());
        }
        return new LengthInputStream(new FileInputStream(meta), meta.length());
    }

    FsDatasetImpl(DataNode datanode, DataStorage storage, Configuration conf) throws IOException {
        this.datanode = datanode;
        this.dataStorage = storage;
        this.conf = conf;
        int volFailuresTolerated = conf.getInt("dfs.datanode.failed.volumes.tolerated", 0);
        String[] dataDirs = conf.getTrimmedStrings("dfs.datanode.data.dir");
        List<StorageLocation> dataLocations = DataNode.getStorageLocations(conf);
        List<VolumeFailureInfo> volumeFailureInfos = FsDatasetImpl.getInitialVolumeFailureInfos(dataLocations, storage);
        int volsConfigured = dataDirs == null ? 0 : dataDirs.length;
        int volsFailed = volumeFailureInfos.size();
        this.validVolsRequired = volsConfigured - volFailuresTolerated;
        if (volFailuresTolerated < 0 || volFailuresTolerated >= volsConfigured) {
            throw new DiskChecker.DiskErrorException("Invalid volume failure  config value: " + volFailuresTolerated);
        }
        if (volsFailed > volFailuresTolerated) {
            throw new DiskChecker.DiskErrorException("Too many failed volumes - current valid volumes: " + storage.getNumStorageDirs() + ", volumes configured: " + volsConfigured + ", volumes failed: " + volsFailed + ", volume failures tolerated: " + volFailuresTolerated);
        }
        this.storageMap = new ConcurrentHashMap<String, DatanodeStorage>();
        this.volumeMap = new ReplicaMap(this);
        this.ramDiskReplicaTracker = RamDiskReplicaTracker.getInstance(conf, this);
        VolumeChoosingPolicy blockChooserImpl = (VolumeChoosingPolicy)ReflectionUtils.newInstance((Class)conf.getClass("dfs.datanode.fsdataset.volume.choosing.policy", RoundRobinVolumeChoosingPolicy.class, VolumeChoosingPolicy.class), (Configuration)conf);
        this.volumes = new FsVolumeList(volumeFailureInfos, datanode.getBlockScanner(), blockChooserImpl);
        this.asyncDiskService = new FsDatasetAsyncDiskService(datanode, this);
        this.asyncLazyPersistService = new RamDiskAsyncLazyPersistService(datanode);
        this.deletingBlock = new HashMap<String, Set<Long>>();
        for (int idx = 0; idx < storage.getNumStorageDirs(); ++idx) {
            this.addVolume(dataLocations, storage.getStorageDir(idx));
        }
        this.setupAsyncLazyPersistThreads();
        this.cacheManager = new FsDatasetCache(this);
        this.lazyWriter = new Daemon((Runnable)new LazyWriter(conf));
        this.lazyWriter.start();
        this.registerMBean(datanode.getDatanodeUuid());
        this.localFS = FileSystem.getLocal((Configuration)conf);
        this.blockPinningEnabled = conf.getBoolean("dfs.datanode.block-pinning.enabled", false);
    }

    private static List<VolumeFailureInfo> getInitialVolumeFailureInfos(Collection<StorageLocation> dataLocations, DataStorage storage) {
        HashSet failedLocationSet = Sets.newHashSetWithExpectedSize((int)dataLocations.size());
        for (StorageLocation sl : dataLocations) {
            failedLocationSet.add(sl.getFile().getAbsolutePath());
        }
        Iterator<Storage.StorageDirectory> it = storage.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            failedLocationSet.remove(sd.getRoot().getAbsolutePath());
        }
        ArrayList volumeFailureInfos = Lists.newArrayListWithCapacity((int)failedLocationSet.size());
        long failureDate = Time.now();
        for (String failedStorageLocation : failedLocationSet) {
            volumeFailureInfos.add(new VolumeFailureInfo(failedStorageLocation, failureDate));
        }
        return volumeFailureInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addVolume(Collection<StorageLocation> dataLocations, Storage.StorageDirectory sd) throws IOException {
        File dir = sd.getCurrentDir();
        StorageType storageType = this.getStorageTypeFromLocations(dataLocations, sd.getRoot());
        FsVolumeImpl fsVolume = new FsVolumeImpl(this, sd.getStorageUuid(), dir, this.conf, storageType);
        FsVolumeReference ref = fsVolume.obtainReference();
        ReplicaMap tempVolumeMap = new ReplicaMap(this);
        fsVolume.getVolumeMap(tempVolumeMap, this.ramDiskReplicaTracker);
        FsDatasetImpl fsDatasetImpl = this;
        synchronized (fsDatasetImpl) {
            this.volumeMap.addAll(tempVolumeMap);
            this.storageMap.put(sd.getStorageUuid(), new DatanodeStorage(sd.getStorageUuid(), DatanodeStorage.State.NORMAL, storageType));
            this.asyncDiskService.addVolume(sd.getCurrentDir());
            this.volumes.addVolume(ref);
        }
        LOG.info((Object)("Added volume - " + dir + ", StorageType: " + storageType));
    }

    @VisibleForTesting
    public FsVolumeImpl createFsVolume(String storageUuid, File currentDir, StorageType storageType) throws IOException {
        return new FsVolumeImpl(this, storageUuid, currentDir, this.conf, storageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVolume(StorageLocation location, List<NamespaceInfo> nsInfos) throws IOException {
        DataStorage.VolumeBuilder builder;
        File dir = location.getFile();
        try {
            builder = this.dataStorage.prepareVolume(this.datanode, location.getFile(), nsInfos);
        }
        catch (IOException e) {
            this.volumes.addVolumeFailureInfo(new VolumeFailureInfo(location.getFile().getAbsolutePath(), Time.now()));
            throw e;
        }
        Storage.StorageDirectory sd = builder.getStorageDirectory();
        StorageType storageType = location.getStorageType();
        FsVolumeImpl fsVolume = this.createFsVolume(sd.getStorageUuid(), sd.getCurrentDir(), storageType);
        ReplicaMap tempVolumeMap = new ReplicaMap(fsVolume);
        ArrayList exceptions = Lists.newArrayList();
        for (NamespaceInfo nsInfo : nsInfos) {
            String bpid = nsInfo.getBlockPoolID();
            try {
                fsVolume.addBlockPool(bpid, this.conf);
                fsVolume.getVolumeMap(bpid, tempVolumeMap, this.ramDiskReplicaTracker);
            }
            catch (IOException e) {
                LOG.warn((Object)("Caught exception when adding " + fsVolume + ". Will throw later."), (Throwable)e);
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            try {
                sd.unlock();
            }
            catch (IOException e) {
                exceptions.add(e);
            }
            throw MultipleIOException.createIOException((List)exceptions);
        }
        FsVolumeReference ref = fsVolume.obtainReference();
        this.setupAsyncLazyPersistThread(fsVolume);
        builder.build();
        FsDatasetImpl fsDatasetImpl = this;
        synchronized (fsDatasetImpl) {
            this.volumeMap.addAll(tempVolumeMap);
            this.storageMap.put(sd.getStorageUuid(), new DatanodeStorage(sd.getStorageUuid(), DatanodeStorage.State.NORMAL, storageType));
            this.asyncDiskService.addVolume(sd.getCurrentDir());
            this.volumes.addVolume(ref);
        }
        LOG.info((Object)("Added volume - " + dir + ", StorageType: " + storageType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVolumes(Set<File> volumesToRemove, boolean clearFailure) {
        for (File vol : volumesToRemove) {
            Preconditions.checkArgument((boolean)vol.isAbsolute(), (Object)String.format("%s is not absolute path.", vol.getPath()));
        }
        HashMap blkToInvalidate = new HashMap();
        ArrayList<String> storageToRemove = new ArrayList<String>();
        FsDatasetImpl fsDatasetImpl = this;
        synchronized (fsDatasetImpl) {
            for (int idx = 0; idx < this.dataStorage.getNumStorageDirs(); ++idx) {
                Storage.StorageDirectory sd = this.dataStorage.getStorageDir(idx);
                File absRoot = sd.getRoot().getAbsoluteFile();
                if (!volumesToRemove.contains(absRoot)) continue;
                LOG.info((Object)("Removing " + absRoot + " from FsDataset."));
                this.asyncDiskService.removeVolume(sd.getCurrentDir());
                this.volumes.removeVolume(absRoot, clearFailure);
                for (String bpid : this.volumeMap.getBlockPoolList()) {
                    ArrayList<ReplicaInfo> blocks = new ArrayList<ReplicaInfo>();
                    Iterator<ReplicaInfo> it = this.volumeMap.replicas(bpid).iterator();
                    while (it.hasNext()) {
                        ReplicaInfo block = it.next();
                        File absBasePath = new File(block.getVolume().getBasePath()).getAbsoluteFile();
                        if (!absBasePath.equals(absRoot)) continue;
                        blocks.add(block);
                        it.remove();
                    }
                    blkToInvalidate.put(bpid, blocks);
                }
                storageToRemove.add(sd.getStorageUuid());
            }
            this.setupAsyncLazyPersistThreads();
        }
        for (Map.Entry entry : blkToInvalidate.entrySet()) {
            String bpid = (String)entry.getKey();
            List blocks = (List)entry.getValue();
            for (ReplicaInfo block : blocks) {
                this.invalidate(bpid, block);
            }
        }
        fsDatasetImpl = this;
        synchronized (fsDatasetImpl) {
            for (String storageUuid : storageToRemove) {
                this.storageMap.remove(storageUuid);
            }
        }
    }

    private StorageType getStorageTypeFromLocations(Collection<StorageLocation> dataLocations, File dir) {
        for (StorageLocation dataLocation : dataLocations) {
            if (!dataLocation.getFile().equals(dir)) continue;
            return dataLocation.getStorageType();
        }
        return StorageType.DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDfsUsed() throws IOException {
        Object object = this.statsLock;
        synchronized (object) {
            return this.volumes.getDfsUsed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBlockPoolUsed(String bpid) throws IOException {
        Object object = this.statsLock;
        synchronized (object) {
            return this.volumes.getBlockPoolUsed(bpid);
        }
    }

    @Override
    public boolean hasEnoughResource() {
        return this.getVolumes().size() >= this.validVolsRequired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCapacity() {
        Object object = this.statsLock;
        synchronized (object) {
            return this.volumes.getCapacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRemaining() throws IOException {
        Object object = this.statsLock;
        synchronized (object) {
            return this.volumes.getRemaining();
        }
    }

    @Override
    public int getNumFailedVolumes() {
        return this.volumes.getVolumeFailureInfos().length;
    }

    @Override
    public String[] getFailedStorageLocations() {
        VolumeFailureInfo[] infos = this.volumes.getVolumeFailureInfos();
        ArrayList failedStorageLocations = Lists.newArrayListWithCapacity((int)infos.length);
        for (VolumeFailureInfo info : infos) {
            failedStorageLocations.add(info.getFailedStorageLocation());
        }
        return failedStorageLocations.toArray(new String[failedStorageLocations.size()]);
    }

    @Override
    public long getLastVolumeFailureDate() {
        long lastVolumeFailureDate = 0L;
        for (VolumeFailureInfo info : this.volumes.getVolumeFailureInfos()) {
            long failureDate = info.getFailureDate();
            if (failureDate <= lastVolumeFailureDate) continue;
            lastVolumeFailureDate = failureDate;
        }
        return lastVolumeFailureDate;
    }

    @Override
    public long getEstimatedCapacityLostTotal() {
        long estimatedCapacityLostTotal = 0L;
        for (VolumeFailureInfo info : this.volumes.getVolumeFailureInfos()) {
            estimatedCapacityLostTotal += info.getEstimatedCapacityLost();
        }
        return estimatedCapacityLostTotal;
    }

    @Override
    public VolumeFailureSummary getVolumeFailureSummary() {
        VolumeFailureInfo[] infos = this.volumes.getVolumeFailureInfos();
        if (infos.length == 0) {
            return null;
        }
        ArrayList failedStorageLocations = Lists.newArrayListWithCapacity((int)infos.length);
        long lastVolumeFailureDate = 0L;
        long estimatedCapacityLostTotal = 0L;
        for (VolumeFailureInfo info : infos) {
            failedStorageLocations.add(info.getFailedStorageLocation());
            long failureDate = info.getFailureDate();
            if (failureDate > lastVolumeFailureDate) {
                lastVolumeFailureDate = failureDate;
            }
            estimatedCapacityLostTotal += info.getEstimatedCapacityLost();
        }
        return new VolumeFailureSummary(failedStorageLocations.toArray(new String[failedStorageLocations.size()]), lastVolumeFailureDate, estimatedCapacityLostTotal);
    }

    @Override
    public long getCacheUsed() {
        return this.cacheManager.getCacheUsed();
    }

    @Override
    public long getCacheCapacity() {
        return this.cacheManager.getCacheCapacity();
    }

    @Override
    public long getNumBlocksFailedToCache() {
        return this.cacheManager.getNumBlocksFailedToCache();
    }

    @Override
    public long getNumBlocksFailedToUncache() {
        return this.cacheManager.getNumBlocksFailedToUncache();
    }

    @Override
    public long getNumBlocksCached() {
        return this.cacheManager.getNumBlocksCached();
    }

    @Override
    public long getLength(ExtendedBlock b) throws IOException {
        return this.getBlockFile(b).length();
    }

    private File getBlockFile(ExtendedBlock b) throws IOException {
        return this.getBlockFile(b.getBlockPoolId(), b.getBlockId());
    }

    File getBlockFile(String bpid, long blockId) throws IOException {
        File f = this.validateBlockFile(bpid, blockId);
        if (f == null) {
            throw new IOException("BlockId " + blockId + " is not valid.");
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getBlockFileNoExistsCheck(ExtendedBlock b, boolean touch) throws IOException {
        File f;
        FsDatasetImpl fsDatasetImpl = this;
        synchronized (fsDatasetImpl) {
            f = this.getFile(b.getBlockPoolId(), b.getLocalBlock().getBlockId(), touch);
        }
        if (f == null) {
            throw new IOException("Block " + b + " is not valid");
        }
        return f;
    }

    @Override
    public InputStream getBlockInputStream(ExtendedBlock b, long seekOffset) throws IOException {
        File blockFile = this.getBlockFileNoExistsCheck(b, true);
        if (isNativeIOAvailable) {
            return NativeIO.getShareDeleteFileInputStream((File)blockFile, (long)seekOffset);
        }
        try {
            return FsDatasetImpl.openAndSeek(blockFile, seekOffset);
        }
        catch (FileNotFoundException fnfe) {
            throw new IOException("Block " + b + " is not valid. " + "Expected block file at " + blockFile + " does not exist.");
        }
    }

    ReplicaInfo getReplicaInfo(ExtendedBlock b) throws ReplicaNotFoundException {
        ReplicaInfo info = this.volumeMap.get(b.getBlockPoolId(), b.getLocalBlock());
        if (info == null) {
            throw new ReplicaNotFoundException("Cannot append to a non-existent replica " + b);
        }
        return info;
    }

    private ReplicaInfo getReplicaInfo(String bpid, long blkid) throws ReplicaNotFoundException {
        ReplicaInfo info = this.volumeMap.get(bpid, blkid);
        if (info == null) {
            throw new ReplicaNotFoundException("Cannot append to a non-existent replica " + bpid + ":" + blkid);
        }
        return info;
    }

    @Override
    public synchronized ReplicaInputStreams getTmpInputStreams(ExtendedBlock b, long blkOffset, long metaOffset) throws IOException {
        ReplicaInfo info = this.getReplicaInfo(b);
        FsVolumeReference ref = info.getVolume().obtainReference();
        try {
            FileInputStream blockInStream = FsDatasetImpl.openAndSeek(info.getBlockFile(), blkOffset);
            try {
                FileInputStream metaInStream = FsDatasetImpl.openAndSeek(info.getMetaFile(), metaOffset);
                return new ReplicaInputStreams(blockInStream, metaInStream, ref);
            }
            catch (IOException e) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{blockInStream});
                throw e;
            }
        }
        catch (IOException e) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{ref});
            throw e;
        }
    }

    private static FileInputStream openAndSeek(File file, long offset) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "r");
            if (offset > 0L) {
                raf.seek(offset);
            }
            return new FileInputStream(raf.getFD());
        }
        catch (IOException ioe) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{raf});
            throw ioe;
        }
    }

    static File moveBlockFiles(Block b, File srcfile, File destdir) throws IOException {
        File dstfile = new File(destdir, b.getBlockName());
        File srcmeta = FsDatasetUtil.getMetaFile(srcfile, b.getGenerationStamp());
        File dstmeta = FsDatasetUtil.getMetaFile(dstfile, b.getGenerationStamp());
        try {
            NativeIO.renameTo((File)srcmeta, (File)dstmeta);
        }
        catch (IOException e) {
            throw new IOException("Failed to move meta file for " + b + " from " + srcmeta + " to " + dstmeta, e);
        }
        try {
            NativeIO.renameTo((File)srcfile, (File)dstfile);
        }
        catch (IOException e) {
            throw new IOException("Failed to move block file for " + b + " from " + srcfile + " to " + dstfile.getAbsolutePath(), e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addFinalizedBlock: Moved " + srcmeta + " to " + dstmeta + " and " + srcfile + " to " + dstfile));
        }
        return dstfile;
    }

    static File[] copyBlockFiles(long blockId, long genStamp, File srcMeta, File srcFile, File destRoot, boolean calculateChecksum) throws IOException {
        File destDir = DatanodeUtil.idToBlockDir(destRoot, blockId);
        File dstFile = new File(destDir, srcFile.getName());
        File dstMeta = FsDatasetUtil.getMetaFile(dstFile, genStamp);
        return FsDatasetImpl.copyBlockFiles(srcMeta, srcFile, dstMeta, dstFile, calculateChecksum);
    }

    static File[] copyBlockFiles(File srcMeta, File srcFile, File dstMeta, File dstFile, boolean calculateChecksum) throws IOException {
        if (calculateChecksum) {
            FsDatasetImpl.computeChecksum(srcMeta, dstMeta, srcFile);
        } else {
            try {
                Storage.nativeCopyFileUnbuffered(srcMeta, dstMeta, true);
            }
            catch (IOException e) {
                throw new IOException("Failed to copy " + srcMeta + " to " + dstMeta, e);
            }
        }
        try {
            Storage.nativeCopyFileUnbuffered(srcFile, dstFile, true);
        }
        catch (IOException e) {
            throw new IOException("Failed to copy " + srcFile + " to " + dstFile, e);
        }
        if (LOG.isDebugEnabled()) {
            if (calculateChecksum) {
                LOG.debug((Object)("Copied " + srcMeta + " to " + dstMeta + " and calculated checksum"));
            } else {
                LOG.debug((Object)("Copied " + srcFile + " to " + dstFile));
            }
        }
        return new File[]{dstMeta, dstFile};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicaInfo moveBlockAcrossStorage(ExtendedBlock block, StorageType targetStorageType) throws IOException {
        ReplicaInfo replicaInfo = this.getReplicaInfo(block);
        if (replicaInfo.getState() != HdfsServerConstants.ReplicaState.FINALIZED) {
            throw new ReplicaNotFoundException("Cannot append to an unfinalized replica " + block);
        }
        if (replicaInfo.getNumBytes() != block.getNumBytes()) {
            throw new IOException("Corrupted replica " + replicaInfo + " with a length of " + replicaInfo.getNumBytes() + " expected length is " + block.getNumBytes());
        }
        if (replicaInfo.getVolume().getStorageType() == targetStorageType) {
            throw new ReplicaAlreadyExistsException("Replica " + replicaInfo + " already exists on storage " + targetStorageType);
        }
        if (replicaInfo.isOnTransientStorage()) {
            throw new IOException("Replica " + replicaInfo + " cannot be moved from storageType : " + replicaInfo.getVolume().getStorageType());
        }
        FsVolumeReference volumeRef = null;
        FsDatasetImpl fsDatasetImpl = this;
        synchronized (fsDatasetImpl) {
            volumeRef = this.volumes.getNextVolume(targetStorageType, block.getNumBytes());
        }
        try {
            File oldBlockFile = replicaInfo.getBlockFile();
            File oldMetaFile = replicaInfo.getMetaFile();
            FsVolumeImpl targetVolume = (FsVolumeImpl)volumeRef.getVolume();
            File[] blockFiles = FsDatasetImpl.copyBlockFiles(block.getBlockId(), block.getGenerationStamp(), oldMetaFile, oldBlockFile, targetVolume.getTmpDir(block.getBlockPoolId()), replicaInfo.isOnTransientStorage());
            ReplicaInfo newReplicaInfo = new ReplicaInPipeline(replicaInfo.getBlockId(), replicaInfo.getGenerationStamp(), targetVolume, blockFiles[0].getParentFile(), 0L);
            newReplicaInfo.setNumBytes(blockFiles[1].length());
            newReplicaInfo = this.finalizeReplica(block.getBlockPoolId(), newReplicaInfo);
            this.removeOldReplica(replicaInfo, newReplicaInfo, oldBlockFile, oldMetaFile, oldBlockFile.length(), oldMetaFile.length(), block.getBlockPoolId());
        }
        finally {
            if (volumeRef != null) {
                volumeRef.close();
            }
        }
        return replicaInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void computeChecksum(File srcMeta, File dstMeta, File blockFile) throws IOException {
        DataChecksum checksum = BlockMetadataHeader.readDataChecksum(srcMeta);
        byte[] data = new byte[65536];
        byte[] crcs = new byte[checksum.getChecksumSize(data.length)];
        DataOutputStream metaOut = null;
        try {
            File parentFile = dstMeta.getParentFile();
            if (parentFile != null && !parentFile.mkdirs() && !parentFile.isDirectory()) {
                throw new IOException("Destination '" + parentFile + "' directory cannot be created");
            }
            metaOut = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(dstMeta), HdfsConstants.SMALL_BUFFER_SIZE));
            BlockMetadataHeader.writeHeader(metaOut, checksum);
            int offset = 0;
            try (FileInputStream dataIn = isNativeIOAvailable ? NativeIO.getShareDeleteFileInputStream((File)blockFile) : new FileInputStream(blockFile);){
                int n;
                while ((n = ((InputStream)dataIn).read(data, offset, data.length - offset)) != -1) {
                    int length;
                    if (n <= 0 || (length = (n += offset) - (offset = n % checksum.getBytesPerChecksum())) <= 0) continue;
                    checksum.calculateChunkedSums(data, 0, length, crcs, 0);
                    metaOut.write(crcs, 0, checksum.getChecksumSize(length));
                    System.arraycopy(data, length, data, 0, offset);
                }
            }
            checksum.calculateChunkedSums(data, 0, offset, crcs, 0);
            metaOut.write(crcs, 0, 4);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{metaOut});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{metaOut});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void truncateBlock(File blockFile, File metaFile, long oldlen, long newlen) throws IOException {
        LOG.info((Object)("truncateBlock: blockFile=" + blockFile + ", metaFile=" + metaFile + ", oldlen=" + oldlen + ", newlen=" + newlen));
        if (newlen == oldlen) {
            return;
        }
        if (newlen > oldlen) {
            throw new IOException("Cannot truncate block to from oldlen (=" + oldlen + ") to newlen (=" + newlen + ")");
        }
        DataChecksum dcs = BlockMetadataHeader.readHeader(metaFile).getChecksum();
        int checksumsize = dcs.getChecksumSize();
        int bpc = dcs.getBytesPerChecksum();
        long n = (newlen - 1L) / (long)bpc + 1L;
        long newmetalen = (long)BlockMetadataHeader.getHeaderSize() + n * (long)checksumsize;
        long lastchunkoffset = (n - 1L) * (long)bpc;
        int lastchunksize = (int)(newlen - lastchunkoffset);
        byte[] b = new byte[Math.max(lastchunksize, checksumsize)];
        try (RandomAccessFile blockRAF = new RandomAccessFile(blockFile, "rw");){
            blockRAF.setLength(newlen);
            blockRAF.seek(lastchunkoffset);
            blockRAF.readFully(b, 0, lastchunksize);
        }
        dcs.update(b, 0, lastchunksize);
        dcs.writeValue(b, 0, false);
        try (RandomAccessFile metaRAF = new RandomAccessFile(metaFile, "rw");){
            metaRAF.setLength(newmetalen);
            metaRAF.seek(newmetalen - (long)checksumsize);
            metaRAF.write(b, 0, checksumsize);
        }
    }

    @Override
    public synchronized ReplicaHandler append(ExtendedBlock b, long newGS, long expectedBlockLen) throws IOException {
        if (newGS < b.getGenerationStamp()) {
            throw new IOException("The new generation stamp " + newGS + " should be greater than the replica " + b + "'s generation stamp");
        }
        ReplicaInfo replicaInfo = this.getReplicaInfo(b);
        LOG.info((Object)("Appending to " + replicaInfo));
        if (replicaInfo.getState() != HdfsServerConstants.ReplicaState.FINALIZED) {
            throw new ReplicaNotFoundException("Cannot append to an unfinalized replica " + b);
        }
        if (replicaInfo.getNumBytes() != expectedBlockLen) {
            throw new IOException("Corrupted replica " + replicaInfo + " with a length of " + replicaInfo.getNumBytes() + " expected length is " + expectedBlockLen);
        }
        FsVolumeReference ref = replicaInfo.getVolume().obtainReference();
        ReplicaBeingWritten replica = null;
        try {
            replica = this.append(b.getBlockPoolId(), (FinalizedReplica)replicaInfo, newGS, b.getNumBytes());
        }
        catch (IOException e) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{ref});
            throw e;
        }
        return new ReplicaHandler(replica, ref);
    }

    private synchronized ReplicaBeingWritten append(String bpid, FinalizedReplica replicaInfo, long newGS, long estimateBlockLen) throws IOException {
        this.cacheManager.uncacheBlock(bpid, replicaInfo.getBlockId());
        replicaInfo.unlinkBlock(1);
        File blkfile = replicaInfo.getBlockFile();
        FsVolumeImpl v = (FsVolumeImpl)replicaInfo.getVolume();
        long bytesReserved = estimateBlockLen - replicaInfo.getNumBytes();
        if (v.getAvailable() < bytesReserved) {
            throw new DiskChecker.DiskOutOfSpaceException("Insufficient space for appending to " + replicaInfo);
        }
        File newBlkFile = new File(v.getRbwDir(bpid), replicaInfo.getBlockName());
        File oldmeta = replicaInfo.getMetaFile();
        ReplicaBeingWritten newReplicaInfo = new ReplicaBeingWritten(replicaInfo.getBlockId(), replicaInfo.getNumBytes(), newGS, v, newBlkFile.getParentFile(), Thread.currentThread(), bytesReserved);
        File newmeta = newReplicaInfo.getMetaFile();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Renaming " + oldmeta + " to " + newmeta));
        }
        try {
            NativeIO.renameTo((File)oldmeta, (File)newmeta);
        }
        catch (IOException e) {
            throw new IOException("Block " + replicaInfo + " reopen failed. " + " Unable to move meta file  " + oldmeta + " to rbw dir " + newmeta, e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Renaming " + blkfile + " to " + newBlkFile + ", file length=" + blkfile.length()));
        }
        try {
            NativeIO.renameTo((File)blkfile, (File)newBlkFile);
        }
        catch (IOException e) {
            try {
                NativeIO.renameTo((File)newmeta, (File)oldmeta);
            }
            catch (IOException ex) {
                LOG.warn((Object)("Cannot move meta file " + newmeta + "back to the finalized directory " + oldmeta), (Throwable)ex);
            }
            throw new IOException("Block " + replicaInfo + " reopen failed. " + " Unable to move block file " + blkfile + " to rbw dir " + newBlkFile, e);
        }
        this.volumeMap.add(bpid, newReplicaInfo);
        v.reserveSpaceForRbw(bytesReserved);
        return newReplicaInfo;
    }

    private ReplicaInfo recoverCheck(ExtendedBlock b, long newGS, long expectedBlockLen) throws IOException {
        ReplicaInfo replicaInfo = this.getReplicaInfo(b.getBlockPoolId(), b.getBlockId());
        if (replicaInfo.getState() != HdfsServerConstants.ReplicaState.FINALIZED && replicaInfo.getState() != HdfsServerConstants.ReplicaState.RBW) {
            throw new ReplicaNotFoundException("Cannot recover append/close to a replica that's not FINALIZED and not RBW " + replicaInfo);
        }
        long replicaGenerationStamp = replicaInfo.getGenerationStamp();
        if (replicaGenerationStamp < b.getGenerationStamp() || replicaGenerationStamp > newGS) {
            throw new ReplicaNotFoundException("Cannot append to a replica with unexpected generation stamp " + replicaGenerationStamp + ". Expected GS range is [" + b.getGenerationStamp() + ", " + newGS + "].");
        }
        long replicaLen = replicaInfo.getNumBytes();
        if (replicaInfo.getState() == HdfsServerConstants.ReplicaState.RBW) {
            ReplicaBeingWritten rbw = (ReplicaBeingWritten)replicaInfo;
            rbw.stopWriter(this.datanode.getDnConf().getXceiverStopTimeout());
            rbw.setWriter(Thread.currentThread());
            if (replicaLen != rbw.getBytesOnDisk() || replicaLen != rbw.getBytesAcked()) {
                throw new ReplicaAlreadyExistsException("RBW replica " + replicaInfo + "bytesRcvd(" + rbw.getNumBytes() + "), bytesOnDisk(" + rbw.getBytesOnDisk() + "), and bytesAcked(" + rbw.getBytesAcked() + ") are not the same.");
            }
        }
        if (replicaLen != expectedBlockLen) {
            throw new IOException("Corrupted replica " + replicaInfo + " with a length of " + replicaLen + " expected length is " + expectedBlockLen);
        }
        return replicaInfo;
    }

    @Override
    public synchronized ReplicaHandler recoverAppend(ExtendedBlock b, long newGS, long expectedBlockLen) throws IOException {
        ReplicaBeingWritten replica;
        LOG.info((Object)("Recover failed append to " + b));
        ReplicaInfo replicaInfo = this.recoverCheck(b, newGS, expectedBlockLen);
        FsVolumeReference ref = replicaInfo.getVolume().obtainReference();
        try {
            if (replicaInfo.getState() == HdfsServerConstants.ReplicaState.FINALIZED) {
                replica = this.append(b.getBlockPoolId(), (FinalizedReplica)replicaInfo, newGS, b.getNumBytes());
            } else {
                this.bumpReplicaGS(replicaInfo, newGS);
                replica = (ReplicaBeingWritten)replicaInfo;
            }
        }
        catch (IOException e) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{ref});
            throw e;
        }
        return new ReplicaHandler(replica, ref);
    }

    @Override
    public synchronized String recoverClose(ExtendedBlock b, long newGS, long expectedBlockLen) throws IOException {
        LOG.info((Object)("Recover failed close " + b));
        ReplicaInfo replicaInfo = this.recoverCheck(b, newGS, expectedBlockLen);
        this.bumpReplicaGS(replicaInfo, newGS);
        if (replicaInfo.getState() == HdfsServerConstants.ReplicaState.RBW) {
            this.finalizeReplica(b.getBlockPoolId(), replicaInfo);
        }
        return replicaInfo.getStorageUuid();
    }

    private void bumpReplicaGS(ReplicaInfo replicaInfo, long newGS) throws IOException {
        long oldGS = replicaInfo.getGenerationStamp();
        File oldmeta = replicaInfo.getMetaFile();
        replicaInfo.setGenerationStamp(newGS);
        File newmeta = replicaInfo.getMetaFile();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Renaming " + oldmeta + " to " + newmeta));
        }
        try {
            NativeIO.renameTo((File)oldmeta, (File)newmeta);
        }
        catch (IOException e) {
            replicaInfo.setGenerationStamp(oldGS);
            throw new IOException("Block " + replicaInfo + " reopen failed. " + " Unable to move meta file  " + oldmeta + " to " + newmeta, e);
        }
    }

    @Override
    public synchronized ReplicaHandler createRbw(StorageType storageType, ExtendedBlock b, boolean allowLazyPersist) throws IOException {
        File f;
        FsVolumeReference ref;
        ReplicaInfo replicaInfo = this.volumeMap.get(b.getBlockPoolId(), b.getBlockId());
        if (replicaInfo != null) {
            throw new ReplicaAlreadyExistsException("Block " + b + " already exists in state " + (Object)((Object)replicaInfo.getState()) + " and thus cannot be created.");
        }
        while (true) {
            try {
                if (allowLazyPersist) {
                    ref = this.volumes.getNextTransientVolume(b.getNumBytes());
                    this.datanode.getMetrics().incrRamDiskBlocksWrite();
                    break;
                }
                ref = this.volumes.getNextVolume(storageType, b.getNumBytes());
            }
            catch (DiskChecker.DiskOutOfSpaceException de) {
                if (allowLazyPersist) {
                    this.datanode.getMetrics().incrRamDiskBlocksWriteFallback();
                    allowLazyPersist = false;
                    continue;
                }
                throw de;
            }
            break;
        }
        FsVolumeImpl v = (FsVolumeImpl)ref.getVolume();
        try {
            f = v.createRbwFile(b.getBlockPoolId(), b.getLocalBlock());
        }
        catch (IOException e) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{ref});
            throw e;
        }
        ReplicaBeingWritten newReplicaInfo = new ReplicaBeingWritten(b.getBlockId(), b.getGenerationStamp(), v, f.getParentFile(), b.getNumBytes());
        this.volumeMap.add(b.getBlockPoolId(), newReplicaInfo);
        return new ReplicaHandler(newReplicaInfo, ref);
    }

    @Override
    public synchronized ReplicaHandler recoverRbw(ExtendedBlock b, long newGS, long minBytesRcvd, long maxBytesRcvd) throws IOException {
        LOG.info((Object)("Recover RBW replica " + b));
        ReplicaInfo replicaInfo = this.getReplicaInfo(b.getBlockPoolId(), b.getBlockId());
        if (replicaInfo.getState() != HdfsServerConstants.ReplicaState.RBW) {
            throw new ReplicaNotFoundException("Cannot recover a non-RBW replica " + replicaInfo);
        }
        ReplicaBeingWritten rbw = (ReplicaBeingWritten)replicaInfo;
        LOG.info((Object)("Recovering " + rbw));
        rbw.stopWriter(this.datanode.getDnConf().getXceiverStopTimeout());
        rbw.setWriter(Thread.currentThread());
        long replicaGenerationStamp = rbw.getGenerationStamp();
        if (replicaGenerationStamp < b.getGenerationStamp() || replicaGenerationStamp > newGS) {
            throw new ReplicaNotFoundException("Cannot append to a replica with unexpected generation stamp " + b + ". Expected GS range is [" + b.getGenerationStamp() + ", " + newGS + "].");
        }
        long bytesAcked = rbw.getBytesAcked();
        long numBytes = rbw.getNumBytes();
        if (bytesAcked < minBytesRcvd || numBytes > maxBytesRcvd) {
            throw new ReplicaNotFoundException("Unmatched length replica " + replicaInfo + ": BytesAcked = " + bytesAcked + " BytesRcvd = " + numBytes + " are not in the range of [" + minBytesRcvd + ", " + maxBytesRcvd + "].");
        }
        FsVolumeReference ref = rbw.getVolume().obtainReference();
        try {
            if (numBytes > bytesAcked) {
                File replicafile = rbw.getBlockFile();
                FsDatasetImpl.truncateBlock(replicafile, rbw.getMetaFile(), numBytes, bytesAcked);
                rbw.setNumBytes(bytesAcked);
                rbw.setLastChecksumAndDataLen(bytesAcked, null);
            }
            this.bumpReplicaGS(rbw, newGS);
        }
        catch (IOException e) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{ref});
            throw e;
        }
        return new ReplicaHandler(rbw, ref);
    }

    @Override
    public synchronized ReplicaInPipeline convertTemporaryToRbw(ExtendedBlock b) throws IOException {
        long blockId = b.getBlockId();
        long expectedGs = b.getGenerationStamp();
        long visible = b.getNumBytes();
        LOG.info((Object)("Convert " + b + " from Temporary to RBW, visible length=" + visible));
        ReplicaInfo r = this.volumeMap.get(b.getBlockPoolId(), blockId);
        if (r == null) {
            throw new ReplicaNotFoundException("Cannot append to a non-existent replica " + b);
        }
        if (r.getState() != HdfsServerConstants.ReplicaState.TEMPORARY) {
            throw new ReplicaAlreadyExistsException("r.getState() != ReplicaState.TEMPORARY, r=" + r);
        }
        ReplicaInPipeline temp = (ReplicaInPipeline)r;
        if (temp.getGenerationStamp() != expectedGs) {
            throw new ReplicaAlreadyExistsException("temp.getGenerationStamp() != expectedGs = " + expectedGs + ", temp=" + temp);
        }
        long numBytes = temp.getNumBytes();
        if (numBytes < visible) {
            throw new IOException(numBytes + " = numBytes < visible = " + visible + ", temp=" + temp);
        }
        FsVolumeImpl v = (FsVolumeImpl)temp.getVolume();
        if (v == null) {
            throw new IOException("r.getVolume() = null, temp=" + temp);
        }
        BlockPoolSlice bpslice = v.getBlockPoolSlice(b.getBlockPoolId());
        File dest = FsDatasetImpl.moveBlockFiles(b.getLocalBlock(), temp.getBlockFile(), bpslice.getRbwDir());
        ReplicaBeingWritten rbw = new ReplicaBeingWritten(blockId, numBytes, expectedGs, v, dest.getParentFile(), Thread.currentThread(), 0L);
        rbw.setBytesAcked(visible);
        this.volumeMap.add(b.getBlockPoolId(), rbw);
        return rbw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicaHandler createTemporary(StorageType storageType, ExtendedBlock b) throws IOException {
        long startTimeMs = Time.monotonicNow();
        long writerStopTimeoutMs = this.datanode.getDnConf().getXceiverStopTimeout();
        ReplicaInfo lastFoundReplicaInfo = null;
        while (true) {
            FsDatasetImpl fsDatasetImpl = this;
            synchronized (fsDatasetImpl) {
                ReplicaInfo currentReplicaInfo = this.volumeMap.get(b.getBlockPoolId(), b.getBlockId());
                if (currentReplicaInfo == lastFoundReplicaInfo) {
                    File f;
                    if (lastFoundReplicaInfo != null) {
                        this.invalidate(b.getBlockPoolId(), new Block[]{lastFoundReplicaInfo});
                    }
                    FsVolumeReference ref = this.volumes.getNextVolume(storageType, b.getNumBytes());
                    FsVolumeImpl v = (FsVolumeImpl)ref.getVolume();
                    try {
                        f = v.createTmpFile(b.getBlockPoolId(), b.getLocalBlock());
                    }
                    catch (IOException e) {
                        IOUtils.cleanup(null, (Closeable[])new Closeable[]{ref});
                        throw e;
                    }
                    ReplicaInPipeline newReplicaInfo = new ReplicaInPipeline(b.getBlockId(), b.getGenerationStamp(), v, f.getParentFile(), 0L);
                    this.volumeMap.add(b.getBlockPoolId(), newReplicaInfo);
                    return new ReplicaHandler(newReplicaInfo, ref);
                }
                if (currentReplicaInfo.getGenerationStamp() >= b.getGenerationStamp() || !(currentReplicaInfo instanceof ReplicaInPipeline)) {
                    throw new ReplicaAlreadyExistsException("Block " + b + " already exists in state " + (Object)((Object)currentReplicaInfo.getState()) + " and thus cannot be created.");
                }
                lastFoundReplicaInfo = currentReplicaInfo;
            }
            long writerStopMs = Time.monotonicNow() - startTimeMs;
            if (writerStopMs > writerStopTimeoutMs) {
                LOG.warn((Object)("Unable to stop existing writer for block " + b + " after " + writerStopMs + " miniseconds."));
                throw new IOException("Unable to stop existing writer for block " + b + " after " + writerStopMs + " miniseconds.");
            }
            ((ReplicaInPipeline)lastFoundReplicaInfo).stopWriter(writerStopTimeoutMs);
        }
    }

    @Override
    public void adjustCrcChannelPosition(ExtendedBlock b, ReplicaOutputStreams streams, int checksumSize) throws IOException {
        FileOutputStream file = (FileOutputStream)streams.getChecksumOut();
        FileChannel channel = file.getChannel();
        long oldPos = channel.position();
        long newPos = oldPos - (long)checksumSize;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Changing meta file offset of block " + b + " from " + oldPos + " to " + newPos));
        }
        channel.position(newPos);
    }

    @Override
    public synchronized void finalizeBlock(ExtendedBlock b) throws IOException {
        if (Thread.interrupted()) {
            throw new IOException("Cannot finalize block from Interrupted Thread");
        }
        ReplicaInfo replicaInfo = this.getReplicaInfo(b);
        if (replicaInfo.getState() == HdfsServerConstants.ReplicaState.FINALIZED) {
            return;
        }
        this.finalizeReplica(b.getBlockPoolId(), replicaInfo);
    }

    private synchronized FinalizedReplica finalizeReplica(String bpid, ReplicaInfo replicaInfo) throws IOException {
        FinalizedReplica newReplicaInfo = null;
        if (replicaInfo.getState() == HdfsServerConstants.ReplicaState.RUR && ((ReplicaUnderRecovery)replicaInfo).getOriginalReplica().getState() == HdfsServerConstants.ReplicaState.FINALIZED) {
            newReplicaInfo = (FinalizedReplica)((ReplicaUnderRecovery)replicaInfo).getOriginalReplica();
        } else {
            FsVolumeImpl v = (FsVolumeImpl)replicaInfo.getVolume();
            File f = replicaInfo.getBlockFile();
            if (v == null) {
                throw new IOException("No volume for temporary file " + f + " for block " + replicaInfo);
            }
            File dest = v.addFinalizedBlock(bpid, replicaInfo, f, replicaInfo.getBytesReserved());
            newReplicaInfo = new FinalizedReplica(replicaInfo, v, dest.getParentFile());
            if (v.isTransientStorage()) {
                this.ramDiskReplicaTracker.addReplica(bpid, replicaInfo.getBlockId(), v);
                this.datanode.getMetrics().addRamDiskBytesWrite(replicaInfo.getNumBytes());
            }
        }
        this.volumeMap.add(bpid, newReplicaInfo);
        return newReplicaInfo;
    }

    @Override
    public synchronized void unfinalizeBlock(ExtendedBlock b) throws IOException {
        ReplicaInfo replicaInfo = this.volumeMap.get(b.getBlockPoolId(), b.getLocalBlock());
        if (replicaInfo != null && replicaInfo.getState() == HdfsServerConstants.ReplicaState.TEMPORARY) {
            this.volumeMap.remove(b.getBlockPoolId(), b.getLocalBlock());
            if (this.delBlockFromDisk(replicaInfo.getBlockFile(), replicaInfo.getMetaFile(), b.getLocalBlock())) {
                LOG.warn((Object)("Block " + b + " unfinalized and removed. "));
            }
            if (replicaInfo.getVolume().isTransientStorage()) {
                this.ramDiskReplicaTracker.discardReplica(b.getBlockPoolId(), b.getBlockId(), true);
            }
        }
    }

    private boolean delBlockFromDisk(File blockFile, File metaFile, Block b) {
        if (blockFile == null) {
            LOG.warn((Object)("No file exists for block: " + b));
            return true;
        }
        if (!blockFile.delete()) {
            LOG.warn((Object)("Not able to delete the block file: " + blockFile));
            return false;
        }
        if (metaFile != null && !metaFile.delete()) {
            LOG.warn((Object)("Not able to delete the meta block file: " + metaFile));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<DatanodeStorage, BlockListAsLongs> getBlockReports(String bpid) {
        HashMap<DatanodeStorage, BlockListAsLongs> blockReportsMap = new HashMap<DatanodeStorage, BlockListAsLongs>();
        HashMap<String, BlockListAsLongs.Builder> builders = new HashMap<String, BlockListAsLongs.Builder>();
        List<FsVolumeImpl> curVolumes = this.getVolumes();
        for (FsVolumeSpi fsVolumeSpi : curVolumes) {
            builders.put(fsVolumeSpi.getStorageID(), BlockListAsLongs.builder());
        }
        Iterator<FsVolumeImpl> i$ = this;
        synchronized (i$) {
            block9: for (ReplicaInfo b : this.volumeMap.replicas(bpid)) {
                switch (b.getState()) {
                    case FINALIZED: 
                    case RBW: 
                    case RWR: {
                        ((BlockListAsLongs.Builder)builders.get(b.getVolume().getStorageID())).add(b);
                        continue block9;
                    }
                    case RUR: {
                        ReplicaUnderRecovery rur = (ReplicaUnderRecovery)b;
                        ((BlockListAsLongs.Builder)builders.get(rur.getVolume().getStorageID())).add(rur.getOriginalReplica());
                        continue block9;
                    }
                    case TEMPORARY: {
                        continue block9;
                    }
                }
                assert (false) : "Illegal ReplicaInfo state.";
            }
        }
        for (FsVolumeImpl fsVolumeImpl : curVolumes) {
            blockReportsMap.put(fsVolumeImpl.toDatanodeStorage(), ((BlockListAsLongs.Builder)builders.get(fsVolumeImpl.getStorageID())).build());
        }
        return blockReportsMap;
    }

    @Override
    public List<Long> getCacheReport(String bpid) {
        return this.cacheManager.getCachedBlocks(bpid);
    }

    @Override
    public synchronized List<FinalizedReplica> getFinalizedBlocks(String bpid) {
        ArrayList<FinalizedReplica> finalized = new ArrayList<FinalizedReplica>(this.volumeMap.size(bpid));
        for (ReplicaInfo b : this.volumeMap.replicas(bpid)) {
            if (b.getState() != HdfsServerConstants.ReplicaState.FINALIZED) continue;
            finalized.add(new FinalizedReplica((FinalizedReplica)b));
        }
        return finalized;
    }

    @Override
    public synchronized List<FinalizedReplica> getFinalizedBlocksOnPersistentStorage(String bpid) {
        ArrayList<FinalizedReplica> finalized = new ArrayList<FinalizedReplica>(this.volumeMap.size(bpid));
        for (ReplicaInfo b : this.volumeMap.replicas(bpid)) {
            if (b.getVolume().isTransientStorage() || b.getState() != HdfsServerConstants.ReplicaState.FINALIZED) continue;
            finalized.add(new FinalizedReplica((FinalizedReplica)b));
        }
        return finalized;
    }

    @Override
    public void checkBlock(ExtendedBlock b, long minLength, HdfsServerConstants.ReplicaState state) throws ReplicaNotFoundException, UnexpectedReplicaStateException, FileNotFoundException, EOFException, IOException {
        ReplicaInfo replicaInfo = this.volumeMap.get(b.getBlockPoolId(), b.getLocalBlock());
        if (replicaInfo == null) {
            throw new ReplicaNotFoundException(b);
        }
        if (replicaInfo.getState() != state) {
            throw new UnexpectedReplicaStateException(b, state);
        }
        if (!replicaInfo.getBlockFile().exists()) {
            throw new FileNotFoundException(replicaInfo.getBlockFile().getPath());
        }
        long onDiskLength = this.getLength(b);
        if (onDiskLength < minLength) {
            throw new EOFException(b + "'s on-disk length " + onDiskLength + " is shorter than minLength " + minLength);
        }
    }

    @Override
    public boolean isValidBlock(ExtendedBlock b) {
        return this.isValid(b, HdfsServerConstants.ReplicaState.FINALIZED);
    }

    @Override
    public boolean isValidRbw(ExtendedBlock b) {
        return this.isValid(b, HdfsServerConstants.ReplicaState.RBW);
    }

    private boolean isValid(ExtendedBlock b, HdfsServerConstants.ReplicaState state) {
        try {
            this.checkBlock(b, 0L, state);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File validateBlockFile(String bpid, long blockId) {
        File f;
        FsDatasetImpl fsDatasetImpl = this;
        synchronized (fsDatasetImpl) {
            f = this.getFile(bpid, blockId, false);
        }
        if (f != null) {
            if (f.exists()) {
                return f;
            }
            this.datanode.checkDiskErrorAsync();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("blockId=" + blockId + ", f=" + f));
        }
        return null;
    }

    static void checkReplicaFiles(ReplicaInfo r) throws IOException {
        File f = r.getBlockFile();
        if (!f.exists()) {
            throw new FileNotFoundException("File " + f + " not found, r=" + r);
        }
        if (r.getBytesOnDisk() != f.length()) {
            throw new IOException("File length mismatched.  The length of " + f + " is " + f.length() + " but r=" + r);
        }
        File metafile = FsDatasetUtil.getMetaFile(f, r.getGenerationStamp());
        if (!metafile.exists()) {
            throw new IOException("Metafile " + metafile + " does not exist, r=" + r);
        }
        if (metafile.length() == 0L) {
            throw new IOException("Metafile " + metafile + " is empty, r=" + r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(String bpid, Block[] invalidBlks) throws IOException {
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < invalidBlks.length; ++i) {
            RamDiskReplicaTracker.RamDiskReplica replicaInfo;
            FsVolumeImpl v;
            File f;
            FsDatasetImpl fsDatasetImpl = this;
            synchronized (fsDatasetImpl) {
                ReplicaInfo info = this.volumeMap.get(bpid, invalidBlks[i]);
                if (info == null) {
                    LOG.info((Object)("Failed to delete replica " + invalidBlks[i] + ": ReplicaInfo not found."));
                    continue;
                }
                if (info.getGenerationStamp() != invalidBlks[i].getGenerationStamp()) {
                    errors.add("Failed to delete replica " + invalidBlks[i] + ": GenerationStamp not matched, info=" + info);
                    continue;
                }
                f = info.getBlockFile();
                v = (FsVolumeImpl)info.getVolume();
                if (v == null) {
                    errors.add("Failed to delete replica " + invalidBlks[i] + ". No volume for this replica, file=" + f);
                    continue;
                }
                File parent = f.getParentFile();
                if (parent == null) {
                    errors.add("Failed to delete replica " + invalidBlks[i] + ". Parent not found for file " + f);
                    continue;
                }
                ReplicaInfo removing = this.volumeMap.remove(bpid, invalidBlks[i]);
                this.addDeletingBlock(bpid, removing.getBlockId());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Block file " + removing.getBlockFile().getName() + " is to be deleted"));
                }
                if (removing instanceof ReplicaInPipelineInterface) {
                    ((ReplicaInPipelineInterface)((Object)removing)).releaseAllBytesReserved();
                }
            }
            if (v.isTransientStorage() && (replicaInfo = this.ramDiskReplicaTracker.getReplica(bpid, invalidBlks[i].getBlockId())) != null) {
                if (!replicaInfo.getIsPersisted()) {
                    this.datanode.getMetrics().incrRamDiskBlocksDeletedBeforeLazyPersisted();
                }
                this.ramDiskReplicaTracker.discardReplica(replicaInfo.getBlockPoolId(), replicaInfo.getBlockId(), true);
            }
            this.datanode.getShortCircuitRegistry().processBlockInvalidation(new ExtendedBlockId(invalidBlks[i].getBlockId(), bpid));
            this.cacheManager.uncacheBlock(bpid, invalidBlks[i].getBlockId());
            try {
                this.asyncDiskService.deleteAsync(v.obtainReference(), f, FsDatasetUtil.getMetaFile(f, invalidBlks[i].getGenerationStamp()), new ExtendedBlock(bpid, invalidBlks[i]), this.dataStorage.getTrashDirectoryForBlockFile(bpid, f));
                continue;
            }
            catch (ClosedChannelException e) {
                LOG.warn((Object)("Volume " + v + " is closed, ignore the deletion task for " + "block " + invalidBlks[i]));
            }
        }
        if (!errors.isEmpty()) {
            StringBuilder b = new StringBuilder("Failed to delete ").append(errors.size()).append(" (out of ").append(invalidBlks.length).append(") replica(s):");
            for (int i = 0; i < errors.size(); ++i) {
                b.append("\n").append(i).append(") ").append((String)errors.get(i));
            }
            throw new IOException(b.toString());
        }
    }

    public void invalidate(String bpid, ReplicaInfo block) {
        this.datanode.getShortCircuitRegistry().processBlockInvalidation(new ExtendedBlockId(block.getBlockId(), bpid));
        this.cacheManager.uncacheBlock(bpid, block.getBlockId());
        this.datanode.notifyNamenodeDeletedBlock(new ExtendedBlock(bpid, block), block.getStorageUuid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cacheBlock(String bpid, long blockId) {
        Executor volumeExecutor;
        long genstamp;
        long length;
        String blockFileName;
        FsDatasetImpl fsDatasetImpl = this;
        synchronized (fsDatasetImpl) {
            FsVolumeImpl volume;
            boolean success;
            ReplicaInfo info;
            block14: {
                block13: {
                    block12: {
                        info = this.volumeMap.get(bpid, blockId);
                        success = false;
                        if (info != null) break block12;
                        LOG.warn((Object)("Failed to cache block with id " + blockId + ", pool " + bpid + ": ReplicaInfo not found."));
                        if (success) return;
                        this.cacheManager.numBlocksFailedToCache.incrementAndGet();
                        return;
                    }
                    if (info.getState() == HdfsServerConstants.ReplicaState.FINALIZED) break block13;
                    LOG.warn((Object)("Failed to cache block with id " + blockId + ", pool " + bpid + ": replica is not finalized; it is in state " + (Object)((Object)info.getState())));
                    if (success) return;
                    this.cacheManager.numBlocksFailedToCache.incrementAndGet();
                    return;
                }
                volume = (FsVolumeImpl)info.getVolume();
                if (volume != null) break block14;
                LOG.warn((Object)("Failed to cache block with id " + blockId + ", pool " + bpid + ": volume not found."));
                if (success) return;
                this.cacheManager.numBlocksFailedToCache.incrementAndGet();
                return;
            }
            try {
                block16: {
                    block17: {
                        if (!volume.isTransientStorage()) break block16;
                        break block17;
                        catch (ClassCastException e) {
                            LOG.warn((Object)("Failed to cache block with id " + blockId + ": volume was not an instance of FsVolumeImpl."));
                            return;
                        }
                    }
                    LOG.warn((Object)("Caching not supported on block with id " + blockId + " since the volume is backed by RAM."));
                    return;
                }
                success = true;
            }
            finally {
                if (!success) {
                    this.cacheManager.numBlocksFailedToCache.incrementAndGet();
                }
            }
            blockFileName = info.getBlockFile().getAbsolutePath();
            length = info.getVisibleLength();
            genstamp = info.getGenerationStamp();
            volumeExecutor = volume.getCacheExecutor();
        }
        this.cacheManager.cacheBlock(blockId, bpid, blockFileName, length, genstamp, volumeExecutor);
    }

    @Override
    public void cache(String bpid, long[] blockIds) {
        for (int i = 0; i < blockIds.length; ++i) {
            this.cacheBlock(bpid, blockIds[i]);
        }
    }

    @Override
    public void uncache(String bpid, long[] blockIds) {
        for (int i = 0; i < blockIds.length; ++i) {
            this.cacheManager.uncacheBlock(bpid, blockIds[i]);
        }
    }

    @Override
    public boolean isCached(String bpid, long blockId) {
        return this.cacheManager.isCached(bpid, blockId);
    }

    @Override
    public synchronized boolean contains(ExtendedBlock block) {
        long blockId = block.getLocalBlock().getBlockId();
        return this.getFile(block.getBlockPoolId(), blockId, false) != null;
    }

    File getFile(String bpid, long blockId, boolean touch) {
        ReplicaInfo info = this.volumeMap.get(bpid, blockId);
        if (info != null) {
            if (touch && info.getVolume().isTransientStorage()) {
                this.ramDiskReplicaTracker.touch(bpid, blockId);
                this.datanode.getMetrics().incrRamDiskBlocksReadHits();
            }
            return info.getBlockFile();
        }
        return null;
    }

    @Override
    public Set<File> checkDataDir() {
        return this.volumes.checkDirs();
    }

    public String toString() {
        return "FSDataset{dirpath='" + this.volumes + "'}";
    }

    void registerMBean(String datanodeUuid) {
        try {
            StandardMBean bean = new StandardMBean(this, FSDatasetMBean.class);
            this.mbeanName = MBeans.register((String)"DataNode", (String)("FSDatasetState-" + datanodeUuid), (Object)bean);
        }
        catch (NotCompliantMBeanException e) {
            LOG.warn((Object)"Error registering FSDatasetState MBean", (Throwable)e);
        }
        LOG.info((Object)"Registered FSDatasetState MBean");
    }

    @Override
    public void shutdown() {
        this.fsRunning = false;
        ((LazyWriter)this.lazyWriter.getRunnable()).stop();
        this.lazyWriter.interrupt();
        if (this.mbeanName != null) {
            MBeans.unregister((ObjectName)this.mbeanName);
        }
        if (this.asyncDiskService != null) {
            this.asyncDiskService.shutdown();
        }
        if (this.asyncLazyPersistService != null) {
            this.asyncLazyPersistService.shutdown();
        }
        if (this.volumes != null) {
            this.volumes.shutdown();
        }
        try {
            this.lazyWriter.join();
        }
        catch (InterruptedException ie) {
            LOG.warn((Object)"FsDatasetImpl.shutdown ignoring InterruptedException from LazyWriter.join");
        }
    }

    @Override
    public String getStorageInfo() {
        return this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkAndUpdate(String bpid, long blockId, File diskFile, File diskMetaFile, FsVolumeSpi vol) throws IOException {
        Block corruptBlock = null;
        FsDatasetImpl fsDatasetImpl = this;
        synchronized (fsDatasetImpl) {
            long diskGS;
            ReplicaInfo memBlockInfo = this.volumeMap.get(bpid, blockId);
            if (memBlockInfo != null && memBlockInfo.getState() != HdfsServerConstants.ReplicaState.FINALIZED) {
                return;
            }
            long l = diskGS = diskMetaFile != null && diskMetaFile.exists() ? Block.getGenerationStamp(diskMetaFile.getName()) : 0L;
            if (diskFile == null || !diskFile.exists()) {
                if (memBlockInfo == null) {
                    if (diskMetaFile != null && diskMetaFile.exists() && diskMetaFile.delete()) {
                        LOG.warn((Object)("Deleted a metadata file without a block " + diskMetaFile.getAbsolutePath()));
                    }
                    return;
                }
                if (!memBlockInfo.getBlockFile().exists()) {
                    this.volumeMap.remove(bpid, blockId);
                    if (vol.isTransientStorage()) {
                        this.ramDiskReplicaTracker.discardReplica(bpid, blockId, true);
                    }
                    LOG.warn((Object)("Removed block " + blockId + " from memory with missing block file on the disk"));
                    if (diskMetaFile != null && diskMetaFile.exists() && diskMetaFile.delete()) {
                        LOG.warn((Object)("Deleted a metadata file for the deleted block " + diskMetaFile.getAbsolutePath()));
                    }
                }
                return;
            }
            if (memBlockInfo == null) {
                FinalizedReplica diskBlockInfo = new FinalizedReplica(blockId, diskFile.length(), diskGS, vol, diskFile.getParentFile());
                this.volumeMap.add(bpid, diskBlockInfo);
                if (vol.isTransientStorage()) {
                    this.ramDiskReplicaTracker.addReplica(bpid, blockId, (FsVolumeImpl)vol);
                }
                LOG.warn((Object)("Added missing block to memory " + diskBlockInfo));
                return;
            }
            File memFile = memBlockInfo.getBlockFile();
            if (memFile.exists()) {
                if (memFile.compareTo(diskFile) != 0) {
                    if (diskMetaFile.exists()) {
                        if (memBlockInfo.getMetaFile().exists()) {
                            FinalizedReplica diskBlockInfo = new FinalizedReplica(blockId, diskFile.length(), diskGS, vol, diskFile.getParentFile());
                            ((FsVolumeImpl)vol).getBlockPoolSlice(bpid).resolveDuplicateReplicas(memBlockInfo, diskBlockInfo, this.volumeMap);
                        }
                    } else if (!diskFile.delete()) {
                        LOG.warn((Object)("Failed to delete " + diskFile + ". Will retry on next scan"));
                    }
                }
            } else {
                LOG.warn((Object)("Block file in volumeMap " + memFile.getAbsolutePath() + " does not exist. Updating it to the file found during scan " + diskFile.getAbsolutePath()));
                memBlockInfo.setDir(diskFile.getParentFile());
                memFile = diskFile;
                LOG.warn((Object)("Updating generation stamp for block " + blockId + " from " + memBlockInfo.getGenerationStamp() + " to " + diskGS));
                memBlockInfo.setGenerationStamp(diskGS);
            }
            if (memBlockInfo.getGenerationStamp() != diskGS) {
                File memMetaFile = FsDatasetUtil.getMetaFile(diskFile, memBlockInfo.getGenerationStamp());
                if (memMetaFile.exists()) {
                    if (memMetaFile.compareTo(diskMetaFile) != 0) {
                        LOG.warn((Object)("Metadata file in memory " + memMetaFile.getAbsolutePath() + " does not match file found by scan " + (diskMetaFile == null ? null : diskMetaFile.getAbsolutePath())));
                    }
                } else {
                    long gs = diskMetaFile != null && diskMetaFile.exists() && diskMetaFile.getParent().equals(memFile.getParent()) ? diskGS : 0L;
                    LOG.warn((Object)("Updating generation stamp for block " + blockId + " from " + memBlockInfo.getGenerationStamp() + " to " + gs));
                    memBlockInfo.setGenerationStamp(gs);
                }
            }
            if (memBlockInfo.getNumBytes() != memFile.length()) {
                corruptBlock = new Block(memBlockInfo);
                LOG.warn((Object)("Updating size of block " + blockId + " from " + memBlockInfo.getNumBytes() + " to " + memFile.length()));
                memBlockInfo.setNumBytes(memFile.length());
            }
        }
        if (corruptBlock != null) {
            LOG.warn((Object)("Reporting the block " + corruptBlock + " as corrupt due to length mismatch"));
            try {
                this.datanode.reportBadBlocks(new ExtendedBlock(bpid, corruptBlock));
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed to repot bad block " + corruptBlock), (Throwable)e);
            }
        }
    }

    @Override
    @Deprecated
    public ReplicaInfo getReplica(String bpid, long blockId) {
        return this.volumeMap.get(bpid, blockId);
    }

    @Override
    public synchronized String getReplicaString(String bpid, long blockId) {
        ReplicaInfo r = this.volumeMap.get(bpid, blockId);
        return r == null ? "null" : ((Object)r).toString();
    }

    @Override
    public synchronized ReplicaRecoveryInfo initReplicaRecovery(BlockRecoveryCommand.RecoveringBlock rBlock) throws IOException {
        return FsDatasetImpl.initReplicaRecovery(rBlock.getBlock().getBlockPoolId(), this.volumeMap, rBlock.getBlock().getLocalBlock(), rBlock.getNewGenerationStamp(), this.datanode.getDnConf().getXceiverStopTimeout());
    }

    static ReplicaRecoveryInfo initReplicaRecovery(String bpid, ReplicaMap map, Block block, long recoveryId, long xceiverStopTimeout) throws IOException {
        ReplicaUnderRecovery rur;
        ReplicaInfo replica = map.get(bpid, block.getBlockId());
        LOG.info((Object)("initReplicaRecovery: " + block + ", recoveryId=" + recoveryId + ", replica=" + replica));
        if (replica == null) {
            return null;
        }
        if (replica instanceof ReplicaInPipeline) {
            ReplicaInPipeline rip = (ReplicaInPipeline)replica;
            rip.stopWriter(xceiverStopTimeout);
            if (rip.getBytesOnDisk() < rip.getVisibleLength()) {
                throw new IOException("THIS IS NOT SUPPOSED TO HAPPEN: getBytesOnDisk() < getVisibleLength(), rip=" + rip);
            }
            FsDatasetImpl.checkReplicaFiles(rip);
        }
        if (replica.getGenerationStamp() < block.getGenerationStamp()) {
            throw new IOException("replica.getGenerationStamp() < block.getGenerationStamp(), block=" + block + ", replica=" + replica);
        }
        if (replica.getGenerationStamp() >= recoveryId) {
            throw new IOException("THIS IS NOT SUPPOSED TO HAPPEN: replica.getGenerationStamp() >= recoveryId = " + recoveryId + ", block=" + block + ", replica=" + replica);
        }
        if (replica.getState() == HdfsServerConstants.ReplicaState.RUR) {
            rur = (ReplicaUnderRecovery)replica;
            if (rur.getRecoveryID() >= recoveryId) {
                throw new RecoveryInProgressException("rur.getRecoveryID() >= recoveryId = " + recoveryId + ", block=" + block + ", rur=" + rur);
            }
            long oldRecoveryID = rur.getRecoveryID();
            rur.setRecoveryID(recoveryId);
            LOG.info((Object)("initReplicaRecovery: update recovery id for " + block + " from " + oldRecoveryID + " to " + recoveryId));
        } else {
            rur = new ReplicaUnderRecovery(replica, recoveryId);
            map.add(bpid, rur);
            LOG.info((Object)("initReplicaRecovery: changing replica state for " + block + " from " + (Object)((Object)replica.getState()) + " to " + (Object)((Object)rur.getState())));
        }
        return rur.createInfo();
    }

    @Override
    public synchronized String updateReplicaUnderRecovery(ExtendedBlock oldBlock, long recoveryId, long newBlockId, long newlength) throws IOException {
        boolean copyTruncate;
        String bpid = oldBlock.getBlockPoolId();
        ReplicaInfo replica = this.volumeMap.get(bpid, oldBlock.getBlockId());
        LOG.info((Object)("updateReplica: " + oldBlock + ", recoveryId=" + recoveryId + ", length=" + newlength + ", replica=" + replica));
        if (replica == null) {
            throw new ReplicaNotFoundException(oldBlock);
        }
        if (replica.getState() != HdfsServerConstants.ReplicaState.RUR) {
            throw new IOException("replica.getState() != " + (Object)((Object)HdfsServerConstants.ReplicaState.RUR) + ", replica=" + replica);
        }
        if (replica.getBytesOnDisk() != oldBlock.getNumBytes()) {
            throw new IOException("THIS IS NOT SUPPOSED TO HAPPEN: replica.getBytesOnDisk() != block.getNumBytes(), block=" + oldBlock + ", replica=" + replica);
        }
        FsDatasetImpl.checkReplicaFiles(replica);
        FinalizedReplica finalized = this.updateReplicaUnderRecovery(oldBlock.getBlockPoolId(), (ReplicaUnderRecovery)replica, recoveryId, newBlockId, newlength);
        boolean bl = copyTruncate = newBlockId != oldBlock.getBlockId();
        if (!copyTruncate) {
            assert (finalized.getBlockId() == oldBlock.getBlockId() && finalized.getGenerationStamp() == recoveryId && finalized.getNumBytes() == newlength) : "Replica information mismatched: oldBlock=" + oldBlock + ", recoveryId=" + recoveryId + ", newlength=" + newlength + ", newBlockId=" + newBlockId + ", finalized=" + finalized;
        } else assert (finalized.getBlockId() == oldBlock.getBlockId() && finalized.getGenerationStamp() == oldBlock.getGenerationStamp() && finalized.getNumBytes() == oldBlock.getNumBytes()) : "Finalized and old information mismatched: oldBlock=" + oldBlock + ", genStamp=" + oldBlock.getGenerationStamp() + ", len=" + oldBlock.getNumBytes() + ", finalized=" + finalized;
        FsDatasetImpl.checkReplicaFiles(finalized);
        return this.getVolume(new ExtendedBlock(bpid, finalized)).getStorageID();
    }

    private FinalizedReplica updateReplicaUnderRecovery(String bpid, ReplicaUnderRecovery rur, long recoveryId, long newBlockId, long newlength) throws IOException {
        File metaFile;
        File blockFile;
        boolean copyOnTruncate;
        if (rur.getRecoveryID() != recoveryId) {
            throw new IOException("rur.getRecoveryID() != recoveryId = " + recoveryId + ", rur=" + rur);
        }
        boolean bl = copyOnTruncate = newBlockId > 0L && rur.getBlockId() != newBlockId;
        if (!copyOnTruncate) {
            this.bumpReplicaGS(rur, recoveryId);
            blockFile = rur.getBlockFile();
            metaFile = rur.getMetaFile();
        } else {
            File[] copiedReplicaFiles = this.copyReplicaWithNewBlockIdAndGS(rur, bpid, newBlockId, recoveryId);
            blockFile = copiedReplicaFiles[1];
            metaFile = copiedReplicaFiles[0];
        }
        if (rur.getNumBytes() < newlength) {
            throw new IOException("rur.getNumBytes() < newlength = " + newlength + ", rur=" + rur);
        }
        if (rur.getNumBytes() > newlength) {
            rur.unlinkBlock(1);
            FsDatasetImpl.truncateBlock(blockFile, metaFile, rur.getNumBytes(), newlength);
            if (!copyOnTruncate) {
                rur.setNumBytes(newlength);
            } else {
                FsVolumeSpi volume = rur.getVolume();
                String blockPath = blockFile.getAbsolutePath();
                String volumePath = volume.getBasePath();
                assert (blockPath.startsWith(volumePath)) : "New block file: " + blockPath + " must be on " + "same volume as recovery replica: " + volumePath;
                ReplicaBeingWritten newReplicaInfo = new ReplicaBeingWritten(newBlockId, recoveryId, volume, blockFile.getParentFile(), newlength);
                newReplicaInfo.setNumBytes(newlength);
                this.volumeMap.add(bpid, newReplicaInfo);
                this.finalizeReplica(bpid, newReplicaInfo);
            }
        }
        return this.finalizeReplica(bpid, rur);
    }

    private File[] copyReplicaWithNewBlockIdAndGS(ReplicaUnderRecovery replicaInfo, String bpid, long newBlkId, long newGS) throws IOException {
        String blockFileName = "blk_" + newBlkId;
        FsVolumeImpl v = (FsVolumeImpl)replicaInfo.getVolume();
        File tmpDir = v.getBlockPoolSlice(bpid).getTmpDir();
        File destDir = DatanodeUtil.idToBlockDir(tmpDir, newBlkId);
        File dstBlockFile = new File(destDir, blockFileName);
        File dstMetaFile = FsDatasetUtil.getMetaFile(dstBlockFile, newGS);
        return FsDatasetImpl.copyBlockFiles(replicaInfo.getMetaFile(), replicaInfo.getBlockFile(), dstMetaFile, dstBlockFile, true);
    }

    @Override
    public synchronized long getReplicaVisibleLength(ExtendedBlock block) throws IOException {
        ReplicaInfo replica = this.getReplicaInfo(block.getBlockPoolId(), block.getBlockId());
        if (replica.getGenerationStamp() < block.getGenerationStamp()) {
            throw new IOException("replica.getGenerationStamp() < block.getGenerationStamp(), block=" + block + ", replica=" + replica);
        }
        return replica.getVisibleLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBlockPool(String bpid, Configuration conf) throws IOException {
        LOG.info((Object)("Adding block pool " + bpid));
        FsDatasetImpl fsDatasetImpl = this;
        synchronized (fsDatasetImpl) {
            this.volumes.addBlockPool(bpid, conf);
            this.volumeMap.initBlockPool(bpid);
        }
        this.volumes.getAllVolumesMap(bpid, this.volumeMap, this.ramDiskReplicaTracker);
    }

    @Override
    public synchronized void shutdownBlockPool(String bpid) {
        LOG.info((Object)("Removing block pool " + bpid));
        this.volumeMap.cleanUpBlockPool(bpid);
        this.volumes.removeBlockPool(bpid);
    }

    private Collection<VolumeInfo> getVolumeInfo() {
        ArrayList<VolumeInfo> info = new ArrayList<VolumeInfo>();
        for (FsVolumeImpl volume : this.getVolumes()) {
            long used = 0L;
            long free = 0L;
            try (FsVolumeReference ref = volume.obtainReference();){
                used = volume.getDfsUsed();
                free = volume.getAvailable();
            }
            catch (ClosedChannelException e) {
                continue;
            }
            catch (IOException e) {
                LOG.warn((Object)e.getMessage());
                used = 0L;
                free = 0L;
            }
            info.add(new VolumeInfo(volume, used, free));
        }
        return info;
    }

    @Override
    public Map<String, Object> getVolumeInfoMap() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        Collection<VolumeInfo> volumes = this.getVolumeInfo();
        for (VolumeInfo v : volumes) {
            HashMap<String, Long> innerInfo = new HashMap<String, Long>();
            innerInfo.put("usedSpace", v.usedSpace);
            innerInfo.put("freeSpace", v.freeSpace);
            innerInfo.put("reservedSpace", v.reservedSpace);
            info.put(v.directory, innerInfo);
        }
        return info;
    }

    @Override
    public synchronized void deleteBlockPool(String bpid, boolean force) throws IOException {
        Throwable throwable;
        FsVolumeReference ref2;
        List<FsVolumeImpl> curVolumes = this.getVolumes();
        if (!force) {
            for (FsVolumeImpl volume : curVolumes) {
                try {
                    ref2 = volume.obtainReference();
                    throwable = null;
                    try {
                        if (volume.isBPDirEmpty(bpid)) continue;
                        LOG.warn((Object)(bpid + " has some block files, cannot delete unless forced"));
                        throw new IOException("Cannot delete block pool, it contains some block files");
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (ref2 == null) continue;
                        if (throwable != null) {
                            try {
                                ref2.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        ref2.close();
                    }
                }
                catch (ClosedChannelException ref2) {}
            }
        }
        for (FsVolumeImpl volume : curVolumes) {
            try {
                ref2 = volume.obtainReference();
                throwable = null;
                try {
                    volume.deleteBPDirectories(bpid, force);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ref2 == null) continue;
                    if (throwable != null) {
                        try {
                            ref2.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    ref2.close();
                }
            }
            catch (ClosedChannelException closedChannelException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockLocalPathInfo getBlockLocalPathInfo(ExtendedBlock block) throws IOException {
        FsDatasetImpl fsDatasetImpl = this;
        synchronized (fsDatasetImpl) {
            ReplicaInfo replica = this.volumeMap.get(block.getBlockPoolId(), block.getBlockId());
            if (replica == null) {
                throw new ReplicaNotFoundException(block);
            }
            if (replica.getGenerationStamp() < block.getGenerationStamp()) {
                throw new IOException("Replica generation stamp < block generation stamp, block=" + block + ", replica=" + replica);
            }
            if (replica.getGenerationStamp() > block.getGenerationStamp()) {
                block.setGenerationStamp(replica.getGenerationStamp());
            }
        }
        File datafile = this.getBlockFile(block);
        File metafile = FsDatasetUtil.getMetaFile(datafile, block.getGenerationStamp());
        BlockLocalPathInfo info = new BlockLocalPathInfo(block, datafile.getAbsolutePath(), metafile.getAbsolutePath());
        return info;
    }

    @Override
    public HdfsBlocksMetadata getHdfsBlocksMetadata(String poolId, long[] blockIds) throws IOException {
        int i;
        List<FsVolumeImpl> curVolumes = this.getVolumes();
        ArrayList<byte[]> blocksVolumeIds = new ArrayList<byte[]>(curVolumes.size());
        ArrayList<Integer> blocksVolumeIndexes = new ArrayList<Integer>(blockIds.length);
        for (i = 0; i < curVolumes.size(); ++i) {
            blocksVolumeIds.add(ByteBuffer.allocate(4).putInt(i).array());
        }
        for (i = 0; i < blockIds.length; ++i) {
            long blockId = blockIds[i];
            boolean isValid = false;
            ReplicaInfo info = this.volumeMap.get(poolId, blockId);
            int volumeIndex = 0;
            if (info != null) {
                FsVolumeSpi blockVolume = info.getVolume();
                for (FsVolumeImpl volume : curVolumes) {
                    if (blockVolume == volume) {
                        isValid = true;
                        break;
                    }
                    ++volumeIndex;
                }
            }
            if (!isValid) {
                volumeIndex = Integer.MAX_VALUE;
            }
            blocksVolumeIndexes.add(volumeIndex);
        }
        return new HdfsBlocksMetadata(poolId, blockIds, blocksVolumeIds, blocksVolumeIndexes);
    }

    @Override
    public void enableTrash(String bpid) {
        this.dataStorage.enableTrash(bpid);
    }

    @Override
    public void clearTrash(String bpid) {
        this.dataStorage.clearTrash(bpid);
    }

    @Override
    public boolean trashEnabled(String bpid) {
        return this.dataStorage.trashEnabled(bpid);
    }

    @Override
    public void setRollingUpgradeMarker(String bpid) throws IOException {
        this.dataStorage.setRollingUpgradeMarker(bpid);
    }

    @Override
    public void clearRollingUpgradeMarker(String bpid) throws IOException {
        this.dataStorage.clearRollingUpgradeMarker(bpid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleteLazyPersist(String bpId, long blockId, long creationTime, File[] savedFiles, FsVolumeImpl targetVolume) {
        FsDatasetImpl fsDatasetImpl = this;
        synchronized (fsDatasetImpl) {
            this.ramDiskReplicaTracker.recordEndLazyPersist(bpId, blockId, savedFiles);
            targetVolume.incDfsUsed(bpId, savedFiles[0].length() + savedFiles[1].length());
            this.datanode.getMetrics().incrRamDiskBlocksLazyPersisted();
            this.datanode.getMetrics().incrRamDiskBytesLazyPersisted(savedFiles[1].length());
            this.datanode.getMetrics().addRamDiskBlocksLazyPersistWindowMs(Time.monotonicNow() - creationTime);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("LazyWriter: Finish persisting RamDisk block:  block pool Id: " + bpId + " block id: " + blockId + " to block file " + savedFiles[1] + " and meta file " + savedFiles[0] + " on target volume " + targetVolume));
            }
        }
    }

    @Override
    public void onFailLazyPersist(String bpId, long blockId) {
        RamDiskReplicaTracker.RamDiskReplica block = null;
        block = this.ramDiskReplicaTracker.getReplica(bpId, blockId);
        if (block != null) {
            LOG.warn((Object)("Failed to save replica " + block + ". re-enqueueing it."));
            this.ramDiskReplicaTracker.reenqueueReplicaNotPersisted(block);
        }
    }

    @Override
    public void submitBackgroundSyncFileRangeRequest(ExtendedBlock block, FileDescriptor fd, long offset, long nbytes, int flags) {
        FsVolumeImpl fsVolumeImpl = this.getVolume(block);
        this.asyncDiskService.submitSyncFileRangeRequest(fsVolumeImpl, fd, offset, nbytes, flags);
    }

    private boolean ramDiskConfigured() {
        for (FsVolumeImpl v : this.getVolumes()) {
            if (!v.isTransientStorage()) continue;
            return true;
        }
        return false;
    }

    private void setupAsyncLazyPersistThreads() {
        for (FsVolumeImpl v : this.getVolumes()) {
            this.setupAsyncLazyPersistThread(v);
        }
    }

    private void setupAsyncLazyPersistThread(FsVolumeImpl v) {
        if (v.isTransientStorage()) {
            return;
        }
        boolean ramDiskConfigured = this.ramDiskConfigured();
        if (ramDiskConfigured && !this.asyncLazyPersistService.queryVolume(v.getCurrentDir())) {
            this.asyncLazyPersistService.addVolume(v.getCurrentDir());
        }
        if (!ramDiskConfigured && this.asyncLazyPersistService.queryVolume(v.getCurrentDir())) {
            this.asyncLazyPersistService.removeVolume(v.getCurrentDir());
        }
    }

    private void removeOldReplica(ReplicaInfo replicaInfo, ReplicaInfo newReplicaInfo, File blockFile, File metaFile, long blockFileUsed, long metaFileUsed, String bpid) {
        ExtendedBlock extendedBlock = new ExtendedBlock(bpid, newReplicaInfo);
        this.datanode.getShortCircuitRegistry().processBlockInvalidation(ExtendedBlockId.fromExtendedBlock(extendedBlock));
        this.datanode.notifyNamenodeReceivedBlock(extendedBlock, null, newReplicaInfo.getStorageUuid());
        if (blockFile.delete() || !blockFile.exists()) {
            ((FsVolumeImpl)replicaInfo.getVolume()).decDfsUsed(bpid, blockFileUsed);
            if (metaFile.delete() || !metaFile.exists()) {
                ((FsVolumeImpl)replicaInfo.getVolume()).decDfsUsed(bpid, metaFileUsed);
            }
        }
    }

    @Override
    public void setPinning(ExtendedBlock block) throws IOException {
        if (!this.blockPinningEnabled) {
            return;
        }
        File f = this.getBlockFile(block);
        Path p = new Path(f.getAbsolutePath());
        FsPermission oldPermission = this.localFS.getFileStatus(new Path(f.getAbsolutePath())).getPermission();
        FsPermission permission = new FsPermission(oldPermission.getUserAction(), oldPermission.getGroupAction(), oldPermission.getOtherAction(), true);
        this.localFS.setPermission(p, permission);
    }

    @Override
    public boolean getPinning(ExtendedBlock block) throws IOException {
        if (!this.blockPinningEnabled) {
            return false;
        }
        File f = this.getBlockFile(block);
        FileStatus fss = this.localFS.getFileStatus(new Path(f.getAbsolutePath()));
        return fss.getPermission().getStickyBit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDeletingBlock(String bpid, long blockId) {
        Map<String, Set<Long>> map = this.deletingBlock;
        synchronized (map) {
            Set<Long> s = this.deletingBlock.get(bpid);
            return s != null ? s.contains(blockId) : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeletedBlocks(String bpid, Set<Long> blockIds) {
        Map<String, Set<Long>> map = this.deletingBlock;
        synchronized (map) {
            Set<Long> s = this.deletingBlock.get(bpid);
            if (s != null) {
                for (Long id : blockIds) {
                    s.remove(id);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDeletingBlock(String bpid, Long blockId) {
        Map<String, Set<Long>> map = this.deletingBlock;
        synchronized (map) {
            Set<Long> s = this.deletingBlock.get(bpid);
            if (s == null) {
                s = new HashSet<Long>();
                this.deletingBlock.put(bpid, s);
            }
            s.add(blockId);
        }
    }

    synchronized void stopAllDataxceiverThreads(FsVolumeImpl volume) {
        for (String blockPoolId : this.volumeMap.getBlockPoolList()) {
            Collection<ReplicaInfo> replicas = this.volumeMap.replicas(blockPoolId);
            for (ReplicaInfo replicaInfo : replicas) {
                if (!(replicaInfo instanceof ReplicaInPipeline) || !replicaInfo.getVolume().equals(volume)) continue;
                ReplicaInPipeline replicaInPipeline = (ReplicaInPipeline)replicaInfo;
                replicaInPipeline.interruptThread();
            }
        }
    }

    static {
        if (Path.WINDOWS && !isNativeIOAvailable) {
            LOG.warn((Object)"Data node cannot fully support concurrent reading and writing without native code extensions on Windows.");
        }
    }

    class LazyWriter
    implements Runnable {
        private volatile boolean shouldRun = true;
        final int checkpointerInterval;
        final float lowWatermarkFreeSpacePercentage;
        final long lowWatermarkFreeSpaceBytes;

        public LazyWriter(Configuration conf) {
            this.checkpointerInterval = conf.getInt("dfs.datanode.lazywriter.interval.sec", 60);
            this.lowWatermarkFreeSpacePercentage = conf.getFloat("dfs.datanode.ram.disk.low.watermark.percent", 10.0f);
            this.lowWatermarkFreeSpaceBytes = conf.getLong("dfs.datanode.ram.disk.low.watermark.bytes", 0x8000000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean saveNextReplica() {
            RamDiskReplicaTracker.RamDiskReplica block = null;
            boolean succeeded = false;
            try {
                block = FsDatasetImpl.this.ramDiskReplicaTracker.dequeueNextReplicaToPersist();
                if (block != null) {
                    FsDatasetImpl fsDatasetImpl = FsDatasetImpl.this;
                    synchronized (fsDatasetImpl) {
                        ReplicaInfo replicaInfo = FsDatasetImpl.this.volumeMap.get(block.getBlockPoolId(), block.getBlockId());
                        if (replicaInfo != null && replicaInfo.getVolume().isTransientStorage()) {
                            FsVolumeReference targetReference = FsDatasetImpl.this.volumes.getNextVolume(StorageType.DEFAULT, replicaInfo.getNumBytes());
                            FsVolumeImpl targetVolume = (FsVolumeImpl)targetReference.getVolume();
                            FsDatasetImpl.this.ramDiskReplicaTracker.recordStartLazyPersist(block.getBlockPoolId(), block.getBlockId(), targetVolume);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("LazyWriter: Start persisting RamDisk block: block pool Id: " + block.getBlockPoolId() + " block id: " + block.getBlockId() + " on target volume " + targetVolume));
                            }
                            FsDatasetImpl.this.asyncLazyPersistService.submitLazyPersistTask(block.getBlockPoolId(), block.getBlockId(), replicaInfo.getGenerationStamp(), block.getCreationTime(), replicaInfo.getMetaFile(), replicaInfo.getBlockFile(), targetReference);
                        }
                    }
                }
                succeeded = true;
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Exception saving replica " + block), (Throwable)ioe);
            }
            finally {
                if (!succeeded && block != null) {
                    LOG.warn((Object)("Failed to save replica " + block + ". re-enqueueing it."));
                    FsDatasetImpl.this.onFailLazyPersist(block.getBlockPoolId(), block.getBlockId());
                }
            }
            return succeeded;
        }

        private boolean transientFreeSpaceBelowThreshold() throws IOException {
            long free = 0L;
            long capacity = 0L;
            float percentFree = 0.0f;
            for (FsVolumeImpl v : FsDatasetImpl.this.getVolumes()) {
                try {
                    FsVolumeReference ref = v.obtainReference();
                    Throwable throwable = null;
                    try {
                        if (!v.isTransientStorage()) continue;
                        capacity += v.getCapacity();
                        free += v.getAvailable();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ref == null) continue;
                        if (throwable != null) {
                            try {
                                ref.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        ref.close();
                    }
                }
                catch (ClosedChannelException closedChannelException) {}
            }
            if (capacity == 0L) {
                return false;
            }
            percentFree = (float)((double)free * 100.0 / (double)capacity);
            return percentFree < this.lowWatermarkFreeSpacePercentage || free < this.lowWatermarkFreeSpaceBytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void evictBlocks() throws IOException {
            RamDiskReplicaTracker.RamDiskReplica replicaState;
            int iterations = 0;
            while (iterations++ < 3 && this.transientFreeSpaceBelowThreshold() && (replicaState = FsDatasetImpl.this.ramDiskReplicaTracker.getNextCandidateForEviction()) != null) {
                FinalizedReplica newReplicaInfo;
                long metaFileUsed;
                long blockFileUsed;
                File metaFile;
                File blockFile;
                ReplicaInfo replicaInfo;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Evicting block " + replicaState));
                }
                String bpid = replicaState.getBlockPoolId();
                FsDatasetImpl fsDatasetImpl = FsDatasetImpl.this;
                synchronized (fsDatasetImpl) {
                    replicaInfo = FsDatasetImpl.this.getReplicaInfo(replicaState.getBlockPoolId(), replicaState.getBlockId());
                    Preconditions.checkState((boolean)replicaInfo.getVolume().isTransientStorage());
                    blockFile = replicaInfo.getBlockFile();
                    metaFile = replicaInfo.getMetaFile();
                    blockFileUsed = blockFile.length();
                    metaFileUsed = metaFile.length();
                    FsDatasetImpl.this.ramDiskReplicaTracker.discardReplica(replicaState.getBlockPoolId(), replicaState.getBlockId(), false);
                    BlockPoolSlice bpSlice = replicaState.getLazyPersistVolume().getBlockPoolSlice(bpid);
                    File newBlockFile = bpSlice.activateSavedReplica(replicaInfo, replicaState.getSavedMetaFile(), replicaState.getSavedBlockFile());
                    newReplicaInfo = new FinalizedReplica(replicaInfo.getBlockId(), replicaInfo.getBytesOnDisk(), replicaInfo.getGenerationStamp(), replicaState.getLazyPersistVolume(), newBlockFile.getParentFile());
                    FsDatasetImpl.this.volumeMap.add(bpid, newReplicaInfo);
                    FsDatasetImpl.this.datanode.getMetrics().incrRamDiskBlocksEvicted();
                    FsDatasetImpl.this.datanode.getMetrics().addRamDiskBlocksEvictionWindowMs(Time.monotonicNow() - replicaState.getCreationTime());
                    if (replicaState.getNumReads() == 0L) {
                        FsDatasetImpl.this.datanode.getMetrics().incrRamDiskBlocksEvictedWithoutRead();
                    }
                }
                FsDatasetImpl.this.removeOldReplica(replicaInfo, newReplicaInfo, blockFile, metaFile, blockFileUsed, metaFileUsed, bpid);
            }
        }

        @Override
        public void run() {
            int numSuccessiveFailures = 0;
            while (FsDatasetImpl.this.fsRunning && this.shouldRun) {
                try {
                    numSuccessiveFailures = this.saveNextReplica() ? 0 : numSuccessiveFailures + 1;
                    this.evictBlocks();
                    if (numSuccessiveFailures < FsDatasetImpl.this.ramDiskReplicaTracker.numReplicasNotPersisted()) continue;
                    Thread.sleep(this.checkpointerInterval * 1000);
                    numSuccessiveFailures = 0;
                }
                catch (InterruptedException e) {
                    LOG.info((Object)"LazyWriter was interrupted, exiting");
                    break;
                }
                catch (Exception e) {
                    LOG.warn((Object)"Ignoring exception in LazyWriter:", (Throwable)e);
                }
            }
        }

        public void stop() {
            this.shouldRun = false;
        }
    }

    private static class VolumeInfo {
        final String directory;
        final long usedSpace;
        final long freeSpace;
        final long reservedSpace;

        VolumeInfo(FsVolumeImpl v, long usedSpace, long freeSpace) {
            this.directory = v.toString();
            this.usedSpace = usedSpace;
            this.freeSpace = freeSpace;
            this.reservedSpace = v.getReserved();
        }
    }
}

