/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.BuilderUtils;
import org.apache.hadoop.yarn.util.ConverterUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MRApps
extends Apps {
    private static final String STAGING_CONSTANT = ".staging";

    public static String toString(JobId jid) {
        return jid.toString();
    }

    public static JobId toJobID(String jid) {
        return TypeConverter.toYarn(JobID.forName((String)jid));
    }

    public static String toString(TaskId tid) {
        return tid.toString();
    }

    public static TaskId toTaskID(String tid) {
        return TypeConverter.toYarn(TaskID.forName((String)tid));
    }

    public static String toString(TaskAttemptId taid) {
        return taid.toString();
    }

    public static TaskAttemptId toTaskAttemptID(String taid) {
        return TypeConverter.toYarn(TaskAttemptID.forName((String)taid));
    }

    public static String taskSymbol(TaskType type) {
        switch (type) {
            case MAP: {
                return "m";
            }
            case REDUCE: {
                return "r";
            }
        }
        throw new YarnException("Unknown task type: " + type.toString());
    }

    public static TaskType taskType(String symbol) {
        if (symbol.equals("m")) {
            return TaskType.MAP;
        }
        if (symbol.equals("r")) {
            return TaskType.REDUCE;
        }
        throw new YarnException("Unknown task symbol: " + symbol);
    }

    public static TaskAttemptStateUI taskAttemptState(String attemptStateStr) {
        return TaskAttemptStateUI.valueOf(attemptStateStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setMRFrameworkClasspath(Map<String, String> environment, Configuration conf) throws IOException {
        InputStream classpathFileStream = null;
        BufferedReader reader = null;
        try {
            String cp;
            ClassLoader thisClassLoader = Thread.currentThread().getContextClassLoader();
            String mrAppGeneratedClasspathFile = "mrapp-generated-classpath";
            classpathFileStream = thisClassLoader.getResourceAsStream(mrAppGeneratedClasspathFile);
            URL classpathResource = thisClassLoader.getResource(mrAppGeneratedClasspathFile);
            if (classpathResource != null) {
                String classpathElement = classpathResource.getFile();
                classpathElement = classpathElement.contains("!") ? classpathElement.substring(0, classpathElement.indexOf("!")) : new File(classpathElement).getParent();
                Apps.addToEnvironment(environment, (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)classpathElement);
            }
            if (classpathFileStream != null && (cp = (reader = new BufferedReader(new InputStreamReader(classpathFileStream))).readLine()) != null) {
                Apps.addToEnvironment(environment, (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)cp.trim());
            }
            for (String c : conf.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH)) {
                Apps.addToEnvironment(environment, (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)c.trim());
            }
            for (String c : conf.getStrings("mapreduce.application.classpath", MRJobConfig.DEFAULT_MAPREDUCE_APPLICATION_CLASSPATH)) {
                Apps.addToEnvironment(environment, (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)c.trim());
            }
        }
        finally {
            if (classpathFileStream != null) {
                classpathFileStream.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static void setClasspath(Map<String, String> environment, Configuration conf) throws IOException {
        boolean userClassesTakesPrecedence = conf.getBoolean("mapreduce.job.user.classpath.first", false);
        Apps.addToEnvironment(environment, (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)ApplicationConstants.Environment.PWD.$());
        if (!userClassesTakesPrecedence) {
            MRApps.setMRFrameworkClasspath(environment, conf);
        }
        Apps.addToEnvironment(environment, (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)"job.jar/job.jar");
        Apps.addToEnvironment(environment, (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)"job.jar/classes/");
        Apps.addToEnvironment(environment, (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)"job.jar/lib/*");
        Apps.addToEnvironment(environment, (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)(ApplicationConstants.Environment.PWD.$() + "/" + "*"));
        MRApps.addToClasspathIfNotJar(DistributedCache.getFileClassPaths((Configuration)conf), DistributedCache.getCacheFiles((Configuration)conf), conf, environment);
        MRApps.addToClasspathIfNotJar(DistributedCache.getArchiveClassPaths((Configuration)conf), DistributedCache.getCacheArchives((Configuration)conf), conf, environment);
        if (userClassesTakesPrecedence) {
            MRApps.setMRFrameworkClasspath(environment, conf);
        }
    }

    private static void addToClasspathIfNotJar(Path[] paths, URI[] withLinks, Configuration conf, Map<String, String> environment) throws IOException {
        if (paths != null) {
            HashMap<Path, String> linkLookup = new HashMap<Path, String>();
            if (withLinks != null) {
                for (URI uRI : withLinks) {
                    String name;
                    Path p = new Path(uRI);
                    FileSystem remoteFS = p.getFileSystem(conf);
                    p = remoteFS.resolvePath(p.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory()));
                    String string = name = null == uRI.getFragment() ? p.getName() : uRI.getFragment();
                    if (name.toLowerCase().endsWith(".jar")) continue;
                    linkLookup.put(p, name);
                }
            }
            for (URI uRI : paths) {
                FileSystem remoteFS = uRI.getFileSystem(conf);
                Path path = remoteFS.resolvePath(uRI.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory()));
                String name = (String)linkLookup.get(path);
                if (name == null) {
                    name = path.getName();
                }
                if (name.toLowerCase().endsWith(".jar")) continue;
                Apps.addToEnvironment(environment, (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)(ApplicationConstants.Environment.PWD.$() + "/" + name));
            }
        }
    }

    public static Path getStagingAreaDir(Configuration conf, String user) {
        return new Path(conf.get("yarn.app.mapreduce.am.staging-dir", "/tmp/hadoop-yarn/staging") + "/" + user + "/" + STAGING_CONSTANT);
    }

    public static String getJobFile(Configuration conf, String user, JobID jobId) {
        Path jobFile = new Path(MRApps.getStagingAreaDir(conf, user), jobId.toString() + "/" + "job.xml");
        return jobFile.toString();
    }

    public static Path getEndJobCommitSuccessFile(Configuration conf, String user, JobId jobId) {
        Path endCommitFile = new Path(MRApps.getStagingAreaDir(conf, user), jobId.toString() + "/" + "COMMIT_SUCCESS");
        return endCommitFile;
    }

    public static Path getEndJobCommitFailureFile(Configuration conf, String user, JobId jobId) {
        Path endCommitFile = new Path(MRApps.getStagingAreaDir(conf, user), jobId.toString() + "/" + "COMMIT_FAIL");
        return endCommitFile;
    }

    public static Path getStartJobCommitFile(Configuration conf, String user, JobId jobId) {
        Path startCommitFile = new Path(MRApps.getStagingAreaDir(conf, user), jobId.toString() + "/" + "COMMIT_STARTED");
        return startCommitFile;
    }

    private static long[] parseTimeStamps(String[] strs) {
        if (null == strs) {
            return null;
        }
        long[] result = new long[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            result[i] = Long.parseLong(strs[i]);
        }
        return result;
    }

    public static void setupDistributedCache(Configuration conf, Map<String, LocalResource> localResources) throws IOException {
        MRApps.parseDistributedCacheArtifacts(conf, localResources, LocalResourceType.ARCHIVE, DistributedCache.getCacheArchives((Configuration)conf), MRApps.parseTimeStamps(DistributedCache.getArchiveTimestamps((Configuration)conf)), MRApps.getFileSizes(conf, "mapreduce.job.cache.archives.filesizes"), DistributedCache.getArchiveVisibilities((Configuration)conf));
        MRApps.parseDistributedCacheArtifacts(conf, localResources, LocalResourceType.FILE, DistributedCache.getCacheFiles((Configuration)conf), MRApps.parseTimeStamps(DistributedCache.getFileTimestamps((Configuration)conf)), MRApps.getFileSizes(conf, "mapreduce.job.cache.files.filesizes"), DistributedCache.getFileVisibilities((Configuration)conf));
    }

    private static String getResourceDescription(LocalResourceType type) {
        if (type == LocalResourceType.ARCHIVE || type == LocalResourceType.PATTERN) {
            return "cache archive (mapreduce.job.cache.archives) ";
        }
        return "cache file (mapreduce.job.cache.files) ";
    }

    private static void parseDistributedCacheArtifacts(Configuration conf, Map<String, LocalResource> localResources, LocalResourceType type, URI[] uris, long[] timestamps, long[] sizes, boolean[] visibilities) throws IOException {
        if (uris != null) {
            if (uris.length != timestamps.length || uris.length != sizes.length || uris.length != visibilities.length) {
                throw new IllegalArgumentException("Invalid specification for distributed-cache artifacts of type " + type + " :" + " #uris=" + uris.length + " #timestamps=" + timestamps.length + " #visibilities=" + visibilities.length);
            }
            for (int i = 0; i < uris.length; ++i) {
                URI u = uris[i];
                Path p = new Path(u);
                FileSystem remoteFS = p.getFileSystem(conf);
                p = remoteFS.resolvePath(p.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory()));
                Path name = new Path(null == u.getFragment() ? p.getName() : u.getFragment());
                if (name.isAbsolute()) {
                    throw new IllegalArgumentException("Resource name must be relative");
                }
                String linkName = name.toUri().getPath();
                LocalResource orig = localResources.get(linkName);
                if (orig != null && !orig.getResource().equals(ConverterUtils.getYarnUrlFromURI((URI)p.toUri()))) {
                    throw new InvalidJobConfException(MRApps.getResourceDescription(orig.getType()) + orig.getResource() + " conflicts with " + MRApps.getResourceDescription(type) + u);
                }
                localResources.put(linkName, BuilderUtils.newLocalResource((URI)p.toUri(), (LocalResourceType)type, (LocalResourceVisibility)(visibilities[i] ? LocalResourceVisibility.PUBLIC : LocalResourceVisibility.PRIVATE), (long)sizes[i], (long)timestamps[i]));
            }
        }
    }

    private static long[] getFileSizes(Configuration conf, String key) {
        String[] strs = conf.getStrings(key);
        if (strs == null) {
            return null;
        }
        long[] result = new long[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            result[i] = Long.parseLong(strs[i]);
        }
        return result;
    }

    public static void addLog4jSystemProperties(String logLevel, long logSize, List<String> vargs) {
        vargs.add("-Dlog4j.configuration=container-log4j.properties");
        vargs.add("-Dyarn.app.mapreduce.container.log.dir=<LOG_DIR>");
        vargs.add("-Dyarn.app.mapreduce.container.log.filesize=" + logSize);
        vargs.add("-Dhadoop.root.logger=" + logLevel + ",CLA");
    }

    public static enum TaskAttemptStateUI {
        NEW(new TaskAttemptState[]{TaskAttemptState.NEW, TaskAttemptState.STARTING}),
        RUNNING(new TaskAttemptState[]{TaskAttemptState.RUNNING, TaskAttemptState.COMMIT_PENDING}),
        SUCCESSFUL(new TaskAttemptState[]{TaskAttemptState.SUCCEEDED}),
        FAILED(new TaskAttemptState[]{TaskAttemptState.FAILED}),
        KILLED(new TaskAttemptState[]{TaskAttemptState.KILLED});

        private final List<TaskAttemptState> correspondingStates;

        private TaskAttemptStateUI(TaskAttemptState[] correspondingStates) {
            this.correspondingStates = Arrays.asList(correspondingStates);
        }

        public boolean correspondsTo(TaskAttemptState state) {
            return this.correspondingStates.contains((Object)state);
        }
    }
}

