/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.protocolrecords;

import java.util.List;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.util.Records;

public abstract class RegisterNodeManagerRequest {
    public static RegisterNodeManagerRequest newInstance(NodeId nodeId, int httpPort, Resource resource, String nodeManagerVersionId, List<NMContainerStatus> containerStatuses, List<ApplicationId> runningApplications) {
        return RegisterNodeManagerRequest.newInstance(nodeId, httpPort, resource, nodeManagerVersionId, containerStatuses, runningApplications, null, null);
    }

    public static RegisterNodeManagerRequest newInstance(NodeId nodeId, int httpPort, Resource resource, String nodeManagerVersionId, List<NMContainerStatus> containerStatuses, List<ApplicationId> runningApplications, Set<String> nodeLabels) {
        return RegisterNodeManagerRequest.newInstance(nodeId, httpPort, resource, nodeManagerVersionId, containerStatuses, runningApplications, nodeLabels, null);
    }

    public static RegisterNodeManagerRequest newInstance(NodeId nodeId, int httpPort, Resource resource, String nodeManagerVersionId, List<NMContainerStatus> containerStatuses, List<ApplicationId> runningApplications, Set<String> nodeLabels, Set<String> emrLabels) {
        RegisterNodeManagerRequest request = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        request.setHttpPort(httpPort);
        request.setResource(resource);
        request.setNodeId(nodeId);
        request.setNMVersion(nodeManagerVersionId);
        request.setContainerStatuses(containerStatuses);
        request.setRunningApplications(runningApplications);
        request.setNodeLabels(nodeLabels);
        request.setEmrLabels(emrLabels);
        return request;
    }

    public abstract NodeId getNodeId();

    public abstract int getHttpPort();

    public abstract Resource getResource();

    public abstract String getNMVersion();

    public abstract List<NMContainerStatus> getNMContainerStatuses();

    public abstract Set<String> getNodeLabels();

    public abstract Set<String> getEmrLabels();

    public abstract void setNodeLabels(Set<String> var1);

    public abstract List<ApplicationId> getRunningApplications();

    public abstract void setNodeId(NodeId var1);

    public abstract void setHttpPort(int var1);

    public abstract void setResource(Resource var1);

    public abstract void setNMVersion(String var1);

    public abstract void setContainerStatuses(List<NMContainerStatus> var1);

    public abstract void setEmrLabels(Set<String> var1);

    public abstract void setRunningApplications(List<ApplicationId> var1);
}

