/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.datatype;

import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CNN;
import ca.uhn.hl7v2.model.v25.datatype.HD;
import ca.uhn.hl7v2.model.v25.datatype.IS;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.log.HapiLogFactory;

public class NDL
extends AbstractType
implements Composite {
    private Type[] data = new Type[11];

    public NDL(Message message) {
        super(message);
        this.data[0] = new CNN(message);
        this.data[1] = new TS(message);
        this.data[2] = new TS(message);
        this.data[3] = new IS(message, 302);
        this.data[4] = new IS(message, 303);
        this.data[5] = new IS(message, 304);
        this.data[6] = new HD(message);
        this.data[7] = new IS(message, 306);
        this.data[8] = new IS(message, 305);
        this.data[9] = new IS(message, 307);
        this.data[10] = new IS(message, 308);
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist in 11 element NDL composite");
        }
    }

    public CNN getNameOfPerson() {
        CNN ret = null;
        try {
            ret = (CNN)this.getComponent(0);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CNN getNdl1_NameOfPerson() {
        CNN ret = null;
        try {
            ret = (CNN)this.getComponent(0);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TS getStartDateTime() {
        TS ret = null;
        try {
            ret = (TS)this.getComponent(1);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TS getNdl2_StartDateTime() {
        TS ret = null;
        try {
            ret = (TS)this.getComponent(1);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TS getEndDateTime() {
        TS ret = null;
        try {
            ret = (TS)this.getComponent(2);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TS getNdl3_EndDateTime() {
        TS ret = null;
        try {
            ret = (TS)this.getComponent(2);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getPointOfCare() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(3);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getNdl4_PointOfCare() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(3);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getRoom() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(4);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getNdl5_Room() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(4);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getBed() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(5);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getNdl6_Bed() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(5);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public HD getFacility() {
        HD ret = null;
        try {
            ret = (HD)this.getComponent(6);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public HD getNdl7_Facility() {
        HD ret = null;
        try {
            ret = (HD)this.getComponent(6);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getLocationStatus() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(7);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getNdl8_LocationStatus() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(7);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getPatientLocationType() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(8);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getNdl9_PatientLocationType() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(8);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getBuilding() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(9);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getNdl10_Building() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(9);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getFloor() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(10);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getNdl11_Floor() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(10);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

