/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.segment.OBX;
import ca.uhn.hl7v2.model.v25.segment.SAC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class OMG_O19_CONTAINER
extends AbstractGroup {
    public OMG_O19_CONTAINER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        try {
            this.add(SAC.class, true, false);
            this.add(OBX.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating OMG_O19_CONTAINER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SAC getSAC() {
        SAC ret = null;
        try {
            ret = (SAC)this.get("SAC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OBX getOBX() {
        OBX ret = null;
        try {
            ret = (OBX)this.get("OBX");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OBX getOBX(int rep) throws HL7Exception {
        return (OBX)this.get("OBX", rep);
    }

    public int getOBXReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBX").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }
}

