/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.segment.PTH;
import ca.uhn.hl7v2.model.v25.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PGL_PC6_PATHWAY
extends AbstractGroup {
    public PGL_PC6_PATHWAY(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        try {
            this.add(PTH.class, true, false);
            this.add(VAR.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating PGL_PC6_PATHWAY - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public PTH getPTH() {
        PTH ret = null;
        try {
            ret = (PTH)this.get("PTH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VAR getVAR() {
        VAR ret = null;
        try {
            ret = (VAR)this.get("VAR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VAR getVAR(int rep) throws HL7Exception {
        return (VAR)this.get("VAR", rep);
    }

    public int getVARReps() {
        int reps = -1;
        try {
            reps = this.getAll("VAR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }
}

