/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.PTR_PCF_GOAL_OBSERVATION;
import ca.uhn.hl7v2.model.v25.group.PTR_PCF_GOAL_ROLE;
import ca.uhn.hl7v2.model.v25.segment.GOL;
import ca.uhn.hl7v2.model.v25.segment.NTE;
import ca.uhn.hl7v2.model.v25.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PTR_PCF_GOAL
extends AbstractGroup {
    public PTR_PCF_GOAL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        try {
            this.add(GOL.class, true, false);
            this.add(NTE.class, false, true);
            this.add(VAR.class, false, true);
            this.add(PTR_PCF_GOAL_ROLE.class, false, true);
            this.add(PTR_PCF_GOAL_OBSERVATION.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating PTR_PCF_GOAL - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public GOL getGOL() {
        GOL ret = null;
        try {
            ret = (GOL)this.get("GOL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) throws HL7Exception {
        return (NTE)this.get("NTE", rep);
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public VAR getVAR() {
        VAR ret = null;
        try {
            ret = (VAR)this.get("VAR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VAR getVAR(int rep) throws HL7Exception {
        return (VAR)this.get("VAR", rep);
    }

    public int getVARReps() {
        int reps = -1;
        try {
            reps = this.getAll("VAR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public PTR_PCF_GOAL_ROLE getGOAL_ROLE() {
        PTR_PCF_GOAL_ROLE ret = null;
        try {
            ret = (PTR_PCF_GOAL_ROLE)this.get("GOAL_ROLE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PTR_PCF_GOAL_ROLE getGOAL_ROLE(int rep) throws HL7Exception {
        return (PTR_PCF_GOAL_ROLE)this.get("GOAL_ROLE", rep);
    }

    public int getGOAL_ROLEReps() {
        int reps = -1;
        try {
            reps = this.getAll("GOAL_ROLE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertGOAL_ROLE(PTR_PCF_GOAL_ROLE structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public PTR_PCF_GOAL_ROLE insertGOAL_ROLE(int rep) throws HL7Exception {
        return (PTR_PCF_GOAL_ROLE)super.insertRepetition("GOAL_ROLE", rep);
    }

    public PTR_PCF_GOAL_ROLE removeGOAL_ROLE(int rep) throws HL7Exception {
        return (PTR_PCF_GOAL_ROLE)super.removeRepetition("GOAL_ROLE", rep);
    }

    public PTR_PCF_GOAL_OBSERVATION getGOAL_OBSERVATION() {
        PTR_PCF_GOAL_OBSERVATION ret = null;
        try {
            ret = (PTR_PCF_GOAL_OBSERVATION)this.get("GOAL_OBSERVATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PTR_PCF_GOAL_OBSERVATION getGOAL_OBSERVATION(int rep) throws HL7Exception {
        return (PTR_PCF_GOAL_OBSERVATION)this.get("GOAL_OBSERVATION", rep);
    }

    public int getGOAL_OBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("GOAL_OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertGOAL_OBSERVATION(PTR_PCF_GOAL_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public PTR_PCF_GOAL_OBSERVATION insertGOAL_OBSERVATION(int rep) throws HL7Exception {
        return (PTR_PCF_GOAL_OBSERVATION)super.insertRepetition("GOAL_OBSERVATION", rep);
    }

    public PTR_PCF_GOAL_OBSERVATION removeGOAL_OBSERVATION(int rep) throws HL7Exception {
        return (PTR_PCF_GOAL_OBSERVATION)super.removeRepetition("GOAL_OBSERVATION", rep);
    }
}

