/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.REF_I12_RESULTS_NOTES;
import ca.uhn.hl7v2.model.v25.segment.NTE;
import ca.uhn.hl7v2.model.v25.segment.OBR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class REF_I12_OBSERVATION
extends AbstractGroup {
    public REF_I12_OBSERVATION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        try {
            this.add(OBR.class, true, false);
            this.add(NTE.class, false, true);
            this.add(REF_I12_RESULTS_NOTES.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating REF_I12_OBSERVATION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public OBR getOBR() {
        OBR ret = null;
        try {
            ret = (OBR)this.get("OBR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) throws HL7Exception {
        return (NTE)this.get("NTE", rep);
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public REF_I12_RESULTS_NOTES getRESULTS_NOTES() {
        REF_I12_RESULTS_NOTES ret = null;
        try {
            ret = (REF_I12_RESULTS_NOTES)this.get("RESULTS_NOTES");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public REF_I12_RESULTS_NOTES getRESULTS_NOTES(int rep) throws HL7Exception {
        return (REF_I12_RESULTS_NOTES)this.get("RESULTS_NOTES", rep);
    }

    public int getRESULTS_NOTESReps() {
        int reps = -1;
        try {
            reps = this.getAll("RESULTS_NOTES").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertRESULTS_NOTES(REF_I12_RESULTS_NOTES structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public REF_I12_RESULTS_NOTES insertRESULTS_NOTES(int rep) throws HL7Exception {
        return (REF_I12_RESULTS_NOTES)super.insertRepetition("RESULTS_NOTES", rep);
    }

    public REF_I12_RESULTS_NOTES removeRESULTS_NOTES(int rep) throws HL7Exception {
        return (REF_I12_RESULTS_NOTES)super.removeRepetition("RESULTS_NOTES", rep);
    }
}

