/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.MFN_M10_MF_TEST_BATTERIES;
import ca.uhn.hl7v2.model.v25.segment.MFI;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.model.v25.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class MFN_M10
extends AbstractMessage {
    public MFN_M10(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    public MFN_M10() {
        super((ModelClassFactory)new DefaultModelClassFactory());
        this.init((ModelClassFactory)new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(MFI.class, true, false);
            this.add(MFN_M10_MF_TEST_BATTERIES.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating MFN_M10 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT() {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT(int rep) throws HL7Exception {
        return (SFT)this.get("SFT", rep);
    }

    public int getSFTReps() {
        int reps = -1;
        try {
            reps = this.getAll("SFT").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public MFI getMFI() {
        MFI ret = null;
        try {
            ret = (MFI)this.get("MFI");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M10_MF_TEST_BATTERIES getMF_TEST_BATTERIES() {
        MFN_M10_MF_TEST_BATTERIES ret = null;
        try {
            ret = (MFN_M10_MF_TEST_BATTERIES)this.get("MF_TEST_BATTERIES");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M10_MF_TEST_BATTERIES getMF_TEST_BATTERIES(int rep) throws HL7Exception {
        return (MFN_M10_MF_TEST_BATTERIES)this.get("MF_TEST_BATTERIES", rep);
    }

    public int getMF_TEST_BATTERIESReps() {
        int reps = -1;
        try {
            reps = this.getAll("MF_TEST_BATTERIES").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertMF_TEST_BATTERIES(MFN_M10_MF_TEST_BATTERIES structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public MFN_M10_MF_TEST_BATTERIES insertMF_TEST_BATTERIES(int rep) throws HL7Exception {
        return (MFN_M10_MF_TEST_BATTERIES)super.insertRepetition("MF_TEST_BATTERIES", rep);
    }

    public MFN_M10_MF_TEST_BATTERIES removeMF_TEST_BATTERIES(int rep) throws HL7Exception {
        return (MFN_M10_MF_TEST_BATTERIES)super.removeRepetition("MF_TEST_BATTERIES", rep);
    }
}

