/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.DR;
import ca.uhn.hl7v2.model.v25.datatype.SI;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.model.v25.datatype.XAD;
import ca.uhn.hl7v2.model.v25.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class AFF
extends AbstractSegment {
    public AFF(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        Message message = this.getMessage();
        try {
            this.add(SI.class, true, 1, 60, new Object[]{message}, "Set ID _ AFF");
            this.add(XON.class, true, 1, 250, new Object[]{message}, "Professional Organization");
            this.add(XAD.class, false, 1, 250, new Object[]{message}, "Professional Organization Address");
            this.add(DR.class, false, 0, 52, new Object[]{message}, "Professional Organization Affiliation Date Range");
            this.add(ST.class, false, 1, 60, new Object[]{message}, "Professional Affiliation Additional Information");
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)("Can't instantiate " + ((Object)((Object)this)).getClass().getName()), (Throwable)he);
        }
    }

    public SI getSetIDAFF() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SI getAff1_SetIDAFF() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XON getProfessionalOrganization() {
        XON ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (XON)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XON getAff2_ProfessionalOrganization() {
        XON ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (XON)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD getProfessionalOrganizationAddress() {
        XAD ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD getAff3_ProfessionalOrganizationAddress() {
        XAD ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DR getProfessionalOrganizationAffiliationDateRange(int rep) throws HL7Exception {
        DR ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (DR)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public DR[] getProfessionalOrganizationAffiliationDateRange() {
        DR[] ret = null;
        try {
            Type[] t = this.getField(4);
            ret = new DR[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (DR)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getProfessionalOrganizationAffiliationDateRangeReps() {
        try {
            return this.getField(4).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public DR insertProfessionalOrganizationAffiliationDateRange(int index) throws HL7Exception {
        return (DR)super.insertRepetition(4, index);
    }

    public DR removeProfessionalOrganizationAffiliationDateRange(int index) throws HL7Exception {
        return (DR)super.removeRepetition(4, index);
    }

    public DR getAff4_ProfessionalOrganizationAffiliationDateRange(int rep) throws HL7Exception {
        DR ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (DR)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public DR[] getAff4_ProfessionalOrganizationAffiliationDateRange() {
        DR[] ret = null;
        try {
            Type[] t = this.getField(4);
            ret = new DR[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (DR)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getAff4_ProfessionalOrganizationAffiliationDateRangeReps() {
        try {
            return this.getField(4).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public DR insertAff4_ProfessionalOrganizationAffiliationDateRange(int index) throws HL7Exception {
        return (DR)super.insertRepetition(4, index);
    }

    public DR removeAff4_ProfessionalOrganizationAffiliationDateRange(int index) throws HL7Exception {
        return (DR)super.removeRepetition(4, index);
    }

    public ST getProfessionalAffiliationAdditionalInformation() {
        ST ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getAff5_ProfessionalAffiliationAdditionalInformation() {
        ST ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new XON(this.getMessage());
            }
            case 2: {
                return new XAD(this.getMessage());
            }
            case 3: {
                return new DR(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

