/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.NM;
import ca.uhn.hl7v2.model.v25.datatype.SCV;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class APR
extends AbstractSegment {
    public APR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        Message message = this.getMessage();
        try {
            this.add(SCV.class, false, 0, 80, new Object[]{message}, "Time Selection Criteria");
            this.add(SCV.class, false, 0, 80, new Object[]{message}, "Resource Selection Criteria");
            this.add(SCV.class, false, 0, 80, new Object[]{message}, "Location Selection Criteria");
            this.add(NM.class, false, 1, 5, new Object[]{message}, "Slot Spacing Criteria");
            this.add(SCV.class, false, 0, 80, new Object[]{message}, "Filler Override Criteria");
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)("Can't instantiate " + ((Object)((Object)this)).getClass().getName()), (Throwable)he);
        }
    }

    public SCV getTimeSelectionCriteria(int rep) throws HL7Exception {
        SCV ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (SCV)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public SCV[] getTimeSelectionCriteria() {
        SCV[] ret = null;
        try {
            Type[] t = this.getField(1);
            ret = new SCV[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (SCV)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getTimeSelectionCriteriaReps() {
        try {
            return this.getField(1).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public SCV insertTimeSelectionCriteria(int index) throws HL7Exception {
        return (SCV)super.insertRepetition(1, index);
    }

    public SCV removeTimeSelectionCriteria(int index) throws HL7Exception {
        return (SCV)super.removeRepetition(1, index);
    }

    public SCV getApr1_TimeSelectionCriteria(int rep) throws HL7Exception {
        SCV ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (SCV)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public SCV[] getApr1_TimeSelectionCriteria() {
        SCV[] ret = null;
        try {
            Type[] t = this.getField(1);
            ret = new SCV[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (SCV)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getApr1_TimeSelectionCriteriaReps() {
        try {
            return this.getField(1).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public SCV insertApr1_TimeSelectionCriteria(int index) throws HL7Exception {
        return (SCV)super.insertRepetition(1, index);
    }

    public SCV removeApr1_TimeSelectionCriteria(int index) throws HL7Exception {
        return (SCV)super.removeRepetition(1, index);
    }

    public SCV getResourceSelectionCriteria(int rep) throws HL7Exception {
        SCV ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (SCV)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public SCV[] getResourceSelectionCriteria() {
        SCV[] ret = null;
        try {
            Type[] t = this.getField(2);
            ret = new SCV[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (SCV)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getResourceSelectionCriteriaReps() {
        try {
            return this.getField(2).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public SCV insertResourceSelectionCriteria(int index) throws HL7Exception {
        return (SCV)super.insertRepetition(2, index);
    }

    public SCV removeResourceSelectionCriteria(int index) throws HL7Exception {
        return (SCV)super.removeRepetition(2, index);
    }

    public SCV getApr2_ResourceSelectionCriteria(int rep) throws HL7Exception {
        SCV ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (SCV)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public SCV[] getApr2_ResourceSelectionCriteria() {
        SCV[] ret = null;
        try {
            Type[] t = this.getField(2);
            ret = new SCV[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (SCV)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getApr2_ResourceSelectionCriteriaReps() {
        try {
            return this.getField(2).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public SCV insertApr2_ResourceSelectionCriteria(int index) throws HL7Exception {
        return (SCV)super.insertRepetition(2, index);
    }

    public SCV removeApr2_ResourceSelectionCriteria(int index) throws HL7Exception {
        return (SCV)super.removeRepetition(2, index);
    }

    public SCV getLocationSelectionCriteria(int rep) throws HL7Exception {
        SCV ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (SCV)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public SCV[] getLocationSelectionCriteria() {
        SCV[] ret = null;
        try {
            Type[] t = this.getField(3);
            ret = new SCV[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (SCV)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getLocationSelectionCriteriaReps() {
        try {
            return this.getField(3).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public SCV insertLocationSelectionCriteria(int index) throws HL7Exception {
        return (SCV)super.insertRepetition(3, index);
    }

    public SCV removeLocationSelectionCriteria(int index) throws HL7Exception {
        return (SCV)super.removeRepetition(3, index);
    }

    public SCV getApr3_LocationSelectionCriteria(int rep) throws HL7Exception {
        SCV ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (SCV)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public SCV[] getApr3_LocationSelectionCriteria() {
        SCV[] ret = null;
        try {
            Type[] t = this.getField(3);
            ret = new SCV[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (SCV)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getApr3_LocationSelectionCriteriaReps() {
        try {
            return this.getField(3).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public SCV insertApr3_LocationSelectionCriteria(int index) throws HL7Exception {
        return (SCV)super.insertRepetition(3, index);
    }

    public SCV removeApr3_LocationSelectionCriteria(int index) throws HL7Exception {
        return (SCV)super.removeRepetition(3, index);
    }

    public NM getSlotSpacingCriteria() {
        NM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getApr4_SlotSpacingCriteria() {
        NM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SCV getFillerOverrideCriteria(int rep) throws HL7Exception {
        SCV ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (SCV)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public SCV[] getFillerOverrideCriteria() {
        SCV[] ret = null;
        try {
            Type[] t = this.getField(5);
            ret = new SCV[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (SCV)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getFillerOverrideCriteriaReps() {
        try {
            return this.getField(5).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public SCV insertFillerOverrideCriteria(int index) throws HL7Exception {
        return (SCV)super.insertRepetition(5, index);
    }

    public SCV removeFillerOverrideCriteria(int index) throws HL7Exception {
        return (SCV)super.removeRepetition(5, index);
    }

    public SCV getApr5_FillerOverrideCriteria(int rep) throws HL7Exception {
        SCV ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (SCV)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public SCV[] getApr5_FillerOverrideCriteria() {
        SCV[] ret = null;
        try {
            Type[] t = this.getField(5);
            ret = new SCV[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (SCV)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getApr5_FillerOverrideCriteriaReps() {
        try {
            return this.getField(5).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public SCV insertApr5_FillerOverrideCriteria(int index) throws HL7Exception {
        return (SCV)super.insertRepetition(5, index);
    }

    public SCV removeApr5_FillerOverrideCriteria(int index) throws HL7Exception {
        return (SCV)super.removeRepetition(5, index);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SCV(this.getMessage());
            }
            case 1: {
                return new SCV(this.getMessage());
            }
            case 2: {
                return new SCV(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new SCV(this.getMessage());
            }
        }
        return null;
    }
}

