/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.NM;
import ca.uhn.hl7v2.model.v25.datatype.RCD;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class RDF
extends AbstractSegment {
    public RDF(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        Message message = this.getMessage();
        try {
            this.add(NM.class, true, 1, 3, new Object[]{message}, "Number of Columns per Row");
            this.add(RCD.class, true, 0, 40, new Object[]{message}, "Column Description");
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)("Can't instantiate " + ((Object)((Object)this)).getClass().getName()), (Throwable)he);
        }
    }

    public NM getNumberOfColumnsPerRow() {
        NM ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getRdf1_NumberOfColumnsPerRow() {
        NM ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public RCD getColumnDescription(int rep) throws HL7Exception {
        RCD ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (RCD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public RCD[] getColumnDescription() {
        RCD[] ret = null;
        try {
            Type[] t = this.getField(2);
            ret = new RCD[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (RCD)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getColumnDescriptionReps() {
        try {
            return this.getField(2).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public RCD insertColumnDescription(int index) throws HL7Exception {
        return (RCD)super.insertRepetition(2, index);
    }

    public RCD removeColumnDescription(int index) throws HL7Exception {
        return (RCD)super.removeRepetition(2, index);
    }

    public RCD getRdf2_ColumnDescription(int rep) throws HL7Exception {
        RCD ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (RCD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        return ret;
    }

    public RCD[] getRdf2_ColumnDescription() {
        RCD[] ret = null;
        try {
            Type[] t = this.getField(2);
            ret = new RCD[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (RCD)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getRdf2_ColumnDescriptionReps() {
        try {
            return this.getField(2).length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public RCD insertRdf2_ColumnDescription(int index) throws HL7Exception {
        return (RCD)super.insertRepetition(2, index);
    }

    public RCD removeRdf2_ColumnDescription(int index) throws HL7Exception {
        return (RCD)super.removeRepetition(2, index);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new RCD(this.getMessage());
            }
        }
        return null;
    }
}

