/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.datatype;

import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.EI;
import ca.uhn.log.HapiLogFactory;

public class EIP
extends AbstractType
implements Composite {
    private Type[] data = new Type[2];

    public EIP(Message message) {
        super(message);
        this.data[0] = new EI(message);
        this.data[1] = new EI(message);
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist in 2 element EIP composite");
        }
    }

    public EI getPlacerAssignedIdentifier() {
        EI ret = null;
        try {
            ret = (EI)this.getComponent(0);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EI getEip1_PlacerAssignedIdentifier() {
        EI ret = null;
        try {
            ret = (EI)this.getComponent(0);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EI getFillerAssignedIdentifier() {
        EI ret = null;
        try {
            ret = (EI)this.getComponent(1);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EI getEip2_FillerAssignedIdentifier() {
        EI ret = null;
        try {
            ret = (EI)this.getComponent(1);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

