/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.datatype;

import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.DT;
import ca.uhn.hl7v2.model.v251.datatype.ID;
import ca.uhn.hl7v2.model.v251.datatype.ST;
import ca.uhn.log.HapiLogFactory;

public class SPD
extends AbstractType
implements Composite {
    private Type[] data = new Type[4];

    public SPD(Message message) {
        super(message);
        this.data[0] = new ST(message);
        this.data[1] = new ST(message);
        this.data[2] = new ID(message, 337);
        this.data[3] = new DT(message);
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist in 4 element SPD composite");
        }
    }

    public ST getSpecialtyName() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(0);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getSpd1_SpecialtyName() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(0);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getGoverningBoard() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(1);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getSpd2_GoverningBoard() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(1);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ID getEligibleOrCertified() {
        ID ret = null;
        try {
            ret = (ID)this.getComponent(2);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ID getSpd3_EligibleOrCertified() {
        ID ret = null;
        try {
            ret = (ID)this.getComponent(2);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DT getDateOfCertification() {
        DT ret = null;
        try {
            ret = (DT)this.getComponent(3);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DT getSpd4_DateOfCertification() {
        DT ret = null;
        try {
            ret = (DT)this.getComponent(3);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

