/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.datatype;

import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.ID;
import ca.uhn.hl7v2.model.v251.datatype.NM;
import ca.uhn.hl7v2.model.v251.datatype.ST;
import ca.uhn.log.HapiLogFactory;

public class XTN
extends AbstractType
implements Composite {
    private Type[] data = new Type[12];

    public XTN(Message message) {
        super(message);
        this.data[0] = new ST(message);
        this.data[1] = new ID(message, 201);
        this.data[2] = new ID(message, 202);
        this.data[3] = new ST(message);
        this.data[4] = new NM(message);
        this.data[5] = new NM(message);
        this.data[6] = new NM(message);
        this.data[7] = new NM(message);
        this.data[8] = new ST(message);
        this.data[9] = new ST(message);
        this.data[10] = new ST(message);
        this.data[11] = new ST(message);
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist in 12 element XTN composite");
        }
    }

    public ST getTelephoneNumber() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(0);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getXtn1_TelephoneNumber() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(0);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ID getTelecommunicationUseCode() {
        ID ret = null;
        try {
            ret = (ID)this.getComponent(1);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ID getXtn2_TelecommunicationUseCode() {
        ID ret = null;
        try {
            ret = (ID)this.getComponent(1);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ID getTelecommunicationEquipmentType() {
        ID ret = null;
        try {
            ret = (ID)this.getComponent(2);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ID getXtn3_TelecommunicationEquipmentType() {
        ID ret = null;
        try {
            ret = (ID)this.getComponent(2);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getEmailAddress() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(3);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getXtn4_EmailAddress() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(3);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NM getCountryCode() {
        NM ret = null;
        try {
            ret = (NM)this.getComponent(4);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NM getXtn5_CountryCode() {
        NM ret = null;
        try {
            ret = (NM)this.getComponent(4);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NM getAreaCityCode() {
        NM ret = null;
        try {
            ret = (NM)this.getComponent(5);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NM getXtn6_AreaCityCode() {
        NM ret = null;
        try {
            ret = (NM)this.getComponent(5);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NM getLocalNumber() {
        NM ret = null;
        try {
            ret = (NM)this.getComponent(6);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NM getXtn7_LocalNumber() {
        NM ret = null;
        try {
            ret = (NM)this.getComponent(6);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NM getExtension() {
        NM ret = null;
        try {
            ret = (NM)this.getComponent(7);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NM getXtn8_Extension() {
        NM ret = null;
        try {
            ret = (NM)this.getComponent(7);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getAnyText() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(8);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getXtn9_AnyText() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(8);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getExtensionPrefix() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(9);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getXtn10_ExtensionPrefix() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(9);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getSpeedDialCode() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(10);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getXtn11_SpeedDialCode() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(10);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getUnformattedTelephoneNumber() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(11);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getXtn12_UnformattedTelephoneNumber() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(11);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

