/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.segment.CSP;
import ca.uhn.hl7v2.model.v251.segment.CSR;
import ca.uhn.hl7v2.model.v251.segment.PID;
import ca.uhn.hl7v2.model.v251.segment.PV1;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class CRM_C01_PATIENT
extends AbstractGroup {
    public CRM_C01_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        try {
            this.add(PID.class, true, false);
            this.add(PV1.class, false, false);
            this.add(CSR.class, true, false);
            this.add(CSP.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating CRM_C01_PATIENT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PV1 getPV1() {
        PV1 ret = null;
        try {
            ret = (PV1)this.get("PV1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CSR getCSR() {
        CSR ret = null;
        try {
            ret = (CSR)this.get("CSR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CSP getCSP() {
        CSP ret = null;
        try {
            ret = (CSP)this.get("CSP");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CSP getCSP(int rep) throws HL7Exception {
        return (CSP)this.get("CSP", rep);
    }

    public int getCSPReps() {
        int reps = -1;
        try {
            reps = this.getAll("CSP").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertCSP(CSP structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public CSP insertCSP(int rep) throws HL7Exception {
        return (CSP)super.insertRepetition("CSP", rep);
    }

    public CSP removeCSP(int rep) throws HL7Exception {
        return (CSP)super.removeRepetition("CSP", rep);
    }
}

