/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.segment.LCC;
import ca.uhn.hl7v2.model.v251.segment.LCH;
import ca.uhn.hl7v2.model.v251.segment.LDP;
import ca.uhn.hl7v2.model.v251.segment.LOC;
import ca.uhn.hl7v2.model.v251.segment.LRL;
import ca.uhn.hl7v2.model.v251.segment.MFE;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class MFR_M05_MF_QUERY
extends AbstractGroup {
    public MFR_M05_MF_QUERY(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        try {
            this.add(MFE.class, true, false);
            this.add(LOC.class, true, false);
            this.add(LCH.class, false, true);
            this.add(LRL.class, false, true);
            this.add(LDP.class, true, true);
            this.add(LCH.class, false, true);
            this.add(LCC.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating MFR_M05_MF_QUERY - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public MFE getMFE() {
        MFE ret = null;
        try {
            ret = (MFE)this.get("MFE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public LOC getLOC() {
        LOC ret = null;
        try {
            ret = (LOC)this.get("LOC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public LCH getLCH() {
        LCH ret = null;
        try {
            ret = (LCH)this.get("LCH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public LCH getLCH(int rep) throws HL7Exception {
        return (LCH)this.get("LCH", rep);
    }

    public int getLCHReps() {
        int reps = -1;
        try {
            reps = this.getAll("LCH").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertLCH(LCH structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public LCH insertLCH(int rep) throws HL7Exception {
        return (LCH)super.insertRepetition("LCH", rep);
    }

    public LCH removeLCH(int rep) throws HL7Exception {
        return (LCH)super.removeRepetition("LCH", rep);
    }

    public LRL getLRL() {
        LRL ret = null;
        try {
            ret = (LRL)this.get("LRL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public LRL getLRL(int rep) throws HL7Exception {
        return (LRL)this.get("LRL", rep);
    }

    public int getLRLReps() {
        int reps = -1;
        try {
            reps = this.getAll("LRL").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertLRL(LRL structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public LRL insertLRL(int rep) throws HL7Exception {
        return (LRL)super.insertRepetition("LRL", rep);
    }

    public LRL removeLRL(int rep) throws HL7Exception {
        return (LRL)super.removeRepetition("LRL", rep);
    }

    public LDP getLDP() {
        LDP ret = null;
        try {
            ret = (LDP)this.get("LDP");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public LDP getLDP(int rep) throws HL7Exception {
        return (LDP)this.get("LDP", rep);
    }

    public int getLDPReps() {
        int reps = -1;
        try {
            reps = this.getAll("LDP").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertLDP(LDP structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public LDP insertLDP(int rep) throws HL7Exception {
        return (LDP)super.insertRepetition("LDP", rep);
    }

    public LDP removeLDP(int rep) throws HL7Exception {
        return (LDP)super.removeRepetition("LDP", rep);
    }

    public LCH getLCH2() {
        LCH ret = null;
        try {
            ret = (LCH)this.get("LCH2");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public LCH getLCH2(int rep) throws HL7Exception {
        return (LCH)this.get("LCH2", rep);
    }

    public int getLCH2Reps() {
        int reps = -1;
        try {
            reps = this.getAll("LCH2").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertLCH2(LCH structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public LCH insertLCH2(int rep) throws HL7Exception {
        return (LCH)super.insertRepetition("LCH2", rep);
    }

    public LCH removeLCH2(int rep) throws HL7Exception {
        return (LCH)super.removeRepetition("LCH2", rep);
    }

    public LCC getLCC() {
        LCC ret = null;
        try {
            ret = (LCC)this.get("LCC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public LCC getLCC(int rep) throws HL7Exception {
        return (LCC)this.get("LCC", rep);
    }

    public int getLCCReps() {
        int reps = -1;
        try {
            reps = this.getAll("LCC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertLCC(LCC structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public LCC insertLCC(int rep) throws HL7Exception {
        return (LCC)super.insertRepetition("LCC", rep);
    }

    public LCC removeLCC(int rep) throws HL7Exception {
        return (LCC)super.removeRepetition("LCC", rep);
    }
}

