/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.segment.CM0;
import ca.uhn.hl7v2.model.v251.segment.CM1;
import ca.uhn.hl7v2.model.v251.segment.CM2;
import ca.uhn.hl7v2.model.v251.segment.MFE;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class MFR_M06_MF_QUERY
extends AbstractGroup {
    public MFR_M06_MF_QUERY(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        try {
            this.add(MFE.class, true, false);
            this.add(CM0.class, true, false);
            this.add(CM1.class, false, true);
            this.add(CM2.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating MFR_M06_MF_QUERY - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public MFE getMFE() {
        MFE ret = null;
        try {
            ret = (MFE)this.get("MFE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CM0 getCM0() {
        CM0 ret = null;
        try {
            ret = (CM0)this.get("CM0");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CM1 getCM1() {
        CM1 ret = null;
        try {
            ret = (CM1)this.get("CM1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CM1 getCM1(int rep) throws HL7Exception {
        return (CM1)this.get("CM1", rep);
    }

    public int getCM1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("CM1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertCM1(CM1 structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public CM1 insertCM1(int rep) throws HL7Exception {
        return (CM1)super.insertRepetition("CM1", rep);
    }

    public CM1 removeCM1(int rep) throws HL7Exception {
        return (CM1)super.removeRepetition("CM1", rep);
    }

    public CM2 getCM2() {
        CM2 ret = null;
        try {
            ret = (CM2)this.get("CM2");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CM2 getCM2(int rep) throws HL7Exception {
        return (CM2)this.get("CM2", rep);
    }

    public int getCM2Reps() {
        int reps = -1;
        try {
            reps = this.getAll("CM2").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertCM2(CM2 structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public CM2 insertCM2(int rep) throws HL7Exception {
        return (CM2)super.insertRepetition("CM2", rep);
    }

    public CM2 removeCM2(int rep) throws HL7Exception {
        return (CM2)super.removeRepetition("CM2", rep);
    }
}

