/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.OUL_R22_CONTAINER;
import ca.uhn.hl7v2.model.v251.group.OUL_R22_ORDER;
import ca.uhn.hl7v2.model.v251.segment.OBX;
import ca.uhn.hl7v2.model.v251.segment.SPM;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class OUL_R22_SPECIMEN
extends AbstractGroup {
    public OUL_R22_SPECIMEN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        try {
            this.add(SPM.class, true, false);
            this.add(OBX.class, false, true);
            this.add(OUL_R22_CONTAINER.class, false, true);
            this.add(OUL_R22_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating OUL_R22_SPECIMEN - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SPM getSPM() {
        SPM ret = null;
        try {
            ret = (SPM)this.get("SPM");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OBX getOBX() {
        OBX ret = null;
        try {
            ret = (OBX)this.get("OBX");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OBX getOBX(int rep) throws HL7Exception {
        return (OBX)this.get("OBX", rep);
    }

    public int getOBXReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBX").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public OUL_R22_CONTAINER getCONTAINER() {
        OUL_R22_CONTAINER ret = null;
        try {
            ret = (OUL_R22_CONTAINER)this.get("CONTAINER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OUL_R22_CONTAINER getCONTAINER(int rep) throws HL7Exception {
        return (OUL_R22_CONTAINER)this.get("CONTAINER", rep);
    }

    public int getCONTAINERReps() {
        int reps = -1;
        try {
            reps = this.getAll("CONTAINER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertCONTAINER(OUL_R22_CONTAINER structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public OUL_R22_CONTAINER insertCONTAINER(int rep) throws HL7Exception {
        return (OUL_R22_CONTAINER)super.insertRepetition("CONTAINER", rep);
    }

    public OUL_R22_CONTAINER removeCONTAINER(int rep) throws HL7Exception {
        return (OUL_R22_CONTAINER)super.removeRepetition("CONTAINER", rep);
    }

    public OUL_R22_ORDER getORDER() {
        OUL_R22_ORDER ret = null;
        try {
            ret = (OUL_R22_ORDER)this.get("ORDER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OUL_R22_ORDER getORDER(int rep) throws HL7Exception {
        return (OUL_R22_ORDER)this.get("ORDER", rep);
    }

    public int getORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORDER(OUL_R22_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public OUL_R22_ORDER insertORDER(int rep) throws HL7Exception {
        return (OUL_R22_ORDER)super.insertRepetition("ORDER", rep);
    }

    public OUL_R22_ORDER removeORDER(int rep) throws HL7Exception {
        return (OUL_R22_ORDER)super.removeRepetition("ORDER", rep);
    }
}

