/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.PTR_PCF_PATHWAY;
import ca.uhn.hl7v2.model.v251.group.PTR_PCF_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v251.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PTR_PCF_PATIENT
extends AbstractGroup {
    public PTR_PCF_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        try {
            this.add(PID.class, true, false);
            this.add(PTR_PCF_PATIENT_VISIT.class, false, false);
            this.add(PTR_PCF_PATHWAY.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating PTR_PCF_PATIENT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PTR_PCF_PATIENT_VISIT getPATIENT_VISIT() {
        PTR_PCF_PATIENT_VISIT ret = null;
        try {
            ret = (PTR_PCF_PATIENT_VISIT)this.get("PATIENT_VISIT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PTR_PCF_PATHWAY getPATHWAY() {
        PTR_PCF_PATHWAY ret = null;
        try {
            ret = (PTR_PCF_PATHWAY)this.get("PATHWAY");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PTR_PCF_PATHWAY getPATHWAY(int rep) throws HL7Exception {
        return (PTR_PCF_PATHWAY)this.get("PATHWAY", rep);
    }

    public int getPATHWAYReps() {
        int reps = -1;
        try {
            reps = this.getAll("PATHWAY").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPATHWAY(PTR_PCF_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public PTR_PCF_PATHWAY insertPATHWAY(int rep) throws HL7Exception {
        return (PTR_PCF_PATHWAY)super.insertRepetition("PATHWAY", rep);
    }

    public PTR_PCF_PATHWAY removePATHWAY(int rep) throws HL7Exception {
        return (PTR_PCF_PATHWAY)super.removeRepetition("PATHWAY", rep);
    }
}

