/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.PTR_PCF_GOAL;
import ca.uhn.hl7v2.model.v251.group.PTR_PCF_ORDER;
import ca.uhn.hl7v2.model.v251.group.PTR_PCF_PROBLEM_OBSERVATION;
import ca.uhn.hl7v2.model.v251.group.PTR_PCF_PROBLEM_ROLE;
import ca.uhn.hl7v2.model.v251.segment.NTE;
import ca.uhn.hl7v2.model.v251.segment.PRB;
import ca.uhn.hl7v2.model.v251.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PTR_PCF_PROBLEM
extends AbstractGroup {
    public PTR_PCF_PROBLEM(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        try {
            this.add(PRB.class, true, false);
            this.add(NTE.class, false, true);
            this.add(VAR.class, false, true);
            this.add(PTR_PCF_PROBLEM_ROLE.class, false, true);
            this.add(PTR_PCF_PROBLEM_OBSERVATION.class, false, true);
            this.add(PTR_PCF_GOAL.class, false, true);
            this.add(PTR_PCF_ORDER.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating PTR_PCF_PROBLEM - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public PRB getPRB() {
        PRB ret = null;
        try {
            ret = (PRB)this.get("PRB");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) throws HL7Exception {
        return (NTE)this.get("NTE", rep);
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public VAR getVAR() {
        VAR ret = null;
        try {
            ret = (VAR)this.get("VAR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VAR getVAR(int rep) throws HL7Exception {
        return (VAR)this.get("VAR", rep);
    }

    public int getVARReps() {
        int reps = -1;
        try {
            reps = this.getAll("VAR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public PTR_PCF_PROBLEM_ROLE getPROBLEM_ROLE() {
        PTR_PCF_PROBLEM_ROLE ret = null;
        try {
            ret = (PTR_PCF_PROBLEM_ROLE)this.get("PROBLEM_ROLE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PTR_PCF_PROBLEM_ROLE getPROBLEM_ROLE(int rep) throws HL7Exception {
        return (PTR_PCF_PROBLEM_ROLE)this.get("PROBLEM_ROLE", rep);
    }

    public int getPROBLEM_ROLEReps() {
        int reps = -1;
        try {
            reps = this.getAll("PROBLEM_ROLE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPROBLEM_ROLE(PTR_PCF_PROBLEM_ROLE structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public PTR_PCF_PROBLEM_ROLE insertPROBLEM_ROLE(int rep) throws HL7Exception {
        return (PTR_PCF_PROBLEM_ROLE)super.insertRepetition("PROBLEM_ROLE", rep);
    }

    public PTR_PCF_PROBLEM_ROLE removePROBLEM_ROLE(int rep) throws HL7Exception {
        return (PTR_PCF_PROBLEM_ROLE)super.removeRepetition("PROBLEM_ROLE", rep);
    }

    public PTR_PCF_PROBLEM_OBSERVATION getPROBLEM_OBSERVATION() {
        PTR_PCF_PROBLEM_OBSERVATION ret = null;
        try {
            ret = (PTR_PCF_PROBLEM_OBSERVATION)this.get("PROBLEM_OBSERVATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PTR_PCF_PROBLEM_OBSERVATION getPROBLEM_OBSERVATION(int rep) throws HL7Exception {
        return (PTR_PCF_PROBLEM_OBSERVATION)this.get("PROBLEM_OBSERVATION", rep);
    }

    public int getPROBLEM_OBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("PROBLEM_OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPROBLEM_OBSERVATION(PTR_PCF_PROBLEM_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public PTR_PCF_PROBLEM_OBSERVATION insertPROBLEM_OBSERVATION(int rep) throws HL7Exception {
        return (PTR_PCF_PROBLEM_OBSERVATION)super.insertRepetition("PROBLEM_OBSERVATION", rep);
    }

    public PTR_PCF_PROBLEM_OBSERVATION removePROBLEM_OBSERVATION(int rep) throws HL7Exception {
        return (PTR_PCF_PROBLEM_OBSERVATION)super.removeRepetition("PROBLEM_OBSERVATION", rep);
    }

    public PTR_PCF_GOAL getGOAL() {
        PTR_PCF_GOAL ret = null;
        try {
            ret = (PTR_PCF_GOAL)this.get("GOAL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PTR_PCF_GOAL getGOAL(int rep) throws HL7Exception {
        return (PTR_PCF_GOAL)this.get("GOAL", rep);
    }

    public int getGOALReps() {
        int reps = -1;
        try {
            reps = this.getAll("GOAL").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertGOAL(PTR_PCF_GOAL structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public PTR_PCF_GOAL insertGOAL(int rep) throws HL7Exception {
        return (PTR_PCF_GOAL)super.insertRepetition("GOAL", rep);
    }

    public PTR_PCF_GOAL removeGOAL(int rep) throws HL7Exception {
        return (PTR_PCF_GOAL)super.removeRepetition("GOAL", rep);
    }

    public PTR_PCF_ORDER getORDER() {
        PTR_PCF_ORDER ret = null;
        try {
            ret = (PTR_PCF_ORDER)this.get("ORDER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PTR_PCF_ORDER getORDER(int rep) throws HL7Exception {
        return (PTR_PCF_ORDER)this.get("ORDER", rep);
    }

    public int getORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORDER(PTR_PCF_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public PTR_PCF_ORDER insertORDER(int rep) throws HL7Exception {
        return (PTR_PCF_ORDER)super.insertRepetition("ORDER", rep);
    }

    public PTR_PCF_ORDER removeORDER(int rep) throws HL7Exception {
        return (PTR_PCF_ORDER)super.removeRepetition("ORDER", rep);
    }
}

