/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.SQR_S25_PATIENT;
import ca.uhn.hl7v2.model.v251.group.SQR_S25_RESOURCES;
import ca.uhn.hl7v2.model.v251.segment.NTE;
import ca.uhn.hl7v2.model.v251.segment.SCH;
import ca.uhn.hl7v2.model.v251.segment.TQ1;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class SQR_S25_SCHEDULE
extends AbstractGroup {
    public SQR_S25_SCHEDULE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        try {
            this.add(SCH.class, true, false);
            this.add(TQ1.class, false, true);
            this.add(NTE.class, false, true);
            this.add(SQR_S25_PATIENT.class, false, false);
            this.add(SQR_S25_RESOURCES.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating SQR_S25_SCHEDULE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SCH getSCH() {
        SCH ret = null;
        try {
            ret = (SCH)this.get("SCH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TQ1 getTQ1() {
        TQ1 ret = null;
        try {
            ret = (TQ1)this.get("TQ1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TQ1 getTQ1(int rep) throws HL7Exception {
        return (TQ1)this.get("TQ1", rep);
    }

    public int getTQ1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("TQ1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertTQ1(TQ1 structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public TQ1 insertTQ1(int rep) throws HL7Exception {
        return (TQ1)super.insertRepetition("TQ1", rep);
    }

    public TQ1 removeTQ1(int rep) throws HL7Exception {
        return (TQ1)super.removeRepetition("TQ1", rep);
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) throws HL7Exception {
        return (NTE)this.get("NTE", rep);
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public SQR_S25_PATIENT getPATIENT() {
        SQR_S25_PATIENT ret = null;
        try {
            ret = (SQR_S25_PATIENT)this.get("PATIENT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SQR_S25_RESOURCES getRESOURCES() {
        SQR_S25_RESOURCES ret = null;
        try {
            ret = (SQR_S25_RESOURCES)this.get("RESOURCES");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SQR_S25_RESOURCES getRESOURCES(int rep) throws HL7Exception {
        return (SQR_S25_RESOURCES)this.get("RESOURCES", rep);
    }

    public int getRESOURCESReps() {
        int reps = -1;
        try {
            reps = this.getAll("RESOURCES").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertRESOURCES(SQR_S25_RESOURCES structure, int rep) throws HL7Exception {
        super.insertRepetition((Structure)structure, rep);
    }

    public SQR_S25_RESOURCES insertRESOURCES(int rep) throws HL7Exception {
        return (SQR_S25_RESOURCES)super.insertRepetition("RESOURCES", rep);
    }

    public SQR_S25_RESOURCES removeRESOURCES(int rep) throws HL7Exception {
        return (SQR_S25_RESOURCES)super.removeRepetition("RESOURCES", rep);
    }
}

